/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackError;
import com.hubspot.slack.client.models.response.SlackErrorResponseIF;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackErrorResponse
implements SlackErrorResponseIF {
    @Nullable
    private final SlackError error;
    private final List<SlackError> errors;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private SlackErrorResponse(@Nullable SlackError error, List<SlackError> errors, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.error = error;
        this.errors = errors;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public Optional<SlackError> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    @JsonProperty
    public List<SlackError> getErrors() {
        return this.errors;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final SlackErrorResponse withError(@Nullable SlackError value) {
        SlackError newValue = value;
        if (this.error == newValue) {
            return this;
        }
        return new SlackErrorResponse(newValue, this.errors, this.ok, this.responseMetadata);
    }

    public final SlackErrorResponse withError(Optional<SlackError> optional) {
        SlackError value = optional.orElse(null);
        if (this.error == value) {
            return this;
        }
        return new SlackErrorResponse(value, this.errors, this.ok, this.responseMetadata);
    }

    public final SlackErrorResponse withErrors(SlackError ... elements) {
        List<SlackError> newValue = SlackErrorResponse.createUnmodifiableList(false, SlackErrorResponse.createSafeList(Arrays.asList(elements), true, false));
        return new SlackErrorResponse(this.error, newValue, this.ok, this.responseMetadata);
    }

    public final SlackErrorResponse withErrors(Iterable<? extends SlackError> elements) {
        if (this.errors == elements) {
            return this;
        }
        List<SlackError> newValue = SlackErrorResponse.createUnmodifiableList(false, SlackErrorResponse.createSafeList(elements, true, false));
        return new SlackErrorResponse(this.error, newValue, this.ok, this.responseMetadata);
    }

    public final SlackErrorResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new SlackErrorResponse(this.error, this.errors, ok, this.responseMetadata);
    }

    public final SlackErrorResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new SlackErrorResponse(this.error, this.errors, this.ok, newValue);
    }

    public final SlackErrorResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new SlackErrorResponse(this.error, this.errors, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackErrorResponse && this.equalTo((SlackErrorResponse)another);
    }

    private boolean equalTo(SlackErrorResponse another) {
        return Objects.equals(this.error, another.error) && this.errors.equals(another.errors) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.error);
        h = h * 17 + this.errors.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackErrorResponse{");
        if (this.error != null) {
            builder.append("error=").append(this.error);
        }
        if (builder.length() > 19) {
            builder.append(", ");
        }
        builder.append("errors=").append(this.errors);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackErrorResponse fromJson(Json json) {
        Builder builder = SlackErrorResponse.builder();
        if (json.error != null) {
            builder.setError(json.error);
        }
        if (json.errors != null) {
            builder.addAllErrors(json.errors);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static SlackErrorResponse copyOf(SlackErrorResponseIF instance) {
        if (instance instanceof SlackErrorResponse) {
            return (SlackErrorResponse)instance;
        }
        return SlackErrorResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        @Nullable
        private SlackError error;
        private List<SlackError> errors = new ArrayList<SlackError>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackErrorResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackErrorResponseIF) {
                instance = (SlackErrorResponseIF)object;
                Optional<SlackError> errorOptional = instance.getError();
                if (errorOptional.isPresent()) {
                    this.setError(errorOptional);
                }
                this.addAllErrors(instance.getErrors());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder setError(@Nullable SlackError error) {
            this.error = error;
            return this;
        }

        public final Builder setError(Optional<SlackError> error) {
            this.error = error.orElse(null);
            return this;
        }

        public final Builder addErrors(SlackError element) {
            this.errors.add(Objects.requireNonNull(element, "errors element"));
            return this;
        }

        public final Builder addErrors(SlackError ... elements) {
            for (SlackError element : elements) {
                this.errors.add(Objects.requireNonNull(element, "errors element"));
            }
            return this;
        }

        public final Builder setErrors(Iterable<? extends SlackError> elements) {
            this.errors.clear();
            return this.addAllErrors(elements);
        }

        public final Builder addAllErrors(Iterable<? extends SlackError> elements) {
            for (SlackError slackError : elements) {
                this.errors.add(Objects.requireNonNull(slackError, "errors element"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public SlackErrorResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackErrorResponse(this.error, SlackErrorResponse.createUnmodifiableList(true, this.errors), this.ok, this.responseMetadata);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build SlackErrorResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackErrorResponseIF {
        Optional<SlackError> error = Optional.empty();
        List<SlackError> errors = Collections.emptyList();
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setError(Optional<SlackError> error) {
            this.error = error;
        }

        @JsonProperty
        public void setErrors(List<SlackError> errors) {
            this.errors = errors;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public Optional<SlackError> getError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackError> getErrors() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

