/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatPostEphemeralMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChatPostEphemeralMessageResponse
implements ChatPostEphemeralMessageResponseIF {
    private final String messageTs;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ChatPostEphemeralMessageResponse(String messageTs, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.messageTs = messageTs;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public String getMessageTs() {
        return this.messageTs;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ChatPostEphemeralMessageResponse withMessageTs(String messageTs) {
        if (this.messageTs.equals(messageTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(messageTs, "messageTs");
        return new ChatPostEphemeralMessageResponse(newValue, this.ok, this.responseMetadata);
    }

    public final ChatPostEphemeralMessageResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ChatPostEphemeralMessageResponse(this.messageTs, ok, this.responseMetadata);
    }

    public final ChatPostEphemeralMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatPostEphemeralMessageResponse(this.messageTs, this.ok, newValue);
    }

    public final ChatPostEphemeralMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatPostEphemeralMessageResponse(this.messageTs, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatPostEphemeralMessageResponse && this.equalTo((ChatPostEphemeralMessageResponse)another);
    }

    private boolean equalTo(ChatPostEphemeralMessageResponse another) {
        return this.messageTs.equals(another.messageTs) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.messageTs.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatPostEphemeralMessageResponse{");
        builder.append("messageTs=").append(this.messageTs);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChatPostEphemeralMessageResponse fromJson(Json json) {
        Builder builder = ChatPostEphemeralMessageResponse.builder();
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ChatPostEphemeralMessageResponse copyOf(ChatPostEphemeralMessageResponseIF instance) {
        if (instance instanceof ChatPostEphemeralMessageResponse) {
            return (ChatPostEphemeralMessageResponse)instance;
        }
        return ChatPostEphemeralMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MESSAGE_TS = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        @Nullable
        private String messageTs;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatPostEphemeralMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ChatPostEphemeralMessageResponseIF) {
                instance = (ChatPostEphemeralMessageResponseIF)object;
                this.setMessageTs(instance.getMessageTs());
            }
        }

        public final Builder setMessageTs(String messageTs) {
            this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ChatPostEphemeralMessageResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChatPostEphemeralMessageResponse(this.messageTs, this.ok, this.responseMetadata);
        }

        private boolean messageTsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.messageTsIsSet()) {
                attributes.add("messageTs");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChatPostEphemeralMessageResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChatPostEphemeralMessageResponseIF {
        @Nullable
        String messageTs;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setMessageTs(String messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public String getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

