/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatPostMessageResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChatPostMessageResponse
implements ChatPostMessageResponseIF {
    private final String ts;
    private final String channel;
    private final Map<String, Object> message;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ChatPostMessageResponse(String ts, String channel, Map<String, Object> message, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.ts = ts;
        this.channel = channel;
        this.message = message;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ChatPostMessageResponse withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new ChatPostMessageResponse(newValue, this.channel, this.message, this.ok, this.responseMetadata);
    }

    public final ChatPostMessageResponse withChannel(String channel) {
        if (this.channel.equals(channel)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channel, "channel");
        return new ChatPostMessageResponse(this.ts, newValue, this.message, this.ok, this.responseMetadata);
    }

    public final ChatPostMessageResponse withMessage(Map<String, ? extends Object> message) {
        if (this.message == message) {
            return this;
        }
        Map<String, Object> newValue = ChatPostMessageResponse.createUnmodifiableMap(true, false, message);
        return new ChatPostMessageResponse(this.ts, this.channel, newValue, this.ok, this.responseMetadata);
    }

    public final ChatPostMessageResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ChatPostMessageResponse(this.ts, this.channel, this.message, ok, this.responseMetadata);
    }

    public final ChatPostMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatPostMessageResponse(this.ts, this.channel, this.message, this.ok, newValue);
    }

    public final ChatPostMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatPostMessageResponse(this.ts, this.channel, this.message, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatPostMessageResponse && this.equalTo((ChatPostMessageResponse)another);
    }

    private boolean equalTo(ChatPostMessageResponse another) {
        return this.ts.equals(another.ts) && this.channel.equals(another.channel) && this.message.equals(another.message) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.ts.hashCode();
        h = h * 17 + this.channel.hashCode();
        h = h * 17 + this.message.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatPostMessageResponse{");
        builder.append("ts=").append(this.ts);
        builder.append(", ");
        builder.append("channel=").append(this.channel);
        builder.append(", ");
        builder.append("message=").append(this.message);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChatPostMessageResponse fromJson(Json json) {
        Builder builder = ChatPostMessageResponse.builder();
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.message != null) {
            builder.putAllMessage(json.message);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ChatPostMessageResponse copyOf(ChatPostMessageResponseIF instance) {
        if (instance instanceof ChatPostMessageResponse) {
            return (ChatPostMessageResponse)instance;
        }
        return ChatPostMessageResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TS = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private static final long INIT_BIT_OK = 4L;
        private long initBits = 7L;
        @Nullable
        private String ts;
        @Nullable
        private String channel;
        private Map<String, Object> message = new LinkedHashMap<String, Object>();
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(ChatPostMessageResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof ChatPostMessageResponseIF) {
                instance = (ChatPostMessageResponseIF)object;
                this.setChannel(instance.getChannel());
                this.putAllMessage(instance.getMessage());
                this.setTs(instance.getTs());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder putMessage(String key, Object value) {
            this.message.put(Objects.requireNonNull(key, "message key"), Objects.requireNonNull(value, "message value"));
            return this;
        }

        public final Builder putMessage(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.message.put(Objects.requireNonNull(k, "message key"), Objects.requireNonNull(v, "message value"));
            return this;
        }

        public final Builder setMessage(Map<String, ? extends Object> message) {
            this.message.clear();
            return this.putAllMessage(message);
        }

        public final Builder putAllMessage(Map<String, ? extends Object> message) {
            for (Map.Entry<String, ? extends Object> entry : message.entrySet()) {
                String k = entry.getKey();
                Object v = entry.getValue();
                this.message.put(Objects.requireNonNull(k, "message key"), Objects.requireNonNull(v, "message value"));
            }
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ChatPostMessageResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChatPostMessageResponse(this.ts, this.channel, ChatPostMessageResponse.createUnmodifiableMap(false, false, this.message), this.ok, this.responseMetadata);
        }

        private boolean tsIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChatPostMessageResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChatPostMessageResponseIF {
        @Nullable
        String ts;
        @Nullable
        String channel;
        @Nullable
        Map<String, Object> message;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setMessage(Map<String, Object> message) {
            this.message = message;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

