/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.views.ModalViewCommandResponseIF;
import com.hubspot.slack.client.models.response.views.ModalViewResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ModalViewCommandResponse
implements ModalViewCommandResponseIF {
    private final ModalViewResponse view;
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;

    private ModalViewCommandResponse(ModalViewResponse view, boolean ok, @Nullable ResponseMetadata responseMetadata) {
        this.view = view;
        this.ok = ok;
        this.responseMetadata = responseMetadata;
    }

    @Override
    @JsonProperty
    public ModalViewResponse getView() {
        return this.view;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    public final ModalViewCommandResponse withView(ModalViewResponse view) {
        if (this.view == view) {
            return this;
        }
        ModalViewResponse newValue = Objects.requireNonNull(view, "view");
        return new ModalViewCommandResponse(newValue, this.ok, this.responseMetadata);
    }

    public final ModalViewCommandResponse withOk(boolean ok) {
        if (this.ok == ok) {
            return this;
        }
        return new ModalViewCommandResponse(this.view, ok, this.responseMetadata);
    }

    public final ModalViewCommandResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ModalViewCommandResponse(this.view, this.ok, newValue);
    }

    public final ModalViewCommandResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ModalViewCommandResponse(this.view, this.ok, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ModalViewCommandResponse && this.equalTo((ModalViewCommandResponse)another);
    }

    private boolean equalTo(ModalViewCommandResponse another) {
        return this.view.equals(another.view) && this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.view.hashCode();
        h = h * 17 + Boolean.hashCode(this.ok);
        h = h * 17 + Objects.hashCode(this.responseMetadata);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ModalViewCommandResponse{");
        builder.append("view=").append(this.view);
        builder.append(", ");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ModalViewCommandResponse fromJson(Json json) {
        Builder builder = ModalViewCommandResponse.builder();
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        return builder.build();
    }

    public static ModalViewCommandResponse copyOf(ModalViewCommandResponseIF instance) {
        if (instance instanceof ModalViewCommandResponse) {
            return (ModalViewCommandResponse)instance;
        }
        return ModalViewCommandResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VIEW = 1L;
        private static final long INIT_BIT_OK = 2L;
        private long initBits = 3L;
        @Nullable
        private ModalViewResponse view;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModalViewCommandResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SlackResponse instance;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                this.setOk(instance.isOk());
                Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
                if (responseMetadataOptional.isPresent()) {
                    this.setResponseMetadata(responseMetadataOptional);
                }
            }
            if (object instanceof ModalViewCommandResponseIF) {
                instance = (ModalViewCommandResponseIF)object;
                this.setView(instance.getView());
            }
        }

        public final Builder setView(ModalViewResponse view) {
            this.view = Objects.requireNonNull(view, "view");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public ModalViewCommandResponse build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ModalViewCommandResponse(this.view, this.ok, this.responseMetadata);
        }

        private boolean viewIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean okIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.viewIsSet()) {
                attributes.add("view");
            }
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ModalViewCommandResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ModalViewCommandResponseIF {
        @Nullable
        ModalViewResponse view;
        boolean ok;
        boolean okIsSet;
        Optional<ResponseMetadata> responseMetadata = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setView(ModalViewResponse view) {
            this.view = view;
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @Override
        public ModalViewResponse getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

