/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.views.StateActionIF;
import com.hubspot.slack.client.models.response.views.StateActionValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class StateAction
implements StateActionIF {
    private final Map<String, StateActionValue> actionValues;

    private StateAction(Map<String, StateActionValue> actionValues) {
        this.actionValues = actionValues;
    }

    @Override
    @JsonProperty
    @JsonAnyGetter
    public Map<String, StateActionValue> getActionValues() {
        return this.actionValues;
    }

    public final StateAction withActionValues(Map<String, ? extends StateActionValue> actionValues) {
        if (this.actionValues == actionValues) {
            return this;
        }
        Map<String, StateActionValue> newValue = StateAction.createUnmodifiableMap(true, false, actionValues);
        return new StateAction(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StateAction && this.equalTo((StateAction)another);
    }

    private boolean equalTo(StateAction another) {
        return this.actionValues.equals(another.actionValues);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.actionValues.hashCode();
        return h;
    }

    public String toString() {
        return "StateAction{actionValues=" + this.actionValues + "}";
    }

    @Deprecated
    @JsonCreator
    static StateAction fromJson(Json json) {
        Builder builder = StateAction.builder();
        if (json.actionValues != null) {
            builder.putAllActionValues(json.actionValues);
        }
        return builder.build();
    }

    public static StateAction copyOf(StateActionIF instance) {
        if (instance instanceof StateAction) {
            return (StateAction)instance;
        }
        return StateAction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private Map<String, StateActionValue> actionValues = new LinkedHashMap<String, StateActionValue>();

        private Builder() {
        }

        public final Builder from(StateActionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllActionValues(instance.getActionValues());
            return this;
        }

        public final Builder putActionValues(String key, StateActionValue value) {
            this.actionValues.put(Objects.requireNonNull(key, "actionValues key"), Objects.requireNonNull(value, "actionValues value"));
            return this;
        }

        public final Builder putActionValues(Map.Entry<String, ? extends StateActionValue> entry) {
            String k = entry.getKey();
            StateActionValue v = entry.getValue();
            this.actionValues.put(Objects.requireNonNull(k, "actionValues key"), Objects.requireNonNull(v, "actionValues value"));
            return this;
        }

        public final Builder setActionValues(Map<String, ? extends StateActionValue> actionValues) {
            this.actionValues.clear();
            return this.putAllActionValues(actionValues);
        }

        public final Builder putAllActionValues(Map<String, ? extends StateActionValue> actionValues) {
            for (Map.Entry<String, ? extends StateActionValue> entry : actionValues.entrySet()) {
                String k = entry.getKey();
                StateActionValue v = entry.getValue();
                this.actionValues.put(Objects.requireNonNull(k, "actionValues key"), Objects.requireNonNull(v, "actionValues value"));
            }
            return this;
        }

        public StateAction build() throws InvalidImmutableStateException {
            return new StateAction(StateAction.createUnmodifiableMap(false, false, this.actionValues));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements StateActionIF {
        final Map<String, StateActionValue> actionValues = new HashMap<String, StateActionValue>();

        Json() {
        }

        @JsonAnySetter
        public void setActionValues(String key, StateActionValue value) {
            this.actionValues.put(key, value);
        }

        @Override
        public Map<String, StateActionValue> getActionValues() {
            throw new UnsupportedOperationException();
        }
    }
}

