/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.views;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.views.StateAction;
import com.hubspot.slack.client.models.response.views.StateBlockIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class StateBlock
implements StateBlockIF {
    private final Map<String, StateAction> actions;

    private StateBlock(Map<String, StateAction> actions) {
        this.actions = actions;
    }

    @Override
    @JsonProperty
    @JsonAnyGetter
    public Map<String, StateAction> getActions() {
        return this.actions;
    }

    public final StateBlock withActions(Map<String, ? extends StateAction> actions) {
        if (this.actions == actions) {
            return this;
        }
        Map<String, StateAction> newValue = StateBlock.createUnmodifiableMap(true, false, actions);
        return new StateBlock(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StateBlock && this.equalTo((StateBlock)another);
    }

    private boolean equalTo(StateBlock another) {
        return this.actions.equals(another.actions);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.actions.hashCode();
        return h;
    }

    public String toString() {
        return "StateBlock{actions=" + this.actions + "}";
    }

    @Deprecated
    @JsonCreator
    static StateBlock fromJson(Json json) {
        Builder builder = StateBlock.builder();
        if (json.actions != null) {
            builder.putAllActions(json.actions);
        }
        return builder.build();
    }

    public static StateBlock copyOf(StateBlockIF instance) {
        if (instance instanceof StateBlock) {
            return (StateBlock)instance;
        }
        return StateBlock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @NotThreadSafe
    public static final class Builder {
        private Map<String, StateAction> actions = new LinkedHashMap<String, StateAction>();

        private Builder() {
        }

        public final Builder from(StateBlockIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllActions(instance.getActions());
            return this;
        }

        public final Builder putActions(String key, StateAction value) {
            this.actions.put(Objects.requireNonNull(key, "actions key"), Objects.requireNonNull(value, "actions value"));
            return this;
        }

        public final Builder putActions(Map.Entry<String, ? extends StateAction> entry) {
            String k = entry.getKey();
            StateAction v = entry.getValue();
            this.actions.put(Objects.requireNonNull(k, "actions key"), Objects.requireNonNull(v, "actions value"));
            return this;
        }

        public final Builder setActions(Map<String, ? extends StateAction> actions) {
            this.actions.clear();
            return this.putAllActions(actions);
        }

        public final Builder putAllActions(Map<String, ? extends StateAction> actions) {
            for (Map.Entry<String, ? extends StateAction> entry : actions.entrySet()) {
                String k = entry.getKey();
                StateAction v = entry.getValue();
                this.actions.put(Objects.requireNonNull(k, "actions key"), Objects.requireNonNull(v, "actions value"));
            }
            return this;
        }

        public StateBlock build() throws InvalidImmutableStateException {
            return new StateBlock(StateBlock.createUnmodifiableMap(false, false, this.actions));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements StateBlockIF {
        final Map<String, StateAction> actions = new HashMap<String, StateAction>();

        Json() {
        }

        @JsonAnySetter
        public void setActions(String key, StateAction value) {
            this.actions.put(key, value);
        }

        @Override
        public Map<String, StateAction> getActions() {
            throw new UnsupportedOperationException();
        }
    }
}

