/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.usergroups.UsergroupPreferencesIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsergroupPreferences
implements UsergroupPreferencesIF {
    private final List<String> channelIdsUsersAutojoin;
    private final List<String> groupsUsersAutojoin;

    private UsergroupPreferences(List<String> channelIdsUsersAutojoin, List<String> groupsUsersAutojoin) {
        this.channelIdsUsersAutojoin = channelIdsUsersAutojoin;
        this.groupsUsersAutojoin = groupsUsersAutojoin;
    }

    @Override
    @JsonProperty(value="channels")
    public List<String> getChannelIdsUsersAutojoin() {
        return this.channelIdsUsersAutojoin;
    }

    @Override
    @JsonProperty(value="groups")
    public List<String> getGroupsUsersAutojoin() {
        return this.groupsUsersAutojoin;
    }

    public final UsergroupPreferences withChannelIdsUsersAutojoin(String ... elements) {
        List<String> newValue = UsergroupPreferences.createUnmodifiableList(false, UsergroupPreferences.createSafeList(Arrays.asList(elements), true, false));
        return new UsergroupPreferences(newValue, this.groupsUsersAutojoin);
    }

    public final UsergroupPreferences withChannelIdsUsersAutojoin(Iterable<String> elements) {
        if (this.channelIdsUsersAutojoin == elements) {
            return this;
        }
        List<String> newValue = UsergroupPreferences.createUnmodifiableList(false, UsergroupPreferences.createSafeList(elements, true, false));
        return new UsergroupPreferences(newValue, this.groupsUsersAutojoin);
    }

    public final UsergroupPreferences withGroupsUsersAutojoin(String ... elements) {
        List<String> newValue = UsergroupPreferences.createUnmodifiableList(false, UsergroupPreferences.createSafeList(Arrays.asList(elements), true, false));
        return new UsergroupPreferences(this.channelIdsUsersAutojoin, newValue);
    }

    public final UsergroupPreferences withGroupsUsersAutojoin(Iterable<String> elements) {
        if (this.groupsUsersAutojoin == elements) {
            return this;
        }
        List<String> newValue = UsergroupPreferences.createUnmodifiableList(false, UsergroupPreferences.createSafeList(elements, true, false));
        return new UsergroupPreferences(this.channelIdsUsersAutojoin, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupPreferences && this.equalTo((UsergroupPreferences)another);
    }

    private boolean equalTo(UsergroupPreferences another) {
        return this.channelIdsUsersAutojoin.equals(another.channelIdsUsersAutojoin) && this.groupsUsersAutojoin.equals(another.groupsUsersAutojoin);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelIdsUsersAutojoin.hashCode();
        h = h * 17 + this.groupsUsersAutojoin.hashCode();
        return h;
    }

    public String toString() {
        return "UsergroupPreferences{channelIdsUsersAutojoin=" + this.channelIdsUsersAutojoin + ", groupsUsersAutojoin=" + this.groupsUsersAutojoin + "}";
    }

    @Deprecated
    @JsonCreator
    static UsergroupPreferences fromJson(Json json) {
        Builder builder = UsergroupPreferences.builder();
        if (json.channelIdsUsersAutojoin != null) {
            builder.addAllChannelIdsUsersAutojoin(json.channelIdsUsersAutojoin);
        }
        if (json.groupsUsersAutojoin != null) {
            builder.addAllGroupsUsersAutojoin(json.groupsUsersAutojoin);
        }
        return builder.build();
    }

    public static UsergroupPreferences copyOf(UsergroupPreferencesIF instance) {
        if (instance instanceof UsergroupPreferences) {
            return (UsergroupPreferences)instance;
        }
        return UsergroupPreferences.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private List<String> channelIdsUsersAutojoin = new ArrayList<String>();
        private List<String> groupsUsersAutojoin = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(UsergroupPreferencesIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllChannelIdsUsersAutojoin(instance.getChannelIdsUsersAutojoin());
            this.addAllGroupsUsersAutojoin(instance.getGroupsUsersAutojoin());
            return this;
        }

        public final Builder addChannelIdsUsersAutojoin(String element) {
            this.channelIdsUsersAutojoin.add(Objects.requireNonNull(element, "channelIdsUsersAutojoin element"));
            return this;
        }

        public final Builder addChannelIdsUsersAutojoin(String ... elements) {
            for (String element : elements) {
                this.channelIdsUsersAutojoin.add(Objects.requireNonNull(element, "channelIdsUsersAutojoin element"));
            }
            return this;
        }

        public final Builder setChannelIdsUsersAutojoin(Iterable<String> elements) {
            this.channelIdsUsersAutojoin.clear();
            return this.addAllChannelIdsUsersAutojoin(elements);
        }

        public final Builder addAllChannelIdsUsersAutojoin(Iterable<String> elements) {
            for (String element : elements) {
                this.channelIdsUsersAutojoin.add(Objects.requireNonNull(element, "channelIdsUsersAutojoin element"));
            }
            return this;
        }

        public final Builder addGroupsUsersAutojoin(String element) {
            this.groupsUsersAutojoin.add(Objects.requireNonNull(element, "groupsUsersAutojoin element"));
            return this;
        }

        public final Builder addGroupsUsersAutojoin(String ... elements) {
            for (String element : elements) {
                this.groupsUsersAutojoin.add(Objects.requireNonNull(element, "groupsUsersAutojoin element"));
            }
            return this;
        }

        public final Builder setGroupsUsersAutojoin(Iterable<String> elements) {
            this.groupsUsersAutojoin.clear();
            return this.addAllGroupsUsersAutojoin(elements);
        }

        public final Builder addAllGroupsUsersAutojoin(Iterable<String> elements) {
            for (String element : elements) {
                this.groupsUsersAutojoin.add(Objects.requireNonNull(element, "groupsUsersAutojoin element"));
            }
            return this;
        }

        public UsergroupPreferences build() throws InvalidImmutableStateException {
            return new UsergroupPreferences(UsergroupPreferences.createUnmodifiableList(true, this.channelIdsUsersAutojoin), UsergroupPreferences.createUnmodifiableList(true, this.groupsUsersAutojoin));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UsergroupPreferencesIF {
        List<String> channelIdsUsersAutojoin = Collections.emptyList();
        List<String> groupsUsersAutojoin = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="channels")
        public void setChannelIdsUsersAutojoin(List<String> channelIdsUsersAutojoin) {
            this.channelIdsUsersAutojoin = channelIdsUsersAutojoin;
        }

        @JsonProperty(value="groups")
        public void setGroupsUsersAutojoin(List<String> groupsUsersAutojoin) {
            this.groupsUsersAutojoin = groupsUsersAutojoin;
        }

        @Override
        public List<String> getChannelIdsUsersAutojoin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGroupsUsersAutojoin() {
            throw new UnsupportedOperationException();
        }
    }
}

