/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.views.HomeTabViewPayloadIF;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class HomeTabViewPayload
implements HomeTabViewPayloadIF {
    private final List<Block> blocks;
    private final String type;
    @Nullable
    private final String privateMetadata;
    @Nullable
    private final String callbackId;
    @Nullable
    private final String externalId;

    private HomeTabViewPayload(Iterable<? extends Block> blocks) {
        this.blocks = HomeTabViewPayload.createUnmodifiableList(false, HomeTabViewPayload.createSafeList(blocks, true, false));
        this.privateMetadata = null;
        this.callbackId = null;
        this.externalId = null;
        this.type = Objects.requireNonNull(HomeTabViewPayloadIF.super.getType(), "type");
    }

    private HomeTabViewPayload(List<Block> blocks, @Nullable String privateMetadata, @Nullable String callbackId, @Nullable String externalId) {
        this.blocks = blocks;
        this.privateMetadata = privateMetadata;
        this.callbackId = callbackId;
        this.externalId = externalId;
        this.type = Objects.requireNonNull(HomeTabViewPayloadIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getPrivateMetadata() {
        return Optional.ofNullable(this.privateMetadata);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    public final HomeTabViewPayload withBlocks(Block ... elements) {
        List<Block> newValue = HomeTabViewPayload.createUnmodifiableList(false, HomeTabViewPayload.createSafeList(Arrays.asList(elements), true, false));
        return new HomeTabViewPayload(newValue, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final HomeTabViewPayload withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = HomeTabViewPayload.createUnmodifiableList(false, HomeTabViewPayload.createSafeList(elements, true, false));
        return new HomeTabViewPayload(newValue, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final HomeTabViewPayload withPrivateMetadata(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.privateMetadata, newValue)) {
            return this;
        }
        return new HomeTabViewPayload(this.blocks, newValue, this.callbackId, this.externalId);
    }

    public final HomeTabViewPayload withPrivateMetadata(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateMetadata, value)) {
            return this;
        }
        return new HomeTabViewPayload(this.blocks, value, this.callbackId, this.externalId);
    }

    public final HomeTabViewPayload withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new HomeTabViewPayload(this.blocks, this.privateMetadata, newValue, this.externalId);
    }

    public final HomeTabViewPayload withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new HomeTabViewPayload(this.blocks, this.privateMetadata, value, this.externalId);
    }

    public final HomeTabViewPayload withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new HomeTabViewPayload(this.blocks, this.privateMetadata, this.callbackId, newValue);
    }

    public final HomeTabViewPayload withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new HomeTabViewPayload(this.blocks, this.privateMetadata, this.callbackId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof HomeTabViewPayload && this.equalTo((HomeTabViewPayload)another);
    }

    private boolean equalTo(HomeTabViewPayload another) {
        return this.blocks.equals(another.blocks) && this.type.equals(another.type) && Objects.equals(this.privateMetadata, another.privateMetadata) && Objects.equals(this.callbackId, another.callbackId) && Objects.equals(this.externalId, another.externalId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.blocks.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.privateMetadata);
        h = h * 17 + Objects.hashCode(this.callbackId);
        h = h * 17 + Objects.hashCode(this.externalId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HomeTabViewPayload{");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.privateMetadata != null) {
            builder.append(", ");
            builder.append("privateMetadata=").append(this.privateMetadata);
        }
        if (this.callbackId != null) {
            builder.append(", ");
            builder.append("callbackId=").append(this.callbackId);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static HomeTabViewPayload fromJson(Json json) {
        Builder builder = HomeTabViewPayload.builder();
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.privateMetadata != null) {
            builder.setPrivateMetadata(json.privateMetadata);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        return builder.build();
    }

    public static HomeTabViewPayload of(List<Block> blocks) {
        return HomeTabViewPayload.of(blocks);
    }

    public static HomeTabViewPayload of(Iterable<? extends Block> blocks) {
        return new HomeTabViewPayload(blocks);
    }

    public static HomeTabViewPayload copyOf(HomeTabViewPayloadIF instance) {
        if (instance instanceof HomeTabViewPayload) {
            return (HomeTabViewPayload)instance;
        }
        return HomeTabViewPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String privateMetadata;
        @Nullable
        private String callbackId;
        @Nullable
        private String externalId;

        private Builder() {
        }

        public final Builder from(ViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HomeTabViewPayloadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewPayloadBase instance;
            long bits = 0L;
            if (object instanceof ViewPayloadBase) {
                Optional<String> callbackIdOptional;
                Optional<String> privateMetadataOptional;
                instance = (ViewPayloadBase)object;
                Optional<String> externalIdOptional = instance.getExternalId();
                if (externalIdOptional.isPresent()) {
                    this.setExternalId(externalIdOptional);
                }
                if ((privateMetadataOptional = instance.getPrivateMetadata()).isPresent()) {
                    this.setPrivateMetadata(privateMetadataOptional);
                }
                if ((callbackIdOptional = instance.getCallbackId()).isPresent()) {
                    this.setCallbackId(callbackIdOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
            if (object instanceof HomeTabViewPayloadIF) {
                instance = (HomeTabViewPayloadIF)object;
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
            this.privateMetadata = privateMetadata;
            return this;
        }

        public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public HomeTabViewPayload build() throws InvalidImmutableStateException {
            return new HomeTabViewPayload(HomeTabViewPayload.createUnmodifiableList(true, this.blocks), this.privateMetadata, this.callbackId, this.externalId);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements HomeTabViewPayloadIF {
        List<Block> blocks = Collections.emptyList();
        Optional<String> privateMetadata = Optional.empty();
        Optional<String> callbackId = Optional.empty();
        Optional<String> externalId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @JsonProperty
        public void setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPrivateMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }
    }
}

