/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.objects.Text;
import com.hubspot.slack.client.models.views.ModalViewPayloadBase;
import com.hubspot.slack.client.models.views.ModalViewPayloadIF;
import com.hubspot.slack.client.models.views.ViewPayloadBase;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ModalViewPayload
implements ModalViewPayloadIF {
    private final Text title;
    private final List<Block> blocks;
    private final String type;
    @Nullable
    private final Text closeButtonText;
    @Nullable
    private final Text submitButtonText;
    @Nullable
    private final Boolean clearOnClose;
    @Nullable
    private final Boolean notifyOnClose;
    @Nullable
    private final String privateMetadata;
    @Nullable
    private final String callbackId;
    @Nullable
    private final String externalId;

    private ModalViewPayload(Text title, Iterable<? extends Block> blocks) {
        this.title = Objects.requireNonNull(title, "title");
        this.blocks = ModalViewPayload.createUnmodifiableList(false, ModalViewPayload.createSafeList(blocks, true, false));
        this.closeButtonText = null;
        this.submitButtonText = null;
        this.clearOnClose = null;
        this.notifyOnClose = null;
        this.privateMetadata = null;
        this.callbackId = null;
        this.externalId = null;
        this.type = Objects.requireNonNull(ModalViewPayloadIF.super.getType(), "type");
    }

    private ModalViewPayload(Text title, List<Block> blocks, @Nullable Text closeButtonText, @Nullable Text submitButtonText, @Nullable Boolean clearOnClose, @Nullable Boolean notifyOnClose, @Nullable String privateMetadata, @Nullable String callbackId, @Nullable String externalId) {
        this.title = title;
        this.blocks = blocks;
        this.closeButtonText = closeButtonText;
        this.submitButtonText = submitButtonText;
        this.clearOnClose = clearOnClose;
        this.notifyOnClose = notifyOnClose;
        this.privateMetadata = privateMetadata;
        this.callbackId = callbackId;
        this.externalId = externalId;
        this.type = Objects.requireNonNull(ModalViewPayloadIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Text getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="close")
    public Optional<Text> getCloseButtonText() {
        return Optional.ofNullable(this.closeButtonText);
    }

    @Override
    @JsonProperty(value="submit")
    public Optional<Text> getSubmitButtonText() {
        return Optional.ofNullable(this.submitButtonText);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getClearOnClose() {
        return Optional.ofNullable(this.clearOnClose);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getNotifyOnClose() {
        return Optional.ofNullable(this.notifyOnClose);
    }

    @Override
    @JsonProperty
    public Optional<String> getPrivateMetadata() {
        return Optional.ofNullable(this.privateMetadata);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalId() {
        return Optional.ofNullable(this.externalId);
    }

    public final ModalViewPayload withTitle(Text title) {
        if (this.title == title) {
            return this;
        }
        Text newValue = Objects.requireNonNull(title, "title");
        return new ModalViewPayload(newValue, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withBlocks(Block ... elements) {
        List<Block> newValue = ModalViewPayload.createUnmodifiableList(false, ModalViewPayload.createSafeList(Arrays.asList(elements), true, false));
        return new ModalViewPayload(this.title, newValue, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ModalViewPayload.createUnmodifiableList(false, ModalViewPayload.createSafeList(elements, true, false));
        return new ModalViewPayload(this.title, newValue, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withCloseButtonText(@Nullable Text value) {
        Text newValue = value;
        if (this.closeButtonText == newValue) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, newValue, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withCloseButtonText(Optional<Text> optional) {
        Text value = optional.orElse(null);
        if (this.closeButtonText == value) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, value, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withSubmitButtonText(@Nullable Text value) {
        Text newValue = value;
        if (this.submitButtonText == newValue) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, newValue, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withSubmitButtonText(Optional<Text> optional) {
        Text value = optional.orElse(null);
        if (this.submitButtonText == value) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, value, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withClearOnClose(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.clearOnClose, newValue)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, newValue, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withClearOnClose(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.clearOnClose, value)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, value, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withNotifyOnClose(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.notifyOnClose, newValue)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, newValue, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withNotifyOnClose(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.notifyOnClose, value)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, value, this.privateMetadata, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withPrivateMetadata(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.privateMetadata, newValue)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, newValue, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withPrivateMetadata(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.privateMetadata, value)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, value, this.callbackId, this.externalId);
    }

    public final ModalViewPayload withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, newValue, this.externalId);
    }

    public final ModalViewPayload withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, value, this.externalId);
    }

    public final ModalViewPayload withExternalId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalId, newValue)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, newValue);
    }

    public final ModalViewPayload withExternalId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalId, value)) {
            return this;
        }
        return new ModalViewPayload(this.title, this.blocks, this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ModalViewPayload && this.equalTo((ModalViewPayload)another);
    }

    private boolean equalTo(ModalViewPayload another) {
        return this.title.equals(another.title) && this.blocks.equals(another.blocks) && this.type.equals(another.type) && Objects.equals(this.closeButtonText, another.closeButtonText) && Objects.equals(this.submitButtonText, another.submitButtonText) && Objects.equals(this.clearOnClose, another.clearOnClose) && Objects.equals(this.notifyOnClose, another.notifyOnClose) && Objects.equals(this.privateMetadata, another.privateMetadata) && Objects.equals(this.callbackId, another.callbackId) && Objects.equals(this.externalId, another.externalId);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.title.hashCode();
        h = h * 17 + this.blocks.hashCode();
        h = h * 17 + this.type.hashCode();
        h = h * 17 + Objects.hashCode(this.closeButtonText);
        h = h * 17 + Objects.hashCode(this.submitButtonText);
        h = h * 17 + Objects.hashCode(this.clearOnClose);
        h = h * 17 + Objects.hashCode(this.notifyOnClose);
        h = h * 17 + Objects.hashCode(this.privateMetadata);
        h = h * 17 + Objects.hashCode(this.callbackId);
        h = h * 17 + Objects.hashCode(this.externalId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ModalViewPayload{");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("type=").append(this.type);
        if (this.closeButtonText != null) {
            builder.append(", ");
            builder.append("closeButtonText=").append(this.closeButtonText);
        }
        if (this.submitButtonText != null) {
            builder.append(", ");
            builder.append("submitButtonText=").append(this.submitButtonText);
        }
        if (this.clearOnClose != null) {
            builder.append(", ");
            builder.append("clearOnClose=").append(this.clearOnClose);
        }
        if (this.notifyOnClose != null) {
            builder.append(", ");
            builder.append("notifyOnClose=").append(this.notifyOnClose);
        }
        if (this.privateMetadata != null) {
            builder.append(", ");
            builder.append("privateMetadata=").append(this.privateMetadata);
        }
        if (this.callbackId != null) {
            builder.append(", ");
            builder.append("callbackId=").append(this.callbackId);
        }
        if (this.externalId != null) {
            builder.append(", ");
            builder.append("externalId=").append(this.externalId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ModalViewPayload fromJson(Json json) {
        Builder builder = ModalViewPayload.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.closeButtonText != null) {
            builder.setCloseButtonText(json.closeButtonText);
        }
        if (json.submitButtonText != null) {
            builder.setSubmitButtonText(json.submitButtonText);
        }
        if (json.clearOnClose != null) {
            builder.setClearOnClose(json.clearOnClose);
        }
        if (json.notifyOnClose != null) {
            builder.setNotifyOnClose(json.notifyOnClose);
        }
        if (json.privateMetadata != null) {
            builder.setPrivateMetadata(json.privateMetadata);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        return builder.build();
    }

    public static ModalViewPayload of(Text title, List<Block> blocks) {
        return ModalViewPayload.of(title, blocks);
    }

    public static ModalViewPayload of(Text title, Iterable<? extends Block> blocks) {
        return new ModalViewPayload(title, blocks);
    }

    public static ModalViewPayload copyOf(ModalViewPayloadIF instance) {
        if (instance instanceof ModalViewPayload) {
            return (ModalViewPayload)instance;
        }
        return ModalViewPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private long initBits = 1L;
        @Nullable
        private Text title;
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private Text closeButtonText;
        @Nullable
        private Text submitButtonText;
        @Nullable
        private Boolean clearOnClose;
        @Nullable
        private Boolean notifyOnClose;
        @Nullable
        private String privateMetadata;
        @Nullable
        private String callbackId;
        @Nullable
        private String externalId;

        private Builder() {
        }

        public final Builder from(ModalViewPayloadIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ModalViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ViewPayloadBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ViewPayloadBase instance;
            long bits = 0L;
            if (object instanceof ModalViewPayloadIF) {
                instance = (ModalViewPayloadIF)object;
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
            if (object instanceof ModalViewPayloadBase) {
                Optional<Boolean> clearOnCloseOptional;
                Optional<Text> closeButtonTextOptional;
                Optional<Boolean> notifyOnCloseOptional;
                instance = (ModalViewPayloadBase)object;
                Optional<Text> submitButtonTextOptional = instance.getSubmitButtonText();
                if (submitButtonTextOptional.isPresent()) {
                    this.setSubmitButtonText(submitButtonTextOptional);
                }
                if ((notifyOnCloseOptional = instance.getNotifyOnClose()).isPresent()) {
                    this.setNotifyOnClose(notifyOnCloseOptional);
                }
                if ((closeButtonTextOptional = instance.getCloseButtonText()).isPresent()) {
                    this.setCloseButtonText(closeButtonTextOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 2L;
                }
                if ((clearOnCloseOptional = instance.getClearOnClose()).isPresent()) {
                    this.setClearOnClose(clearOnCloseOptional);
                }
            }
            if (object instanceof ViewPayloadBase) {
                Optional<String> callbackIdOptional;
                Optional<String> privateMetadataOptional;
                instance = (ViewPayloadBase)object;
                Optional<String> externalIdOptional = instance.getExternalId();
                if (externalIdOptional.isPresent()) {
                    this.setExternalId(externalIdOptional);
                }
                if ((privateMetadataOptional = instance.getPrivateMetadata()).isPresent()) {
                    this.setPrivateMetadata(privateMetadataOptional);
                }
                if ((callbackIdOptional = instance.getCallbackId()).isPresent()) {
                    this.setCallbackId(callbackIdOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 1L;
                }
            }
        }

        public final Builder setTitle(Text title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public final Builder setCloseButtonText(@Nullable Text closeButtonText) {
            this.closeButtonText = closeButtonText;
            return this;
        }

        public final Builder setCloseButtonText(Optional<Text> closeButtonText) {
            this.closeButtonText = closeButtonText.orElse(null);
            return this;
        }

        public final Builder setSubmitButtonText(@Nullable Text submitButtonText) {
            this.submitButtonText = submitButtonText;
            return this;
        }

        public final Builder setSubmitButtonText(Optional<Text> submitButtonText) {
            this.submitButtonText = submitButtonText.orElse(null);
            return this;
        }

        public final Builder setClearOnClose(@Nullable Boolean clearOnClose) {
            this.clearOnClose = clearOnClose;
            return this;
        }

        public final Builder setClearOnClose(Optional<Boolean> clearOnClose) {
            this.clearOnClose = clearOnClose.orElse(null);
            return this;
        }

        public final Builder setNotifyOnClose(@Nullable Boolean notifyOnClose) {
            this.notifyOnClose = notifyOnClose;
            return this;
        }

        public final Builder setNotifyOnClose(Optional<Boolean> notifyOnClose) {
            this.notifyOnClose = notifyOnClose.orElse(null);
            return this;
        }

        public final Builder setPrivateMetadata(@Nullable String privateMetadata) {
            this.privateMetadata = privateMetadata;
            return this;
        }

        public final Builder setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder setExternalId(Optional<String> externalId) {
            this.externalId = externalId.orElse(null);
            return this;
        }

        public ModalViewPayload build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ModalViewPayload(this.title, ModalViewPayload.createUnmodifiableList(true, this.blocks), this.closeButtonText, this.submitButtonText, this.clearOnClose, this.notifyOnClose, this.privateMetadata, this.callbackId, this.externalId);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            return "Cannot build ModalViewPayload, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ModalViewPayloadIF {
        @Nullable
        Text title;
        List<Block> blocks = Collections.emptyList();
        Optional<Text> closeButtonText = Optional.empty();
        Optional<Text> submitButtonText = Optional.empty();
        Optional<Boolean> clearOnClose = Optional.empty();
        Optional<Boolean> notifyOnClose = Optional.empty();
        Optional<String> privateMetadata = Optional.empty();
        Optional<String> callbackId = Optional.empty();
        Optional<String> externalId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(Text title) {
            this.title = title;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @JsonProperty(value="close")
        public void setCloseButtonText(Optional<Text> closeButtonText) {
            this.closeButtonText = closeButtonText;
        }

        @JsonProperty(value="submit")
        public void setSubmitButtonText(Optional<Text> submitButtonText) {
            this.submitButtonText = submitButtonText;
        }

        @JsonProperty
        public void setClearOnClose(Optional<Boolean> clearOnClose) {
            this.clearOnClose = clearOnClose;
        }

        @JsonProperty
        public void setNotifyOnClose(Optional<Boolean> notifyOnClose) {
            this.notifyOnClose = notifyOnClose;
        }

        @JsonProperty
        public void setPrivateMetadata(Optional<String> privateMetadata) {
            this.privateMetadata = privateMetadata;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setExternalId(Optional<String> externalId) {
            this.externalId = externalId;
        }

        @Override
        public Text getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getCloseButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getSubmitButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getClearOnClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getNotifyOnClose() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPrivateMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalId() {
            throw new UnsupportedOperationException();
        }
    }
}

