package com.hubspot.slack.client.methods;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SpecialTierIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SpecialTier.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code SpecialTier.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SpecialTierIF"})
@Immutable
public final class SpecialTier implements SpecialTierIF {
  private final int minutelyAllowance;

  private SpecialTier(int minutelyAllowance) {
    this.minutelyAllowance = minutelyAllowance;
  }

  /**
   * @return The value of the {@code minutelyAllowance} attribute
   */
  @JsonProperty
  @Override
  public int getMinutelyAllowance() {
    return minutelyAllowance;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SpecialTierIF#getMinutelyAllowance() minutelyAllowance} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param minutelyAllowance A new value for minutelyAllowance
   * @return A modified copy of the {@code this} object
   */
  public final SpecialTier withMinutelyAllowance(int minutelyAllowance) {
    if (this.minutelyAllowance == minutelyAllowance) return this;
    return new SpecialTier(minutelyAllowance);
  }

  /**
   * This instance is equal to all instances of {@code SpecialTier} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SpecialTier
        && equalTo((SpecialTier) another);
  }

  private boolean equalTo(SpecialTier another) {
    return minutelyAllowance == another.minutelyAllowance;
  }

  /**
   * Computes a hash code from attributes: {@code minutelyAllowance}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + minutelyAllowance;
    return h;
  }

  /**
   * Prints the immutable value {@code SpecialTier} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpecialTier{"
        + "minutelyAllowance=" + minutelyAllowance
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SpecialTierIF {
    int minutelyAllowance;
    boolean minutelyAllowanceIsSet;
    @JsonProperty
    public void setMinutelyAllowance(int minutelyAllowance) {
      this.minutelyAllowance = minutelyAllowance;
      this.minutelyAllowanceIsSet = true;
    }
    @Override
    public int getMinutelyAllowance() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SpecialTier fromJson(Json json) {
    SpecialTier.Builder builder = SpecialTier.builder();
    if (json.minutelyAllowanceIsSet) {
      builder.setMinutelyAllowance(json.minutelyAllowance);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code SpecialTier} instance.
   * @param minutelyAllowance The value for the {@code minutelyAllowance} attribute
   * @return An immutable SpecialTier instance
   */
  public static SpecialTier of(int minutelyAllowance) {
    return new SpecialTier(minutelyAllowance);
  }

  /**
   * Creates an immutable copy of a {@link SpecialTierIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SpecialTier instance
   */
  public static SpecialTier copyOf(SpecialTierIF instance) {
    if (instance instanceof SpecialTier) {
      return (SpecialTier) instance;
    }
    return SpecialTier.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SpecialTier SpecialTier}.
   * @return A new SpecialTier builder
   */
  public static SpecialTier.Builder builder() {
    return new SpecialTier.Builder();
  }

  /**
   * Builds instances of type {@link SpecialTier SpecialTier}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_MINUTELY_ALLOWANCE = 0x1L;
    private long initBits = 0x1L;

    private int minutelyAllowance;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.SpecialTierIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SpecialTierIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.RateLimitingTier} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RateLimitingTier instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SpecialTierIF) {
        SpecialTierIF instance = (SpecialTierIF) object;
        if ((bits & 0x1L) == 0) {
          setMinutelyAllowance(instance.getMinutelyAllowance());
          bits |= 0x1L;
        }
      }
      if (object instanceof RateLimitingTier) {
        RateLimitingTier instance = (RateLimitingTier) object;
        if ((bits & 0x1L) == 0) {
          setMinutelyAllowance(instance.getMinutelyAllowance());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link SpecialTierIF#getMinutelyAllowance() minutelyAllowance} attribute.
     * @param minutelyAllowance The value for minutelyAllowance 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMinutelyAllowance(int minutelyAllowance) {
      this.minutelyAllowance = minutelyAllowance;
      initBits &= ~INIT_BIT_MINUTELY_ALLOWANCE;
      return this;
    }

    /**
     * Builds a new {@link SpecialTier SpecialTier}.
     * @return An immutable instance of SpecialTier
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SpecialTier build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SpecialTier(minutelyAllowance);
    }

    private boolean minutelyAllowanceIsSet() {
      return (initBits & INIT_BIT_MINUTELY_ALLOWANCE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!minutelyAllowanceIsSet()) attributes.add("minutelyAllowance");
      return "Cannot build SpecialTier, some of required attributes are not set " + attributes;
    }
  }
}
