package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractChannelsHistoryParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelsHistoryParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractChannelsHistoryParams"})
@Immutable
public final class ChannelsHistoryParams
    extends AbstractChannelsHistoryParams {
  private final String channelId;
  private final @Nullable Integer count;
  private final @Nullable Boolean inclusive;
  private final @Nullable Boolean shouldIncludeUnreads;
  private final @Nullable String newestTimestamp;
  private final @Nullable String oldestTimestamp;
  private final PagingDirection pagingDirection;

  private ChannelsHistoryParams(
      String channelId,
      @Nullable Integer count,
      @Nullable Boolean inclusive,
      @Nullable Boolean shouldIncludeUnreads,
      @Nullable String newestTimestamp,
      @Nullable String oldestTimestamp) {
    this.channelId = channelId;
    this.count = count;
    this.inclusive = inclusive;
    this.shouldIncludeUnreads = shouldIncludeUnreads;
    this.newestTimestamp = newestTimestamp;
    this.oldestTimestamp = oldestTimestamp;
    this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code count} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getCount() {
    return Optional.ofNullable(count);
  }

  /**
   * @return The value of the {@code inclusive} attribute
   */
  @JsonProperty("is_inclusive")
  @Override
  public Optional<Boolean> isInclusive() {
    return Optional.ofNullable(inclusive);
  }

  /**
   * @return The value of the {@code shouldIncludeUnreads} attribute
   */
  @JsonProperty("unreads")
  @Override
  public Optional<Boolean> shouldIncludeUnreads() {
    return Optional.ofNullable(shouldIncludeUnreads);
  }

  /**
   * @return The value of the {@code newestTimestamp} attribute
   */
  @JsonProperty("latest")
  @Override
  public Optional<String> getNewestTimestamp() {
    return Optional.ofNullable(newestTimestamp);
  }

  /**
   * @return The value of the {@code oldestTimestamp} attribute
   */
  @JsonProperty("oldest")
  @Override
  public Optional<String> getOldestTimestamp() {
    return Optional.ofNullable(oldestTimestamp);
  }

  /**
   * @return The computed-at-construction value of the {@code pagingDirection} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public PagingDirection getPagingDirection() {
    return pagingDirection;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChannelsHistoryParams#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsHistoryParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return validate(new ChannelsHistoryParams(
        newValue,
        this.count,
        this.inclusive,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryParams#getCount() count} attribute.
   * @param value The value for count, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withCount(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.count, newValue)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        newValue,
        this.inclusive,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryParams#getCount() count} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for count
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.count, value)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        value,
        this.inclusive,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryParams#isInclusive() inclusive} attribute.
   * @param value The value for inclusive, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withInclusive(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.inclusive, newValue)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        newValue,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryParams#isInclusive() inclusive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for inclusive
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withInclusive(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.inclusive, value)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        value,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryParams#shouldIncludeUnreads() shouldIncludeUnreads} attribute.
   * @param value The value for shouldIncludeUnreads, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withShouldIncludeUnreads(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.shouldIncludeUnreads, newValue)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        this.inclusive,
        newValue,
        this.newestTimestamp,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryParams#shouldIncludeUnreads() shouldIncludeUnreads} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for shouldIncludeUnreads
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withShouldIncludeUnreads(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.shouldIncludeUnreads, value)) return this;
    return validate(new ChannelsHistoryParams(this.channelId, this.count, this.inclusive, value, this.newestTimestamp, this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryParams#getNewestTimestamp() newestTimestamp} attribute.
   * @param value The value for newestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withNewestTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.newestTimestamp, newValue)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        this.inclusive,
        this.shouldIncludeUnreads,
        newValue,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryParams#getNewestTimestamp() newestTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for newestTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withNewestTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.newestTimestamp, value)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        this.inclusive,
        this.shouldIncludeUnreads,
        value,
        this.oldestTimestamp));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsHistoryParams#getOldestTimestamp() oldestTimestamp} attribute.
   * @param value The value for oldestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withOldestTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.oldestTimestamp, newValue)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        this.inclusive,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsHistoryParams#getOldestTimestamp() oldestTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oldestTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ChannelsHistoryParams withOldestTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.oldestTimestamp, value)) return this;
    return validate(new ChannelsHistoryParams(
        this.channelId,
        this.count,
        this.inclusive,
        this.shouldIncludeUnreads,
        this.newestTimestamp,
        value));
  }

  /**
   * This instance is equal to all instances of {@code ChannelsHistoryParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelsHistoryParams
        && equalTo((ChannelsHistoryParams) another);
  }

  private boolean equalTo(ChannelsHistoryParams another) {
    return channelId.equals(another.channelId)
        && Objects.equals(count, another.count)
        && Objects.equals(inclusive, another.inclusive)
        && Objects.equals(shouldIncludeUnreads, another.shouldIncludeUnreads)
        && Objects.equals(newestTimestamp, another.newestTimestamp)
        && Objects.equals(oldestTimestamp, another.oldestTimestamp)
        && pagingDirection.equals(another.pagingDirection);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code count}, {@code inclusive}, {@code shouldIncludeUnreads}, {@code newestTimestamp}, {@code oldestTimestamp}, {@code pagingDirection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(count);
    h = h * 17 + Objects.hashCode(inclusive);
    h = h * 17 + Objects.hashCode(shouldIncludeUnreads);
    h = h * 17 + Objects.hashCode(newestTimestamp);
    h = h * 17 + Objects.hashCode(oldestTimestamp);
    h = h * 17 + pagingDirection.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelsHistoryParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChannelsHistoryParams{");
    builder.append("channelId=").append(channelId);
    if (count != null) {
      builder.append(", ");
      builder.append("count=").append(count);
    }
    if (inclusive != null) {
      builder.append(", ");
      builder.append("inclusive=").append(inclusive);
    }
    if (shouldIncludeUnreads != null) {
      builder.append(", ");
      builder.append("shouldIncludeUnreads=").append(shouldIncludeUnreads);
    }
    if (newestTimestamp != null) {
      builder.append(", ");
      builder.append("newestTimestamp=").append(newestTimestamp);
    }
    if (oldestTimestamp != null) {
      builder.append(", ");
      builder.append("oldestTimestamp=").append(oldestTimestamp);
    }
    builder.append(", ");
    builder.append("pagingDirection=").append(pagingDirection);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractChannelsHistoryParams {
    @Nullable String channelId;
    Optional<Integer> count = Optional.empty();
    Optional<Boolean> inclusive = Optional.empty();
    Optional<Boolean> shouldIncludeUnreads = Optional.empty();
    Optional<String> newestTimestamp = Optional.empty();
    Optional<String> oldestTimestamp = Optional.empty();
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setCount(Optional<Integer> count) {
      this.count = count;
    }
    @JsonProperty("is_inclusive")
    public void setInclusive(Optional<Boolean> inclusive) {
      this.inclusive = inclusive;
    }
    @JsonProperty("unreads")
    public void setShouldIncludeUnreads(Optional<Boolean> shouldIncludeUnreads) {
      this.shouldIncludeUnreads = shouldIncludeUnreads;
    }
    @JsonProperty("latest")
    public void setNewestTimestamp(Optional<String> newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
    }
    @JsonProperty("oldest")
    public void setOldestTimestamp(Optional<String> oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isInclusive() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> shouldIncludeUnreads() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNewestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOldestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public PagingDirection getPagingDirection() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelsHistoryParams fromJson(Json json) {
    ChannelsHistoryParams.Builder builder = ChannelsHistoryParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.count != null) {
      builder.setCount(json.count);
    }
    if (json.inclusive != null) {
      builder.setInclusive(json.inclusive);
    }
    if (json.shouldIncludeUnreads != null) {
      builder.setShouldIncludeUnreads(json.shouldIncludeUnreads);
    }
    if (json.newestTimestamp != null) {
      builder.setNewestTimestamp(json.newestTimestamp);
    }
    if (json.oldestTimestamp != null) {
      builder.setOldestTimestamp(json.oldestTimestamp);
    }
    return builder.build();
  }

  private static ChannelsHistoryParams validate(ChannelsHistoryParams instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AbstractChannelsHistoryParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelsHistoryParams instance
   */
  public static ChannelsHistoryParams copyOf(AbstractChannelsHistoryParams instance) {
    if (instance instanceof ChannelsHistoryParams) {
      return (ChannelsHistoryParams) instance;
    }
    return ChannelsHistoryParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelsHistoryParams ChannelsHistoryParams}.
   * @return A new ChannelsHistoryParams builder
   */
  public static ChannelsHistoryParams.Builder builder() {
    return new ChannelsHistoryParams.Builder();
  }

  /**
   * Builds instances of type {@link ChannelsHistoryParams ChannelsHistoryParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String channelId;
    private @Nullable Integer count;
    private @Nullable Boolean inclusive;
    private @Nullable Boolean shouldIncludeUnreads;
    private @Nullable String newestTimestamp;
    private @Nullable String oldestTimestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.AbstractChannelsHistoryParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChannelsHistoryParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.TimeIntervalFilter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TimeIntervalFilter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractChannelsHistoryParams) {
        AbstractChannelsHistoryParams instance = (AbstractChannelsHistoryParams) object;
        Optional<Integer> countOptional = instance.getCount();
        if (countOptional.isPresent()) {
          setCount(countOptional);
        }
        if ((bits & 0x1L) == 0) {
          Optional<Boolean> inclusiveOptional = instance.isInclusive();
          if (inclusiveOptional.isPresent()) {
            setInclusive(inclusiveOptional);
          }
          bits |= 0x1L;
        }
        Optional<Boolean> shouldIncludeUnreadsOptional = instance.shouldIncludeUnreads();
        if (shouldIncludeUnreadsOptional.isPresent()) {
          setShouldIncludeUnreads(shouldIncludeUnreadsOptional);
        }
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
      if (object instanceof TimeIntervalFilter) {
        TimeIntervalFilter instance = (TimeIntervalFilter) object;
        Optional<String> oldestTimestampOptional = instance.getOldestTimestamp();
        if (oldestTimestampOptional.isPresent()) {
          setOldestTimestamp(oldestTimestampOptional);
        }
        if ((bits & 0x1L) == 0) {
          Optional<Boolean> inclusiveOptional = instance.isInclusive();
          if (inclusiveOptional.isPresent()) {
            setInclusive(inclusiveOptional);
          }
          bits |= 0x1L;
        }
        Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
        if (newestTimestampOptional.isPresent()) {
          setNewestTimestamp(newestTimestampOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractChannelsHistoryParams#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#getCount() count} to count.
     * @param count The value for count, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCount(@Nullable Integer count) {
      this.count = count;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#getCount() count} to count.
     * @param count The value for count
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCount(Optional<Integer> count) {
      this.count = count.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#isInclusive() inclusive} to inclusive.
     * @param inclusive The value for inclusive, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInclusive(@Nullable Boolean inclusive) {
      this.inclusive = inclusive;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#isInclusive() inclusive} to inclusive.
     * @param inclusive The value for inclusive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInclusive(Optional<Boolean> inclusive) {
      this.inclusive = inclusive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#shouldIncludeUnreads() shouldIncludeUnreads} to shouldIncludeUnreads.
     * @param shouldIncludeUnreads The value for shouldIncludeUnreads, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setShouldIncludeUnreads(@Nullable Boolean shouldIncludeUnreads) {
      this.shouldIncludeUnreads = shouldIncludeUnreads;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#shouldIncludeUnreads() shouldIncludeUnreads} to shouldIncludeUnreads.
     * @param shouldIncludeUnreads The value for shouldIncludeUnreads
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldIncludeUnreads(Optional<Boolean> shouldIncludeUnreads) {
      this.shouldIncludeUnreads = shouldIncludeUnreads.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#getNewestTimestamp() newestTimestamp} to newestTimestamp.
     * @param newestTimestamp The value for newestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#getNewestTimestamp() newestTimestamp} to newestTimestamp.
     * @param newestTimestamp The value for newestTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
      this.newestTimestamp = newestTimestamp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#getOldestTimestamp() oldestTimestamp} to oldestTimestamp.
     * @param oldestTimestamp The value for oldestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsHistoryParams#getOldestTimestamp() oldestTimestamp} to oldestTimestamp.
     * @param oldestTimestamp The value for oldestTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChannelsHistoryParams ChannelsHistoryParams}.
     * @return An immutable instance of ChannelsHistoryParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelsHistoryParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return ChannelsHistoryParams.validate(new ChannelsHistoryParams(channelId, count, inclusive, shouldIncludeUnreads, newestTimestamp, oldestTimestamp));
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ChannelsHistoryParams, some of required attributes are not set " + attributes;
    }
  }
}
