package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractChannelsInfoParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelsInfoParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ChannelsInfoParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractChannelsInfoParams"})
@Immutable
public final class ChannelsInfoParams
    extends AbstractChannelsInfoParams {
  private final String channelId;
  private final @Nullable Boolean includeLocale;

  private ChannelsInfoParams(String channelId) {
    this.channelId = Objects.requireNonNull(channelId, "channelId");
    this.includeLocale = null;
  }

  private ChannelsInfoParams(String channelId, @Nullable Boolean includeLocale) {
    this.channelId = channelId;
    this.includeLocale = includeLocale;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code includeLocale} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeLocale() {
    return Optional.ofNullable(includeLocale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChannelsInfoParams#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsInfoParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ChannelsInfoParams(newValue, this.includeLocale);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractChannelsInfoParams#getIncludeLocale() includeLocale} attribute.
   * @param value The value for includeLocale, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsInfoParams withIncludeLocale(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeLocale, newValue)) return this;
    return new ChannelsInfoParams(this.channelId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractChannelsInfoParams#getIncludeLocale() includeLocale} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeLocale
   * @return A modified copy of {@code this} object
   */
  public final ChannelsInfoParams withIncludeLocale(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeLocale, value)) return this;
    return new ChannelsInfoParams(this.channelId, value);
  }

  /**
   * This instance is equal to all instances of {@code ChannelsInfoParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelsInfoParams
        && equalTo((ChannelsInfoParams) another);
  }

  private boolean equalTo(ChannelsInfoParams another) {
    return channelId.equals(another.channelId)
        && Objects.equals(includeLocale, another.includeLocale);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code includeLocale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(includeLocale);
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelsInfoParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChannelsInfoParams{");
    builder.append("channelId=").append(channelId);
    if (includeLocale != null) {
      builder.append(", ");
      builder.append("includeLocale=").append(includeLocale);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractChannelsInfoParams {
    @Nullable String channelId;
    Optional<Boolean> includeLocale = Optional.empty();
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setIncludeLocale(Optional<Boolean> includeLocale) {
      this.includeLocale = includeLocale;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeLocale() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelsInfoParams fromJson(Json json) {
    ChannelsInfoParams.Builder builder = ChannelsInfoParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.includeLocale != null) {
      builder.setIncludeLocale(json.includeLocale);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ChannelsInfoParams} instance.
   * @param channelId The value for the {@code channelId} attribute
   * @return An immutable ChannelsInfoParams instance
   */
  public static ChannelsInfoParams of(String channelId) {
    return new ChannelsInfoParams(channelId);
  }

  /**
   * Creates an immutable copy of a {@link AbstractChannelsInfoParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelsInfoParams instance
   */
  public static ChannelsInfoParams copyOf(AbstractChannelsInfoParams instance) {
    if (instance instanceof ChannelsInfoParams) {
      return (ChannelsInfoParams) instance;
    }
    return ChannelsInfoParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelsInfoParams ChannelsInfoParams}.
   * @return A new ChannelsInfoParams builder
   */
  public static ChannelsInfoParams.Builder builder() {
    return new ChannelsInfoParams.Builder();
  }

  /**
   * Builds instances of type {@link ChannelsInfoParams ChannelsInfoParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String channelId;
    private @Nullable Boolean includeLocale;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.AbstractChannelsInfoParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChannelsInfoParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractChannelsInfoParams) {
        AbstractChannelsInfoParams instance = (AbstractChannelsInfoParams) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
        Optional<Boolean> includeLocaleOptional = instance.getIncludeLocale();
        if (includeLocaleOptional.isPresent()) {
          setIncludeLocale(includeLocaleOptional);
        }
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractChannelsInfoParams#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsInfoParams#getIncludeLocale() includeLocale} to includeLocale.
     * @param includeLocale The value for includeLocale, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeLocale(@Nullable Boolean includeLocale) {
      this.includeLocale = includeLocale;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractChannelsInfoParams#getIncludeLocale() includeLocale} to includeLocale.
     * @param includeLocale The value for includeLocale
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeLocale(Optional<Boolean> includeLocale) {
      this.includeLocale = includeLocale.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChannelsInfoParams ChannelsInfoParams}.
     * @return An immutable instance of ChannelsInfoParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelsInfoParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChannelsInfoParams(channelId, includeLocale);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ChannelsInfoParams, some of required attributes are not set " + attributes;
    }
  }
}
