package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChannelsKickParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelsKickParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChannelsKickParamsIF"})
@Immutable
public final class ChannelsKickParams
    implements ChannelsKickParamsIF {
  private final String channelId;
  private final String userId;

  private ChannelsKickParams(String channelId, String userId) {
    this.channelId = channelId;
    this.userId = userId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChannelsKickParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsKickParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ChannelsKickParams(newValue, this.userId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChannelsKickParamsIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsKickParams withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new ChannelsKickParams(this.channelId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ChannelsKickParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelsKickParams
        && equalTo((ChannelsKickParams) another);
  }

  private boolean equalTo(ChannelsKickParams another) {
    return channelId.equals(another.channelId)
        && userId.equals(another.userId);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code userId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + userId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelsKickParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChannelsKickParams{"
        + "channelId=" + channelId
        + ", userId=" + userId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChannelsKickParamsIF {
    @Nullable String channelId;
    @Nullable String userId;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelsKickParams fromJson(Json json) {
    ChannelsKickParams.Builder builder = ChannelsKickParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChannelsKickParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelsKickParams instance
   */
  public static ChannelsKickParams copyOf(ChannelsKickParamsIF instance) {
    if (instance instanceof ChannelsKickParams) {
      return (ChannelsKickParams) instance;
    }
    return ChannelsKickParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelsKickParams ChannelsKickParams}.
   * @return A new ChannelsKickParams builder
   */
  public static ChannelsKickParams.Builder builder() {
    return new ChannelsKickParams.Builder();
  }

  /**
   * Builds instances of type {@link ChannelsKickParams ChannelsKickParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String channelId;
    private @Nullable String userId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.ChannelsKickParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChannelsKickParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ChannelsKickParamsIF) {
        ChannelsKickParamsIF instance = (ChannelsKickParamsIF) object;
        setUserId(instance.getUserId());
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ChannelsKickParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ChannelsKickParamsIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Builds a new {@link ChannelsKickParams ChannelsKickParams}.
     * @return An immutable instance of ChannelsKickParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelsKickParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChannelsKickParams(channelId, userId);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!userIdIsSet()) attributes.add("userId");
      return "Cannot build ChannelsKickParams, some of required attributes are not set " + attributes;
    }
  }
}
