package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChannelsListParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelsListParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChannelsListParamsIF"})
@Immutable
public final class ChannelsListParams
    implements ChannelsListParamsIF {
  private final @Nullable String cursor;
  private final @Nullable Integer limit;
  private final @Nullable Boolean shouldExcludeArchived;
  private final boolean shouldExcludeMembers;

  private ChannelsListParams(ChannelsListParams.Builder builder) {
    this.cursor = builder.cursor;
    this.limit = builder.limit;
    this.shouldExcludeArchived = builder.shouldExcludeArchived;
    this.shouldExcludeMembers = builder.shouldExcludeMembersIsSet()
        ? builder.shouldExcludeMembers
        : ChannelsListParamsIF.super.shouldExcludeMembers();
  }

  private ChannelsListParams(
      @Nullable String cursor,
      @Nullable Integer limit,
      @Nullable Boolean shouldExcludeArchived,
      boolean shouldExcludeMembers) {
    this.cursor = cursor;
    this.limit = limit;
    this.shouldExcludeArchived = shouldExcludeArchived;
    this.shouldExcludeMembers = shouldExcludeMembers;
  }

  /**
   * @return The value of the {@code cursor} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCursor() {
    return Optional.ofNullable(cursor);
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getLimit() {
    return Optional.ofNullable(limit);
  }

  /**
   * @return The value of the {@code shouldExcludeArchived} attribute
   */
  @JsonProperty("exclude_archived")
  @Override
  public Optional<Boolean> shouldExcludeArchived() {
    return Optional.ofNullable(shouldExcludeArchived);
  }

  /**
   * @return The value of the {@code shouldExcludeMembers} attribute
   */
  @JsonProperty("exclude_members")
  @Override
  public boolean shouldExcludeMembers() {
    return shouldExcludeMembers;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChannelsListParamsIF#getCursor() cursor} attribute.
   * @param value The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsListParams withCursor(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.cursor, newValue)) return this;
    return new ChannelsListParams(newValue, this.limit, this.shouldExcludeArchived, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChannelsListParamsIF#getCursor() cursor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cursor
   * @return A modified copy of {@code this} object
   */
  public final ChannelsListParams withCursor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.cursor, value)) return this;
    return new ChannelsListParams(value, this.limit, this.shouldExcludeArchived, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChannelsListParamsIF#getLimit() limit} attribute.
   * @param value The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsListParams withLimit(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.limit, newValue)) return this;
    return new ChannelsListParams(this.cursor, newValue, this.shouldExcludeArchived, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChannelsListParamsIF#getLimit() limit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for limit
   * @return A modified copy of {@code this} object
   */
  public final ChannelsListParams withLimit(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.limit, value)) return this;
    return new ChannelsListParams(this.cursor, value, this.shouldExcludeArchived, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChannelsListParamsIF#shouldExcludeArchived() shouldExcludeArchived} attribute.
   * @param value The value for shouldExcludeArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelsListParams withShouldExcludeArchived(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.shouldExcludeArchived, newValue)) return this;
    return new ChannelsListParams(this.cursor, this.limit, newValue, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChannelsListParamsIF#shouldExcludeArchived() shouldExcludeArchived} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for shouldExcludeArchived
   * @return A modified copy of {@code this} object
   */
  public final ChannelsListParams withShouldExcludeArchived(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.shouldExcludeArchived, value)) return this;
    return new ChannelsListParams(this.cursor, this.limit, value, this.shouldExcludeMembers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChannelsListParamsIF#shouldExcludeMembers() shouldExcludeMembers} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param shouldExcludeMembers A new value for shouldExcludeMembers
   * @return A modified copy of the {@code this} object
   */
  public final ChannelsListParams withShouldExcludeMembers(boolean shouldExcludeMembers) {
    if (this.shouldExcludeMembers == shouldExcludeMembers) return this;
    return new ChannelsListParams(this.cursor, this.limit, this.shouldExcludeArchived, shouldExcludeMembers);
  }

  /**
   * This instance is equal to all instances of {@code ChannelsListParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelsListParams
        && equalTo((ChannelsListParams) another);
  }

  private boolean equalTo(ChannelsListParams another) {
    return Objects.equals(cursor, another.cursor)
        && Objects.equals(limit, another.limit)
        && Objects.equals(shouldExcludeArchived, another.shouldExcludeArchived)
        && shouldExcludeMembers == another.shouldExcludeMembers;
  }

  /**
   * Computes a hash code from attributes: {@code cursor}, {@code limit}, {@code shouldExcludeArchived}, {@code shouldExcludeMembers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(cursor);
    h = h * 17 + Objects.hashCode(limit);
    h = h * 17 + Objects.hashCode(shouldExcludeArchived);
    h = h * 17 + Boolean.hashCode(shouldExcludeMembers);
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelsListParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChannelsListParams{");
    if (cursor != null) {
      builder.append("cursor=").append(cursor);
    }
    if (limit != null) {
      if (builder.length() > 19) builder.append(", ");
      builder.append("limit=").append(limit);
    }
    if (shouldExcludeArchived != null) {
      if (builder.length() > 19) builder.append(", ");
      builder.append("shouldExcludeArchived=").append(shouldExcludeArchived);
    }
    if (builder.length() > 19) builder.append(", ");
    builder.append("shouldExcludeMembers=").append(shouldExcludeMembers);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChannelsListParamsIF {
    Optional<String> cursor = Optional.empty();
    Optional<Integer> limit = Optional.empty();
    Optional<Boolean> shouldExcludeArchived = Optional.empty();
    boolean shouldExcludeMembers;
    boolean shouldExcludeMembersIsSet;
    @JsonProperty
    public void setCursor(Optional<String> cursor) {
      this.cursor = cursor;
    }
    @JsonProperty
    public void setLimit(Optional<Integer> limit) {
      this.limit = limit;
    }
    @JsonProperty("exclude_archived")
    public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived;
    }
    @JsonProperty("exclude_members")
    public void setShouldExcludeMembers(boolean shouldExcludeMembers) {
      this.shouldExcludeMembers = shouldExcludeMembers;
      this.shouldExcludeMembersIsSet = true;
    }
    @Override
    public Optional<String> getCursor() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> shouldExcludeArchived() { throw new UnsupportedOperationException(); }
    @Override
    public boolean shouldExcludeMembers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelsListParams fromJson(Json json) {
    ChannelsListParams.Builder builder = ChannelsListParams.builder();
    if (json.cursor != null) {
      builder.setCursor(json.cursor);
    }
    if (json.limit != null) {
      builder.setLimit(json.limit);
    }
    if (json.shouldExcludeArchived != null) {
      builder.setShouldExcludeArchived(json.shouldExcludeArchived);
    }
    if (json.shouldExcludeMembersIsSet) {
      builder.setShouldExcludeMembers(json.shouldExcludeMembers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChannelsListParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelsListParams instance
   */
  public static ChannelsListParams copyOf(ChannelsListParamsIF instance) {
    if (instance instanceof ChannelsListParams) {
      return (ChannelsListParams) instance;
    }
    return ChannelsListParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelsListParams ChannelsListParams}.
   * @return A new ChannelsListParams builder
   */
  public static ChannelsListParams.Builder builder() {
    return new ChannelsListParams.Builder();
  }

  /**
   * Builds instances of type {@link ChannelsListParams ChannelsListParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SHOULD_EXCLUDE_MEMBERS = 0x1L;
    private long optBits;

    private @Nullable String cursor;
    private @Nullable Integer limit;
    private @Nullable Boolean shouldExcludeArchived;
    private boolean shouldExcludeMembers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.BaseChannelsFilter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseChannelsFilter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.ChannelsListParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChannelsListParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BaseChannelsFilter) {
        BaseChannelsFilter instance = (BaseChannelsFilter) object;
        Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
        if (shouldExcludeArchivedOptional.isPresent()) {
          setShouldExcludeArchived(shouldExcludeArchivedOptional);
        }
        setShouldExcludeMembers(instance.shouldExcludeMembers());
      }
      if (object instanceof ChannelsListParamsIF) {
        ChannelsListParamsIF instance = (ChannelsListParamsIF) object;
        Optional<String> cursorOptional = instance.getCursor();
        if (cursorOptional.isPresent()) {
          setCursor(cursorOptional);
        }
        Optional<Integer> limitOptional = instance.getLimit();
        if (limitOptional.isPresent()) {
          setLimit(limitOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link ChannelsListParamsIF#getCursor() cursor} to cursor.
     * @param cursor The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCursor(@Nullable String cursor) {
      this.cursor = cursor;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelsListParamsIF#getCursor() cursor} to cursor.
     * @param cursor The value for cursor
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCursor(Optional<String> cursor) {
      this.cursor = cursor.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelsListParamsIF#getLimit() limit} to limit.
     * @param limit The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLimit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelsListParamsIF#getLimit() limit} to limit.
     * @param limit The value for limit
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLimit(Optional<Integer> limit) {
      this.limit = limit.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelsListParamsIF#shouldExcludeArchived() shouldExcludeArchived} to shouldExcludeArchived.
     * @param shouldExcludeArchived The value for shouldExcludeArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelsListParamsIF#shouldExcludeArchived() shouldExcludeArchived} to shouldExcludeArchived.
     * @param shouldExcludeArchived The value for shouldExcludeArchived
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ChannelsListParamsIF#shouldExcludeMembers() shouldExcludeMembers} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ChannelsListParamsIF#shouldExcludeMembers() shouldExcludeMembers}.</em>
     * @param shouldExcludeMembers The value for shouldExcludeMembers 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldExcludeMembers(boolean shouldExcludeMembers) {
      this.shouldExcludeMembers = shouldExcludeMembers;
      optBits |= OPT_BIT_SHOULD_EXCLUDE_MEMBERS;
      return this;
    }

    /**
     * Builds a new {@link ChannelsListParams ChannelsListParams}.
     * @return An immutable instance of ChannelsListParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelsListParams build() throws InvalidImmutableStateException {
      return new ChannelsListParams(this);
    }

    private boolean shouldExcludeMembersIsSet() {
      return (optBits & OPT_BIT_SHOULD_EXCLUDE_MEMBERS) != 0;
    }
  }
}
