package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.ChannelType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link FindRepliesParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code FindRepliesParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FindRepliesParamsIF"})
@Immutable
public final class FindRepliesParams
    implements FindRepliesParamsIF {
  private final String channelId;
  private final ChannelType channelType;
  private final String threadTs;

  private FindRepliesParams(String channelId, String threadTs) {
    this.channelId = channelId;
    this.threadTs = threadTs;
    this.channelType = Objects.requireNonNull(FindRepliesParamsIF.super.getChannelType(), "channelType");
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The computed-at-construction value of the {@code channelType} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public ChannelType getChannelType() {
    return channelType;
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty("thread_ts")
  @Override
  public String getThreadTs() {
    return threadTs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FindRepliesParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final FindRepliesParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new FindRepliesParams(newValue, this.threadTs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FindRepliesParamsIF#getThreadTs() threadTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param threadTs A new value for threadTs
   * @return A modified copy of the {@code this} object
   */
  public final FindRepliesParams withThreadTs(String threadTs) {
    if (this.threadTs.equals(threadTs)) return this;
    String newValue = Objects.requireNonNull(threadTs, "threadTs");
    return new FindRepliesParams(this.channelId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code FindRepliesParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof FindRepliesParams
        && equalTo((FindRepliesParams) another);
  }

  private boolean equalTo(FindRepliesParams another) {
    return channelId.equals(another.channelId)
        && channelType.equals(another.channelType)
        && threadTs.equals(another.threadTs);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code channelType}, {@code threadTs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + channelType.hashCode();
    h = h * 17 + threadTs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FindRepliesParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FindRepliesParams{"
        + "channelId=" + channelId
        + ", channelType=" + channelType
        + ", threadTs=" + threadTs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FindRepliesParamsIF {
    @Nullable String channelId;
    @Nullable String threadTs;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("thread_ts")
    public void setThreadTs(String threadTs) {
      this.threadTs = threadTs;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public ChannelType getChannelType() { throw new UnsupportedOperationException(); }
    @Override
    public String getThreadTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static FindRepliesParams fromJson(Json json) {
    FindRepliesParams.Builder builder = FindRepliesParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FindRepliesParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FindRepliesParams instance
   */
  public static FindRepliesParams copyOf(FindRepliesParamsIF instance) {
    if (instance instanceof FindRepliesParams) {
      return (FindRepliesParams) instance;
    }
    return FindRepliesParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link FindRepliesParams FindRepliesParams}.
   * @return A new FindRepliesParams builder
   */
  public static FindRepliesParams.Builder builder() {
    return new FindRepliesParams.Builder();
  }

  /**
   * Builds instances of type {@link FindRepliesParams FindRepliesParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_THREAD_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String channelId;
    private @Nullable String threadTs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.FindRepliesParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FindRepliesParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.channels.ReplyQueryParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ReplyQueryParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof FindRepliesParamsIF) {
        FindRepliesParamsIF instance = (FindRepliesParamsIF) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ReplyQueryParams) {
        ReplyQueryParams instance = (ReplyQueryParams) object;
        setThreadTs(instance.getThreadTs());
      }
    }

    /**
     * Initializes the value for the {@link FindRepliesParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FindRepliesParamsIF#getThreadTs() threadTs} attribute.
     * @param threadTs The value for threadTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(String threadTs) {
      this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
      initBits &= ~INIT_BIT_THREAD_TS;
      return this;
    }

    /**
     * Builds a new {@link FindRepliesParams FindRepliesParams}.
     * @return An immutable instance of FindRepliesParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public FindRepliesParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new FindRepliesParams(channelId, threadTs);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean threadTsIsSet() {
      return (initBits & INIT_BIT_THREAD_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!threadTsIsSet()) attributes.add("threadTs");
      return "Cannot build FindRepliesParams, some of required attributes are not set " + attributes;
    }
  }
}
