package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractChatDeleteParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatDeleteParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractChatDeleteParams"})
@Immutable
public final class ChatDeleteParams
    extends AbstractChatDeleteParams {
  private final String channelId;
  private final String messageToDeleteTs;
  private final boolean asUser;

  private ChatDeleteParams(ChatDeleteParams.Builder builder) {
    this.channelId = builder.channelId;
    this.messageToDeleteTs = builder.messageToDeleteTs;
    this.asUser = builder.asUserIsSet()
        ? builder.asUser
        : super.getAsUser();
  }

  private ChatDeleteParams(String channelId, String messageToDeleteTs, boolean asUser) {
    this.channelId = channelId;
    this.messageToDeleteTs = messageToDeleteTs;
    this.asUser = asUser;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code messageToDeleteTs} attribute
   */
  @JsonProperty("ts")
  @Override
  public String getMessageToDeleteTs() {
    return messageToDeleteTs;
  }

  /**
   * @return The value of the {@code asUser} attribute
   */
  @JsonProperty("as_user")
  @Override
  public boolean getAsUser() {
    return asUser;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChatDeleteParams#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChatDeleteParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ChatDeleteParams(newValue, this.messageToDeleteTs, this.asUser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChatDeleteParams#getMessageToDeleteTs() messageToDeleteTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param messageToDeleteTs A new value for messageToDeleteTs
   * @return A modified copy of the {@code this} object
   */
  public final ChatDeleteParams withMessageToDeleteTs(String messageToDeleteTs) {
    if (this.messageToDeleteTs.equals(messageToDeleteTs)) return this;
    String newValue = Objects.requireNonNull(messageToDeleteTs, "messageToDeleteTs");
    return new ChatDeleteParams(this.channelId, newValue, this.asUser);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractChatDeleteParams#getAsUser() asUser} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param asUser A new value for asUser
   * @return A modified copy of the {@code this} object
   */
  public final ChatDeleteParams withAsUser(boolean asUser) {
    if (this.asUser == asUser) return this;
    return new ChatDeleteParams(this.channelId, this.messageToDeleteTs, asUser);
  }

  /**
   * This instance is equal to all instances of {@code ChatDeleteParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatDeleteParams
        && equalTo((ChatDeleteParams) another);
  }

  private boolean equalTo(ChatDeleteParams another) {
    return channelId.equals(another.channelId)
        && messageToDeleteTs.equals(another.messageToDeleteTs)
        && asUser == another.asUser;
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code messageToDeleteTs}, {@code asUser}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + messageToDeleteTs.hashCode();
    h = h * 17 + Boolean.hashCode(asUser);
    return h;
  }

  /**
   * Prints the immutable value {@code ChatDeleteParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChatDeleteParams{"
        + "channelId=" + channelId
        + ", messageToDeleteTs=" + messageToDeleteTs
        + ", asUser=" + asUser
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractChatDeleteParams {
    @Nullable String channelId;
    @Nullable String messageToDeleteTs;
    boolean asUser;
    boolean asUserIsSet;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("ts")
    public void setMessageToDeleteTs(String messageToDeleteTs) {
      this.messageToDeleteTs = messageToDeleteTs;
    }
    @JsonProperty("as_user")
    public void setAsUser(boolean asUser) {
      this.asUser = asUser;
      this.asUserIsSet = true;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessageToDeleteTs() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getAsUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatDeleteParams fromJson(Json json) {
    ChatDeleteParams.Builder builder = ChatDeleteParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.messageToDeleteTs != null) {
      builder.setMessageToDeleteTs(json.messageToDeleteTs);
    }
    if (json.asUserIsSet) {
      builder.setAsUser(json.asUser);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractChatDeleteParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatDeleteParams instance
   */
  public static ChatDeleteParams copyOf(AbstractChatDeleteParams instance) {
    if (instance instanceof ChatDeleteParams) {
      return (ChatDeleteParams) instance;
    }
    return ChatDeleteParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatDeleteParams ChatDeleteParams}.
   * @return A new ChatDeleteParams builder
   */
  public static ChatDeleteParams.Builder builder() {
    return new ChatDeleteParams.Builder();
  }

  /**
   * Builds instances of type {@link ChatDeleteParams ChatDeleteParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_MESSAGE_TO_DELETE_TS = 0x2L;
    private static final long OPT_BIT_AS_USER = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String channelId;
    private @Nullable String messageToDeleteTs;
    private boolean asUser;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.AbstractChatDeleteParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractChatDeleteParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractChatDeleteParams) {
        AbstractChatDeleteParams instance = (AbstractChatDeleteParams) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
        setAsUser(instance.getAsUser());
        setMessageToDeleteTs(instance.getMessageToDeleteTs());
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractChatDeleteParams#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractChatDeleteParams#getMessageToDeleteTs() messageToDeleteTs} attribute.
     * @param messageToDeleteTs The value for messageToDeleteTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessageToDeleteTs(String messageToDeleteTs) {
      this.messageToDeleteTs = Objects.requireNonNull(messageToDeleteTs, "messageToDeleteTs");
      initBits &= ~INIT_BIT_MESSAGE_TO_DELETE_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractChatDeleteParams#getAsUser() asUser} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractChatDeleteParams#getAsUser() asUser}.</em>
     * @param asUser The value for asUser 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAsUser(boolean asUser) {
      this.asUser = asUser;
      optBits |= OPT_BIT_AS_USER;
      return this;
    }

    /**
     * Builds a new {@link ChatDeleteParams ChatDeleteParams}.
     * @return An immutable instance of ChatDeleteParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatDeleteParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatDeleteParams(this);
    }

    private boolean asUserIsSet() {
      return (optBits & OPT_BIT_AS_USER) != 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean messageToDeleteTsIsSet() {
      return (initBits & INIT_BIT_MESSAGE_TO_DELETE_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!messageToDeleteTsIsSet()) attributes.add("messageToDeleteTs");
      return "Cannot build ChatDeleteParams, some of required attributes are not set " + attributes;
    }
  }
}
