package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatGetPermalinkParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatGetPermalinkParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatGetPermalinkParamsIF"})
@Immutable
public final class ChatGetPermalinkParams
    implements ChatGetPermalinkParamsIF {
  private final String channelId;
  private final String messageTs;

  private ChatGetPermalinkParams(String channelId, String messageTs) {
    this.channelId = channelId;
    this.messageTs = messageTs;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code messageTs} attribute
   */
  @JsonProperty
  @Override
  public String getMessageTs() {
    return messageTs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatGetPermalinkParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChatGetPermalinkParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ChatGetPermalinkParams(newValue, this.messageTs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatGetPermalinkParamsIF#getMessageTs() messageTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param messageTs A new value for messageTs
   * @return A modified copy of the {@code this} object
   */
  public final ChatGetPermalinkParams withMessageTs(String messageTs) {
    if (this.messageTs.equals(messageTs)) return this;
    String newValue = Objects.requireNonNull(messageTs, "messageTs");
    return new ChatGetPermalinkParams(this.channelId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ChatGetPermalinkParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatGetPermalinkParams
        && equalTo((ChatGetPermalinkParams) another);
  }

  private boolean equalTo(ChatGetPermalinkParams another) {
    return channelId.equals(another.channelId)
        && messageTs.equals(another.messageTs);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code messageTs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + messageTs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChatGetPermalinkParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChatGetPermalinkParams{"
        + "channelId=" + channelId
        + ", messageTs=" + messageTs
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatGetPermalinkParamsIF {
    @Nullable String channelId;
    @Nullable String messageTs;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setMessageTs(String messageTs) {
      this.messageTs = messageTs;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getMessageTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatGetPermalinkParams fromJson(Json json) {
    ChatGetPermalinkParams.Builder builder = ChatGetPermalinkParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.messageTs != null) {
      builder.setMessageTs(json.messageTs);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChatGetPermalinkParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatGetPermalinkParams instance
   */
  public static ChatGetPermalinkParams copyOf(ChatGetPermalinkParamsIF instance) {
    if (instance instanceof ChatGetPermalinkParams) {
      return (ChatGetPermalinkParams) instance;
    }
    return ChatGetPermalinkParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatGetPermalinkParams ChatGetPermalinkParams}.
   * @return A new ChatGetPermalinkParams builder
   */
  public static ChatGetPermalinkParams.Builder builder() {
    return new ChatGetPermalinkParams.Builder();
  }

  /**
   * Builds instances of type {@link ChatGetPermalinkParams ChatGetPermalinkParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_MESSAGE_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String channelId;
    private @Nullable String messageTs;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.ChatGetPermalinkParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatGetPermalinkParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ChatGetPermalinkParamsIF) {
        ChatGetPermalinkParamsIF instance = (ChatGetPermalinkParamsIF) object;
        setMessageTs(instance.getMessageTs());
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ChatGetPermalinkParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatGetPermalinkParamsIF#getMessageTs() messageTs} attribute.
     * @param messageTs The value for messageTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessageTs(String messageTs) {
      this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
      initBits &= ~INIT_BIT_MESSAGE_TS;
      return this;
    }

    /**
     * Builds a new {@link ChatGetPermalinkParams ChatGetPermalinkParams}.
     * @return An immutable instance of ChatGetPermalinkParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatGetPermalinkParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatGetPermalinkParams(channelId, messageTs);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean messageTsIsSet() {
      return (initBits & INIT_BIT_MESSAGE_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!messageTsIsSet()) attributes.add("messageTs");
      return "Cannot build ChatGetPermalinkParams, some of required attributes are not set " + attributes;
    }
  }
}
