package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatUpdateMessageParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatUpdateMessageParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatUpdateMessageParamsIF"})
@Immutable
public final class ChatUpdateMessageParams
    implements ChatUpdateMessageParamsIF {
  private final String channelId;
  private final @Nullable String text;
  private final String ts;
  private final @Nullable Boolean asUser;
  private final boolean shouldLinkNames;
  private final String parse;
  private final List<Attachment> attachments;
  private final List<Block> blocks;

  private ChatUpdateMessageParams(ChatUpdateMessageParams.Builder builder) {
    this.channelId = builder.channelId;
    this.text = builder.text;
    this.ts = builder.ts;
    this.asUser = builder.asUser;
    this.attachments = createUnmodifiableList(true, builder.attachments);
    if (builder.shouldLinkNamesIsSet()) {
      initShim.setShouldLinkNames(builder.shouldLinkNames);
    }
    if (builder.parse != null) {
      initShim.setParse(builder.parse);
    }
    if (builder.blocksIsSet()) {
      initShim.setBlocks(createUnmodifiableList(true, builder.blocks));
    }
    this.shouldLinkNames = initShim.shouldLinkNames();
    this.parse = initShim.getParse();
    this.blocks = initShim.getBlocks();
    this.initShim = null;
  }

  private ChatUpdateMessageParams(
      String channelId,
      @Nullable String text,
      String ts,
      @Nullable Boolean asUser,
      boolean shouldLinkNames,
      String parse,
      List<Attachment> attachments,
      List<Block> blocks) {
    this.channelId = channelId;
    this.text = text;
    this.ts = ts;
    this.asUser = asUser;
    this.shouldLinkNames = shouldLinkNames;
    this.parse = parse;
    this.attachments = attachments;
    this.blocks = blocks;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private boolean shouldLinkNames;
    private int shouldLinkNamesStage;

    boolean shouldLinkNames() {
      if (shouldLinkNamesStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (shouldLinkNamesStage == STAGE_UNINITIALIZED) {
        shouldLinkNamesStage = STAGE_INITIALIZING;
        this.shouldLinkNames = shouldLinkNamesInitialize();
        shouldLinkNamesStage = STAGE_INITIALIZED;
      }
      return this.shouldLinkNames;
    }

    void setShouldLinkNames(boolean shouldLinkNames) {
      this.shouldLinkNames = shouldLinkNames;
      shouldLinkNamesStage = STAGE_INITIALIZED;
    }
    private String parse;
    private int parseStage;

    String getParse() {
      if (parseStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (parseStage == STAGE_UNINITIALIZED) {
        parseStage = STAGE_INITIALIZING;
        this.parse = Objects.requireNonNull(getParseInitialize(), "parse");
        parseStage = STAGE_INITIALIZED;
      }
      return this.parse;
    }

    void setParse(String parse) {
      this.parse = parse;
      parseStage = STAGE_INITIALIZED;
    }
    private List<Block> blocks;
    private int blocksStage;

    List<Block> getBlocks() {
      if (blocksStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (blocksStage == STAGE_UNINITIALIZED) {
        blocksStage = STAGE_INITIALIZING;
        this.blocks = createUnmodifiableList(false, createSafeList(getBlocksInitialize(), true, false));
        blocksStage = STAGE_INITIALIZED;
      }
      return this.blocks;
    }

    void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      blocksStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (shouldLinkNamesStage == STAGE_INITIALIZING) attributes.add("shouldLinkNames");
      if (parseStage == STAGE_INITIALIZING) attributes.add("parse");
      if (blocksStage == STAGE_INITIALIZING) attributes.add("blocks");
      return "Cannot build ChatUpdateMessageParams, attribute initializers form cycle" + attributes;
    }
  }

  private boolean shouldLinkNamesInitialize() {
    return ChatUpdateMessageParamsIF.super.shouldLinkNames();
  }

  private String getParseInitialize() {
    return ChatUpdateMessageParamsIF.super.getParse();
  }

  private List<Block> getBlocksInitialize() {
    return ChatUpdateMessageParamsIF.super.getBlocks();
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * @return The value of the {@code asUser} attribute
   */
  @JsonProperty("as_user")
  @Override
  public Optional<Boolean> getAsUser() {
    return Optional.ofNullable(asUser);
  }

  /**
   * @return The value of the {@code shouldLinkNames} attribute
   */
  @JsonProperty("link_names")
  @Override
  public boolean shouldLinkNames() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.shouldLinkNames()
        : this.shouldLinkNames;
  }

  /**
   * @return The value of the {@code parse} attribute
   */
  @JsonProperty
  @Override
  public String getParse() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getParse()
        : this.parse;
  }

  /**
   * @return The value of the {@code attachments} attribute
   */
  @JsonProperty
  @Override
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * @return The value of the {@code blocks} attribute
   */
  @JsonProperty
  @Override
  public List<Block> getBlocks() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getBlocks()
        : this.blocks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return validate(new ChatUpdateMessageParams(
        newValue,
        this.text,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatUpdateMessageParamsIF#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        newValue,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatUpdateMessageParamsIF#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        value,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageParamsIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageParams withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        newValue,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatUpdateMessageParamsIF#getAsUser() asUser} attribute.
   * @param value The value for asUser, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withAsUser(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.asUser, newValue)) return this;
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        newValue,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatUpdateMessageParamsIF#getAsUser() asUser} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for asUser
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withAsUser(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.asUser, value)) return this;
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        value,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageParamsIF#shouldLinkNames() shouldLinkNames} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param shouldLinkNames A new value for shouldLinkNames
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageParams withShouldLinkNames(boolean shouldLinkNames) {
    if (this.shouldLinkNames == shouldLinkNames) return this;
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        this.asUser,
        shouldLinkNames,
        this.parse,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatUpdateMessageParamsIF#getParse() parse} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param parse A new value for parse
   * @return A modified copy of the {@code this} object
   */
  public final ChatUpdateMessageParams withParse(String parse) {
    if (this.parse.equals(parse)) return this;
    String newValue = Objects.requireNonNull(parse, "parse");
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        newValue,
        this.attachments,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatUpdateMessageParamsIF#getAttachments() attachments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withAttachments(Attachment... elements) {
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        newValue,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatUpdateMessageParamsIF#getAttachments() attachments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attachments elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withAttachments(Iterable<? extends Attachment> elements) {
    if (this.attachments == elements) return this;
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        newValue,
        this.blocks));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatUpdateMessageParamsIF#getBlocks() blocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withBlocks(Block... elements) {
    List<Block> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ChatUpdateMessageParamsIF#getBlocks() blocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of blocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ChatUpdateMessageParams withBlocks(Iterable<? extends Block> elements) {
    if (this.blocks == elements) return this;
    List<Block> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ChatUpdateMessageParams(
        this.channelId,
        this.text,
        this.ts,
        this.asUser,
        this.shouldLinkNames,
        this.parse,
        this.attachments,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ChatUpdateMessageParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatUpdateMessageParams
        && equalTo((ChatUpdateMessageParams) another);
  }

  private boolean equalTo(ChatUpdateMessageParams another) {
    return channelId.equals(another.channelId)
        && Objects.equals(text, another.text)
        && ts.equals(another.ts)
        && Objects.equals(asUser, another.asUser)
        && shouldLinkNames == another.shouldLinkNames
        && parse.equals(another.parse)
        && attachments.equals(another.attachments)
        && blocks.equals(another.blocks);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code text}, {@code ts}, {@code asUser}, {@code shouldLinkNames}, {@code parse}, {@code attachments}, {@code blocks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + ts.hashCode();
    h = h * 17 + Objects.hashCode(asUser);
    h = h * 17 + Boolean.hashCode(shouldLinkNames);
    h = h * 17 + parse.hashCode();
    h = h * 17 + attachments.hashCode();
    h = h * 17 + blocks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChatUpdateMessageParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatUpdateMessageParams{");
    builder.append("channelId=").append(channelId);
    if (text != null) {
      builder.append(", ");
      builder.append("text=").append(text);
    }
    builder.append(", ");
    builder.append("ts=").append(ts);
    if (asUser != null) {
      builder.append(", ");
      builder.append("asUser=").append(asUser);
    }
    builder.append(", ");
    builder.append("shouldLinkNames=").append(shouldLinkNames);
    builder.append(", ");
    builder.append("parse=").append(parse);
    builder.append(", ");
    builder.append("attachments=").append(attachments);
    builder.append(", ");
    builder.append("blocks=").append(blocks);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatUpdateMessageParamsIF {
    @Nullable String channelId;
    Optional<String> text = Optional.empty();
    @Nullable String ts;
    Optional<Boolean> asUser = Optional.empty();
    boolean shouldLinkNames;
    boolean shouldLinkNamesIsSet;
    @Nullable String parse;
    List<Attachment> attachments = Collections.emptyList();
    List<Block> blocks = Collections.emptyList();
    boolean blocksIsSet;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @JsonProperty("as_user")
    public void setAsUser(Optional<Boolean> asUser) {
      this.asUser = asUser;
    }
    @JsonProperty("link_names")
    public void setShouldLinkNames(boolean shouldLinkNames) {
      this.shouldLinkNames = shouldLinkNames;
      this.shouldLinkNamesIsSet = true;
    }
    @JsonProperty
    public void setParse(String parse) {
      this.parse = parse;
    }
    @JsonProperty
    public void setAttachments(List<Attachment> attachments) {
      this.attachments = attachments;
    }
    @JsonProperty
    public void setBlocks(List<Block> blocks) {
      this.blocks = blocks;
      this.blocksIsSet = true;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getAsUser() { throw new UnsupportedOperationException(); }
    @Override
    public boolean shouldLinkNames() { throw new UnsupportedOperationException(); }
    @Override
    public String getParse() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attachment> getAttachments() { throw new UnsupportedOperationException(); }
    @Override
    public List<Block> getBlocks() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatUpdateMessageParams fromJson(Json json) {
    ChatUpdateMessageParams.Builder builder = ChatUpdateMessageParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    if (json.asUser != null) {
      builder.setAsUser(json.asUser);
    }
    if (json.shouldLinkNamesIsSet) {
      builder.setShouldLinkNames(json.shouldLinkNames);
    }
    if (json.parse != null) {
      builder.setParse(json.parse);
    }
    if (json.attachments != null) {
      builder.addAllAttachments(json.attachments);
    }
    if (json.blocksIsSet) {
      builder.setBlocks(json.blocks);
    }
    return builder.build();
  }

  private static ChatUpdateMessageParams validate(ChatUpdateMessageParams instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link ChatUpdateMessageParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatUpdateMessageParams instance
   */
  public static ChatUpdateMessageParams copyOf(ChatUpdateMessageParamsIF instance) {
    if (instance instanceof ChatUpdateMessageParams) {
      return (ChatUpdateMessageParams) instance;
    }
    return ChatUpdateMessageParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatUpdateMessageParams ChatUpdateMessageParams}.
   * @return A new ChatUpdateMessageParams builder
   */
  public static ChatUpdateMessageParams.Builder builder() {
    return new ChatUpdateMessageParams.Builder();
  }

  /**
   * Builds instances of type {@link ChatUpdateMessageParams ChatUpdateMessageParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_TS = 0x2L;
    private static final long OPT_BIT_SHOULD_LINK_NAMES = 0x1L;
    private static final long OPT_BIT_BLOCKS = 0x2L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable String channelId;
    private @Nullable String text;
    private @Nullable String ts;
    private @Nullable Boolean asUser;
    private boolean shouldLinkNames;
    private @Nullable String parse;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<Block> blocks = new ArrayList<Block>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.MessageParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.chat.ChatUpdateMessageParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatUpdateMessageParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof MessageParams) {
        MessageParams instance = (MessageParams) object;
        addAllBlocks(instance.getBlocks());
        addAllAttachments(instance.getAttachments());
        if ((bits & 0x1L) == 0) {
          Optional<String> textOptional = instance.getText();
          if (textOptional.isPresent()) {
            setText(textOptional);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
      if (object instanceof ChatUpdateMessageParamsIF) {
        ChatUpdateMessageParamsIF instance = (ChatUpdateMessageParamsIF) object;
        if ((bits & 0x1L) == 0) {
          Optional<String> textOptional = instance.getText();
          if (textOptional.isPresent()) {
            setText(textOptional);
          }
          bits |= 0x1L;
        }
        setParse(instance.getParse());
        setShouldLinkNames(instance.shouldLinkNames());
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
        Optional<Boolean> asUserOptional = instance.getAsUser();
        if (asUserOptional.isPresent()) {
          setAsUser(asUserOptional);
        }
        setTs(instance.getTs());
      }
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUpdateMessageParamsIF#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUpdateMessageParamsIF#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageParamsIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUpdateMessageParamsIF#getAsUser() asUser} to asUser.
     * @param asUser The value for asUser, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAsUser(@Nullable Boolean asUser) {
      this.asUser = asUser;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatUpdateMessageParamsIF#getAsUser() asUser} to asUser.
     * @param asUser The value for asUser
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAsUser(Optional<Boolean> asUser) {
      this.asUser = asUser.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageParamsIF#shouldLinkNames() shouldLinkNames} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ChatUpdateMessageParamsIF#shouldLinkNames() shouldLinkNames}.</em>
     * @param shouldLinkNames The value for shouldLinkNames 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldLinkNames(boolean shouldLinkNames) {
      this.shouldLinkNames = shouldLinkNames;
      optBits |= OPT_BIT_SHOULD_LINK_NAMES;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatUpdateMessageParamsIF#getParse() parse} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ChatUpdateMessageParamsIF#getParse() parse}.</em>
     * @param parse The value for parse 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setParse(String parse) {
      this.parse = Objects.requireNonNull(parse, "parse");
      return this;
    }

    /**
     * Adds one element to {@link ChatUpdateMessageParamsIF#getAttachments() attachments} list.
     * @param element A attachments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment element) {
      this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      return this;
    }

    /**
     * Adds elements to {@link ChatUpdateMessageParamsIF#getAttachments() attachments} list.
     * @param elements An array of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment... elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ChatUpdateMessageParamsIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachments(Iterable<? extends Attachment> elements) {
      this.attachments.clear();
      return addAllAttachments(elements);
    }

    /**
     * Adds elements to {@link ChatUpdateMessageParamsIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ChatUpdateMessageParamsIF#getBlocks() blocks} list.
     * @param element A blocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block element) {
      this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Adds elements to {@link ChatUpdateMessageParamsIF#getBlocks() blocks} list.
     * @param elements An array of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addBlocks(Block... elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ChatUpdateMessageParamsIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlocks(Iterable<? extends Block> elements) {
      this.blocks.clear();
      return addAllBlocks(elements);
    }

    /**
     * Adds elements to {@link ChatUpdateMessageParamsIF#getBlocks() blocks} list.
     * @param elements An iterable of blocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBlocks(Iterable<? extends Block> elements) {
      for (Block element : elements) {
        this.blocks.add(Objects.requireNonNull(element, "blocks element"));
      }
      optBits |= OPT_BIT_BLOCKS;
      return this;
    }

    /**
     * Builds a new {@link ChatUpdateMessageParams ChatUpdateMessageParams}.
     * @return An immutable instance of ChatUpdateMessageParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatUpdateMessageParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this));
    }

    private boolean shouldLinkNamesIsSet() {
      return (optBits & OPT_BIT_SHOULD_LINK_NAMES) != 0;
    }

    private boolean blocksIsSet() {
      return (optBits & OPT_BIT_BLOCKS) != 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build ChatUpdateMessageParams, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
