package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractConversationHistoryPagedParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationHistoryPagedParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractConversationHistoryPagedParams"})
@Immutable
public final class ConversationHistoryPagedParams
    extends AbstractConversationHistoryPagedParams {
  private final String channelId;
  private final @Nullable String cursor;
  private final @Nullable Integer limit;
  private final @Nullable Boolean inclusive;
  private final @Nullable String newestTimestamp;
  private final @Nullable String oldestTimestamp;
  private final PagingDirection pagingDirection;

  private ConversationHistoryPagedParams(
      String channelId,
      @Nullable String cursor,
      @Nullable Integer limit,
      @Nullable Boolean inclusive,
      @Nullable String newestTimestamp,
      @Nullable String oldestTimestamp) {
    this.channelId = channelId;
    this.cursor = cursor;
    this.limit = limit;
    this.inclusive = inclusive;
    this.newestTimestamp = newestTimestamp;
    this.oldestTimestamp = oldestTimestamp;
    this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code cursor} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCursor() {
    return Optional.ofNullable(cursor);
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getLimit() {
    return Optional.ofNullable(limit);
  }

  /**
   * @return The value of the {@code inclusive} attribute
   */
  @JsonProperty("inclusive")
  @Override
  public Optional<Boolean> isInclusive() {
    return Optional.ofNullable(inclusive);
  }

  /**
   * @return The value of the {@code newestTimestamp} attribute
   */
  @JsonProperty("latest")
  @Override
  public Optional<String> getNewestTimestamp() {
    return Optional.ofNullable(newestTimestamp);
  }

  /**
   * @return The value of the {@code oldestTimestamp} attribute
   */
  @JsonProperty("oldest")
  @Override
  public Optional<String> getOldestTimestamp() {
    return Optional.ofNullable(oldestTimestamp);
  }

  /**
   * @return The computed-at-construction value of the {@code pagingDirection} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public PagingDirection getPagingDirection() {
    return pagingDirection;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractConversationHistoryPagedParams#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationHistoryPagedParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationHistoryPagedParams(newValue, this.cursor, this.limit, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractConversationHistoryPagedParams#getCursor() cursor} attribute.
   * @param value The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withCursor(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.cursor, newValue)) return this;
    return new ConversationHistoryPagedParams(
        this.channelId,
        newValue,
        this.limit,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractConversationHistoryPagedParams#getCursor() cursor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cursor
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withCursor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.cursor, value)) return this;
    return new ConversationHistoryPagedParams(this.channelId, value, this.limit, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractConversationHistoryPagedParams#getLimit() limit} attribute.
   * @param value The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withLimit(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.limit, newValue)) return this;
    return new ConversationHistoryPagedParams(
        this.channelId,
        this.cursor,
        newValue,
        this.inclusive,
        this.newestTimestamp,
        this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractConversationHistoryPagedParams#getLimit() limit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for limit
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withLimit(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.limit, value)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, value, this.inclusive, this.newestTimestamp, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractConversationHistoryPagedParams#isInclusive() inclusive} attribute.
   * @param value The value for inclusive, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withInclusive(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.inclusive, newValue)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, newValue, this.newestTimestamp, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractConversationHistoryPagedParams#isInclusive() inclusive} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for inclusive
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withInclusive(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.inclusive, value)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, value, this.newestTimestamp, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractConversationHistoryPagedParams#getNewestTimestamp() newestTimestamp} attribute.
   * @param value The value for newestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withNewestTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.newestTimestamp, newValue)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, newValue, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractConversationHistoryPagedParams#getNewestTimestamp() newestTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for newestTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withNewestTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.newestTimestamp, value)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, value, this.oldestTimestamp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractConversationHistoryPagedParams#getOldestTimestamp() oldestTimestamp} attribute.
   * @param value The value for oldestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withOldestTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.oldestTimestamp, newValue)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, this.newestTimestamp, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractConversationHistoryPagedParams#getOldestTimestamp() oldestTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oldestTimestamp
   * @return A modified copy of {@code this} object
   */
  public final ConversationHistoryPagedParams withOldestTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.oldestTimestamp, value)) return this;
    return new ConversationHistoryPagedParams(this.channelId, this.cursor, this.limit, this.inclusive, this.newestTimestamp, value);
  }

  /**
   * This instance is equal to all instances of {@code ConversationHistoryPagedParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationHistoryPagedParams
        && equalTo((ConversationHistoryPagedParams) another);
  }

  private boolean equalTo(ConversationHistoryPagedParams another) {
    return channelId.equals(another.channelId)
        && Objects.equals(cursor, another.cursor)
        && Objects.equals(limit, another.limit)
        && Objects.equals(inclusive, another.inclusive)
        && Objects.equals(newestTimestamp, another.newestTimestamp)
        && Objects.equals(oldestTimestamp, another.oldestTimestamp)
        && pagingDirection.equals(another.pagingDirection);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code cursor}, {@code limit}, {@code inclusive}, {@code newestTimestamp}, {@code oldestTimestamp}, {@code pagingDirection}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(cursor);
    h = h * 17 + Objects.hashCode(limit);
    h = h * 17 + Objects.hashCode(inclusive);
    h = h * 17 + Objects.hashCode(newestTimestamp);
    h = h * 17 + Objects.hashCode(oldestTimestamp);
    h = h * 17 + pagingDirection.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationHistoryPagedParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationHistoryPagedParams{");
    builder.append("channelId=").append(channelId);
    if (cursor != null) {
      builder.append(", ");
      builder.append("cursor=").append(cursor);
    }
    if (limit != null) {
      builder.append(", ");
      builder.append("limit=").append(limit);
    }
    if (inclusive != null) {
      builder.append(", ");
      builder.append("inclusive=").append(inclusive);
    }
    if (newestTimestamp != null) {
      builder.append(", ");
      builder.append("newestTimestamp=").append(newestTimestamp);
    }
    if (oldestTimestamp != null) {
      builder.append(", ");
      builder.append("oldestTimestamp=").append(oldestTimestamp);
    }
    builder.append(", ");
    builder.append("pagingDirection=").append(pagingDirection);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractConversationHistoryPagedParams {
    @Nullable String channelId;
    Optional<String> cursor = Optional.empty();
    Optional<Integer> limit = Optional.empty();
    Optional<Boolean> inclusive = Optional.empty();
    Optional<String> newestTimestamp = Optional.empty();
    Optional<String> oldestTimestamp = Optional.empty();
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setCursor(Optional<String> cursor) {
      this.cursor = cursor;
    }
    @JsonProperty
    public void setLimit(Optional<Integer> limit) {
      this.limit = limit;
    }
    @JsonProperty("inclusive")
    public void setInclusive(Optional<Boolean> inclusive) {
      this.inclusive = inclusive;
    }
    @JsonProperty("latest")
    public void setNewestTimestamp(Optional<String> newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
    }
    @JsonProperty("oldest")
    public void setOldestTimestamp(Optional<String> oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getCursor() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getLimit() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isInclusive() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getNewestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getOldestTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public PagingDirection getPagingDirection() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationHistoryPagedParams fromJson(Json json) {
    ConversationHistoryPagedParams.Builder builder = ConversationHistoryPagedParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.cursor != null) {
      builder.setCursor(json.cursor);
    }
    if (json.limit != null) {
      builder.setLimit(json.limit);
    }
    if (json.inclusive != null) {
      builder.setInclusive(json.inclusive);
    }
    if (json.newestTimestamp != null) {
      builder.setNewestTimestamp(json.newestTimestamp);
    }
    if (json.oldestTimestamp != null) {
      builder.setOldestTimestamp(json.oldestTimestamp);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractConversationHistoryPagedParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationHistoryPagedParams instance
   */
  public static ConversationHistoryPagedParams copyOf(AbstractConversationHistoryPagedParams instance) {
    if (instance instanceof ConversationHistoryPagedParams) {
      return (ConversationHistoryPagedParams) instance;
    }
    return ConversationHistoryPagedParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationHistoryPagedParams ConversationHistoryPagedParams}.
   * @return A new ConversationHistoryPagedParams builder
   */
  public static ConversationHistoryPagedParams.Builder builder() {
    return new ConversationHistoryPagedParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationHistoryPagedParams ConversationHistoryPagedParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String channelId;
    private @Nullable String cursor;
    private @Nullable Integer limit;
    private @Nullable Boolean inclusive;
    private @Nullable String newestTimestamp;
    private @Nullable String oldestTimestamp;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.TimeIntervalFilter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TimeIntervalFilter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.conversations.AbstractConversationHistoryPagedParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractConversationHistoryPagedParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof TimeIntervalFilter) {
        TimeIntervalFilter instance = (TimeIntervalFilter) object;
        Optional<String> oldestTimestampOptional = instance.getOldestTimestamp();
        if (oldestTimestampOptional.isPresent()) {
          setOldestTimestamp(oldestTimestampOptional);
        }
        Optional<Boolean> inclusiveOptional = instance.isInclusive();
        if (inclusiveOptional.isPresent()) {
          setInclusive(inclusiveOptional);
        }
        Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
        if (newestTimestampOptional.isPresent()) {
          setNewestTimestamp(newestTimestampOptional);
        }
      }
      if (object instanceof AbstractConversationHistoryPagedParams) {
        AbstractConversationHistoryPagedParams instance = (AbstractConversationHistoryPagedParams) object;
        Optional<String> cursorOptional = instance.getCursor();
        if (cursorOptional.isPresent()) {
          setCursor(cursorOptional);
        }
        Optional<Integer> limitOptional = instance.getLimit();
        if (limitOptional.isPresent()) {
          setLimit(limitOptional);
        }
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractConversationHistoryPagedParams#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getCursor() cursor} to cursor.
     * @param cursor The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCursor(@Nullable String cursor) {
      this.cursor = cursor;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getCursor() cursor} to cursor.
     * @param cursor The value for cursor
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCursor(Optional<String> cursor) {
      this.cursor = cursor.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getLimit() limit} to limit.
     * @param limit The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLimit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getLimit() limit} to limit.
     * @param limit The value for limit
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLimit(Optional<Integer> limit) {
      this.limit = limit.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#isInclusive() inclusive} to inclusive.
     * @param inclusive The value for inclusive, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInclusive(@Nullable Boolean inclusive) {
      this.inclusive = inclusive;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#isInclusive() inclusive} to inclusive.
     * @param inclusive The value for inclusive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInclusive(Optional<Boolean> inclusive) {
      this.inclusive = inclusive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getNewestTimestamp() newestTimestamp} to newestTimestamp.
     * @param newestTimestamp The value for newestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
      this.newestTimestamp = newestTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getNewestTimestamp() newestTimestamp} to newestTimestamp.
     * @param newestTimestamp The value for newestTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
      this.newestTimestamp = newestTimestamp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getOldestTimestamp() oldestTimestamp} to oldestTimestamp.
     * @param oldestTimestamp The value for oldestTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractConversationHistoryPagedParams#getOldestTimestamp() oldestTimestamp} to oldestTimestamp.
     * @param oldestTimestamp The value for oldestTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
      this.oldestTimestamp = oldestTimestamp.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ConversationHistoryPagedParams ConversationHistoryPagedParams}.
     * @return An immutable instance of ConversationHistoryPagedParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationHistoryPagedParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationHistoryPagedParams(channelId, cursor, limit, inclusive, newestTimestamp, oldestTimestamp);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationHistoryPagedParams, some of required attributes are not set " + attributes;
    }
  }
}
