package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationMemberParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationMemberParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationMemberParamsIF"})
@Immutable
public final class ConversationMemberParams
    implements ConversationMemberParamsIF {
  private final @Nullable String cursor;
  private final @Nullable Integer limit;
  private final String channelId;

  private ConversationMemberParams(
      @Nullable String cursor,
      @Nullable Integer limit,
      String channelId) {
    this.cursor = cursor;
    this.limit = limit;
    this.channelId = channelId;
  }

  /**
   * @return The value of the {@code cursor} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getCursor() {
    return Optional.ofNullable(cursor);
  }

  /**
   * @return The value of the {@code limit} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getLimit() {
    return Optional.ofNullable(limit);
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationMemberParamsIF#getCursor() cursor} attribute.
   * @param value The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationMemberParams withCursor(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.cursor, newValue)) return this;
    return new ConversationMemberParams(newValue, this.limit, this.channelId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationMemberParamsIF#getCursor() cursor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for cursor
   * @return A modified copy of {@code this} object
   */
  public final ConversationMemberParams withCursor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.cursor, value)) return this;
    return new ConversationMemberParams(value, this.limit, this.channelId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationMemberParamsIF#getLimit() limit} attribute.
   * @param value The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationMemberParams withLimit(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.limit, newValue)) return this;
    return new ConversationMemberParams(this.cursor, newValue, this.channelId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationMemberParamsIF#getLimit() limit} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for limit
   * @return A modified copy of {@code this} object
   */
  public final ConversationMemberParams withLimit(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.limit, value)) return this;
    return new ConversationMemberParams(this.cursor, value, this.channelId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationMemberParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationMemberParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationMemberParams(this.cursor, this.limit, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationMemberParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationMemberParams
        && equalTo((ConversationMemberParams) another);
  }

  private boolean equalTo(ConversationMemberParams another) {
    return Objects.equals(cursor, another.cursor)
        && Objects.equals(limit, another.limit)
        && channelId.equals(another.channelId);
  }

  /**
   * Computes a hash code from attributes: {@code cursor}, {@code limit}, {@code channelId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(cursor);
    h = h * 17 + Objects.hashCode(limit);
    h = h * 17 + channelId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationMemberParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationMemberParams{");
    if (cursor != null) {
      builder.append("cursor=").append(cursor);
    }
    if (limit != null) {
      if (builder.length() > 25) builder.append(", ");
      builder.append("limit=").append(limit);
    }
    if (builder.length() > 25) builder.append(", ");
    builder.append("channelId=").append(channelId);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationMemberParamsIF {
    Optional<String> cursor = Optional.empty();
    Optional<Integer> limit = Optional.empty();
    @Nullable String channelId;
    @JsonProperty
    public void setCursor(Optional<String> cursor) {
      this.cursor = cursor;
    }
    @JsonProperty
    public void setLimit(Optional<Integer> limit) {
      this.limit = limit;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @Override
    public Optional<String> getCursor() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getLimit() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationMemberParams fromJson(Json json) {
    ConversationMemberParams.Builder builder = ConversationMemberParams.builder();
    if (json.cursor != null) {
      builder.setCursor(json.cursor);
    }
    if (json.limit != null) {
      builder.setLimit(json.limit);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationMemberParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationMemberParams instance
   */
  public static ConversationMemberParams copyOf(ConversationMemberParamsIF instance) {
    if (instance instanceof ConversationMemberParams) {
      return (ConversationMemberParams) instance;
    }
    return ConversationMemberParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationMemberParams ConversationMemberParams}.
   * @return A new ConversationMemberParams builder
   */
  public static ConversationMemberParams.Builder builder() {
    return new ConversationMemberParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationMemberParams ConversationMemberParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String cursor;
    private @Nullable Integer limit;
    private @Nullable String channelId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationMemberParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationMemberParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> cursorOptional = instance.getCursor();
      if (cursorOptional.isPresent()) {
        setCursor(cursorOptional);
      }
      Optional<Integer> limitOptional = instance.getLimit();
      if (limitOptional.isPresent()) {
        setLimit(limitOptional);
      }
      setChannelId(instance.getChannelId());
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationMemberParamsIF#getCursor() cursor} to cursor.
     * @param cursor The value for cursor, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setCursor(@Nullable String cursor) {
      this.cursor = cursor;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationMemberParamsIF#getCursor() cursor} to cursor.
     * @param cursor The value for cursor
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCursor(Optional<String> cursor) {
      this.cursor = cursor.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationMemberParamsIF#getLimit() limit} to limit.
     * @param limit The value for limit, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLimit(@Nullable Integer limit) {
      this.limit = limit;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationMemberParamsIF#getLimit() limit} to limit.
     * @param limit The value for limit
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLimit(Optional<Integer> limit) {
      this.limit = limit.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationMemberParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Builds a new {@link ConversationMemberParams ConversationMemberParams}.
     * @return An immutable instance of ConversationMemberParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationMemberParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationMemberParams(cursor, limit, channelId);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationMemberParams, some of required attributes are not set " + attributes;
    }
  }
}
