package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationOpenParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationOpenParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationOpenParamsIF"})
@Immutable
public final class ConversationOpenParams
    implements ConversationOpenParamsIF {
  private final @Nullable String channelId;
  private final List<String> users;
  private final boolean returnIm;

  private ConversationOpenParams(ConversationOpenParams.Builder builder) {
    this.channelId = builder.channelId;
    this.users = createUnmodifiableList(true, builder.users);
    this.returnIm = builder.returnImIsSet()
        ? builder.returnIm
        : ConversationOpenParamsIF.super.getReturnIm();
  }

  private ConversationOpenParams(
      @Nullable String channelId,
      List<String> users,
      boolean returnIm) {
    this.channelId = channelId;
    this.users = users;
    this.returnIm = returnIm;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public Optional<String> getChannelId() {
    return Optional.ofNullable(channelId);
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public List<String> getUsers() {
    return users;
  }

  /**
   * @return The value of the {@code returnIm} attribute
   */
  @JsonProperty
  @Override
  public boolean getReturnIm() {
    return returnIm;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationOpenParamsIF#getChannelId() channelId} attribute.
   * @param value The value for channelId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationOpenParams withChannelId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.channelId, newValue)) return this;
    return new ConversationOpenParams(newValue, this.users, this.returnIm);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationOpenParamsIF#getChannelId() channelId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for channelId
   * @return A modified copy of {@code this} object
   */
  public final ConversationOpenParams withChannelId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.channelId, value)) return this;
    return new ConversationOpenParams(value, this.users, this.returnIm);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationOpenParamsIF#getUsers() users}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationOpenParams withUsers(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ConversationOpenParams(this.channelId, newValue, this.returnIm);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationOpenParamsIF#getUsers() users}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of users elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationOpenParams withUsers(Iterable<String> elements) {
    if (this.users == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ConversationOpenParams(this.channelId, newValue, this.returnIm);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationOpenParamsIF#getReturnIm() returnIm} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param returnIm A new value for returnIm
   * @return A modified copy of the {@code this} object
   */
  public final ConversationOpenParams withReturnIm(boolean returnIm) {
    if (this.returnIm == returnIm) return this;
    return new ConversationOpenParams(this.channelId, this.users, returnIm);
  }

  /**
   * This instance is equal to all instances of {@code ConversationOpenParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationOpenParams
        && equalTo((ConversationOpenParams) another);
  }

  private boolean equalTo(ConversationOpenParams another) {
    return Objects.equals(channelId, another.channelId)
        && users.equals(another.users)
        && returnIm == another.returnIm;
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code users}, {@code returnIm}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(channelId);
    h = h * 17 + users.hashCode();
    h = h * 17 + Boolean.hashCode(returnIm);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationOpenParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationOpenParams{");
    if (channelId != null) {
      builder.append("channelId=").append(channelId);
    }
    if (builder.length() > 23) builder.append(", ");
    builder.append("users=").append(users);
    builder.append(", ");
    builder.append("returnIm=").append(returnIm);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationOpenParamsIF {
    Optional<String> channelId = Optional.empty();
    List<String> users = Collections.emptyList();
    boolean returnIm;
    boolean returnImIsSet;
    @JsonProperty("channel")
    public void setChannelId(Optional<String> channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    @JsonIgnore
    public void setUsers(List<String> users) {
      this.users = users;
    }
    @JsonProperty
    public void setReturnIm(boolean returnIm) {
      this.returnIm = returnIm;
      this.returnImIsSet = true;
    }
    @Override
    public Optional<String> getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getUsers() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getReturnIm() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationOpenParams fromJson(Json json) {
    ConversationOpenParams.Builder builder = ConversationOpenParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.users != null) {
      builder.addAllUsers(json.users);
    }
    if (json.returnImIsSet) {
      builder.setReturnIm(json.returnIm);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationOpenParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationOpenParams instance
   */
  public static ConversationOpenParams copyOf(ConversationOpenParamsIF instance) {
    if (instance instanceof ConversationOpenParams) {
      return (ConversationOpenParams) instance;
    }
    return ConversationOpenParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationOpenParams ConversationOpenParams}.
   * @return A new ConversationOpenParams builder
   */
  public static ConversationOpenParams.Builder builder() {
    return new ConversationOpenParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationOpenParams ConversationOpenParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_RETURN_IM = 0x1L;
    private long optBits;

    private @Nullable String channelId;
    private List<String> users = new ArrayList<String>();
    private boolean returnIm;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationOpenParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationOpenParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> channelIdOptional = instance.getChannelId();
      if (channelIdOptional.isPresent()) {
        setChannelId(channelIdOptional);
      }
      addAllUsers(instance.getUsers());
      setReturnIm(instance.getReturnIm());
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationOpenParamsIF#getChannelId() channelId} to channelId.
     * @param channelId The value for channelId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setChannelId(@Nullable String channelId) {
      this.channelId = channelId;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationOpenParamsIF#getChannelId() channelId} to channelId.
     * @param channelId The value for channelId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(Optional<String> channelId) {
      this.channelId = channelId.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ConversationOpenParamsIF#getUsers() users} list.
     * @param element A users element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String element) {
      this.users.add(Objects.requireNonNull(element, "users element"));
      return this;
    }

    /**
     * Adds elements to {@link ConversationOpenParamsIF#getUsers() users} list.
     * @param elements An array of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String... elements) {
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ConversationOpenParamsIF#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsers(Iterable<String> elements) {
      this.users.clear();
      return addAllUsers(elements);
    }

    /**
     * Adds elements to {@link ConversationOpenParamsIF#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUsers(Iterable<String> elements) {
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationOpenParamsIF#getReturnIm() returnIm} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ConversationOpenParamsIF#getReturnIm() returnIm}.</em>
     * @param returnIm The value for returnIm 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReturnIm(boolean returnIm) {
      this.returnIm = returnIm;
      optBits |= OPT_BIT_RETURN_IM;
      return this;
    }

    /**
     * Builds a new {@link ConversationOpenParams ConversationOpenParams}.
     * @return An immutable instance of ConversationOpenParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationOpenParams build() throws InvalidImmutableStateException {
      return new ConversationOpenParams(this);
    }

    private boolean returnImIsSet() {
      return (optBits & OPT_BIT_RETURN_IM) != 0;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
