package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationUnarchiveParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationUnarchiveParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationUnarchiveParamsIF"})
@Immutable
public final class ConversationUnarchiveParams
    implements ConversationUnarchiveParamsIF {
  private final String channelId;

  private ConversationUnarchiveParams(String channelId) {
    this.channelId = channelId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationUnarchiveParamsIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationUnarchiveParams withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ConversationUnarchiveParams(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationUnarchiveParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationUnarchiveParams
        && equalTo((ConversationUnarchiveParams) another);
  }

  private boolean equalTo(ConversationUnarchiveParams another) {
    return channelId.equals(another.channelId);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationUnarchiveParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationUnarchiveParams{"
        + "channelId=" + channelId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationUnarchiveParamsIF {
    @Nullable String channelId;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationUnarchiveParams fromJson(Json json) {
    ConversationUnarchiveParams.Builder builder = ConversationUnarchiveParams.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationUnarchiveParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationUnarchiveParams instance
   */
  public static ConversationUnarchiveParams copyOf(ConversationUnarchiveParamsIF instance) {
    if (instance instanceof ConversationUnarchiveParams) {
      return (ConversationUnarchiveParams) instance;
    }
    return ConversationUnarchiveParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationUnarchiveParams ConversationUnarchiveParams}.
   * @return A new ConversationUnarchiveParams builder
   */
  public static ConversationUnarchiveParams.Builder builder() {
    return new ConversationUnarchiveParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationUnarchiveParams ConversationUnarchiveParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String channelId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.conversations.ConversationUnarchiveParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationUnarchiveParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof ConversationUnarchiveParamsIF) {
        ConversationUnarchiveParamsIF instance = (ConversationUnarchiveParamsIF) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ConversationUnarchiveParamsIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Builds a new {@link ConversationUnarchiveParams ConversationUnarchiveParams}.
     * @return An immutable instance of ConversationUnarchiveParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationUnarchiveParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationUnarchiveParams(channelId);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      return "Cannot build ConversationUnarchiveParams, some of required attributes are not set " + attributes;
    }
  }
}
