package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.conversations.ConversationType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationsFilterIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationsFilter.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationsFilterIF"})
@Immutable
public final class ConversationsFilter
    implements ConversationsFilterIF {
  private final @Nullable Boolean shouldExcludeArchived;
  private final String types;
  private final Set<ConversationType> conversationTypes;

  private ConversationsFilter(
      @Nullable Boolean shouldExcludeArchived,
      Set<ConversationType> conversationTypes) {
    this.shouldExcludeArchived = shouldExcludeArchived;
    this.conversationTypes = conversationTypes;
    this.types = Objects.requireNonNull(ConversationsFilterIF.super.getTypes(), "types");
  }

  /**
   * @return The value of the {@code shouldExcludeArchived} attribute
   */
  @JsonProperty("exclude_archived")
  @Override
  public Optional<Boolean> shouldExcludeArchived() {
    return Optional.ofNullable(shouldExcludeArchived);
  }

  /**
   * @return The computed-at-construction value of the {@code types} attribute
   */
  @JsonProperty
  @Override
  public String getTypes() {
    return types;
  }

  /**
   * @return The value of the {@code conversationTypes} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public Set<ConversationType> getConversationTypes() {
    return conversationTypes;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationsFilterIF#shouldExcludeArchived() shouldExcludeArchived} attribute.
   * @param value The value for shouldExcludeArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationsFilter withShouldExcludeArchived(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.shouldExcludeArchived, newValue)) return this;
    return new ConversationsFilter(newValue, this.conversationTypes);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationsFilterIF#shouldExcludeArchived() shouldExcludeArchived} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for shouldExcludeArchived
   * @return A modified copy of {@code this} object
   */
  public final ConversationsFilter withShouldExcludeArchived(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.shouldExcludeArchived, value)) return this;
    return new ConversationsFilter(value, this.conversationTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationsFilterIF#getConversationTypes() conversationTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationsFilter withConversationTypes(ConversationType... elements) {
    Set<ConversationType> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ConversationsFilter(this.shouldExcludeArchived, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationsFilterIF#getConversationTypes() conversationTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of conversationTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationsFilter withConversationTypes(Iterable<ConversationType> elements) {
    if (this.conversationTypes == elements) return this;
    Set<ConversationType> newValue = createUnmodifiableEnumSet(elements);
    return new ConversationsFilter(this.shouldExcludeArchived, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationsFilter} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationsFilter
        && equalTo((ConversationsFilter) another);
  }

  private boolean equalTo(ConversationsFilter another) {
    return Objects.equals(shouldExcludeArchived, another.shouldExcludeArchived)
        && types.equals(another.types)
        && conversationTypes.equals(another.conversationTypes);
  }

  /**
   * Computes a hash code from attributes: {@code shouldExcludeArchived}, {@code types}, {@code conversationTypes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(shouldExcludeArchived);
    h = h * 17 + types.hashCode();
    h = h * 17 + conversationTypes.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationsFilter} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationsFilter{");
    if (shouldExcludeArchived != null) {
      builder.append("shouldExcludeArchived=").append(shouldExcludeArchived);
    }
    if (builder.length() > 20) builder.append(", ");
    builder.append("types=").append(types);
    builder.append(", ");
    builder.append("conversationTypes=").append(conversationTypes);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationsFilterIF {
    Optional<Boolean> shouldExcludeArchived = Optional.empty();
    Set<ConversationType> conversationTypes = Collections.emptySet();
    @JsonProperty("exclude_archived")
    public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived;
    }
    @JsonProperty
    @JsonIgnore
    public void setConversationTypes(Set<ConversationType> conversationTypes) {
      this.conversationTypes = conversationTypes;
    }
    @Override
    public Optional<Boolean> shouldExcludeArchived() { throw new UnsupportedOperationException(); }
    @Override
    public String getTypes() { throw new UnsupportedOperationException(); }
    @Override
    public Set<ConversationType> getConversationTypes() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationsFilter fromJson(Json json) {
    ConversationsFilter.Builder builder = ConversationsFilter.builder();
    if (json.shouldExcludeArchived != null) {
      builder.setShouldExcludeArchived(json.shouldExcludeArchived);
    }
    if (json.conversationTypes != null) {
      builder.addAllConversationTypes(json.conversationTypes);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationsFilterIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationsFilter instance
   */
  public static ConversationsFilter copyOf(ConversationsFilterIF instance) {
    if (instance instanceof ConversationsFilter) {
      return (ConversationsFilter) instance;
    }
    return ConversationsFilter.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationsFilter ConversationsFilter}.
   * @return A new ConversationsFilter builder
   */
  public static ConversationsFilter.Builder builder() {
    return new ConversationsFilter.Builder();
  }

  /**
   * Builds instances of type {@link ConversationsFilter ConversationsFilter}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean shouldExcludeArchived;
    private EnumSet<ConversationType> conversationTypes = EnumSet.noneOf(ConversationType.class);

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.conversations.BaseConversationsFilter} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BaseConversationsFilter instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.conversations.ConversationsFilterIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationsFilterIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof BaseConversationsFilter) {
        BaseConversationsFilter instance = (BaseConversationsFilter) object;
        Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
        if (shouldExcludeArchivedOptional.isPresent()) {
          setShouldExcludeArchived(shouldExcludeArchivedOptional);
        }
        addAllConversationTypes(instance.getConversationTypes());
      }
    }

    /**
     * Initializes the optional value {@link ConversationsFilterIF#shouldExcludeArchived() shouldExcludeArchived} to shouldExcludeArchived.
     * @param shouldExcludeArchived The value for shouldExcludeArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsFilterIF#shouldExcludeArchived() shouldExcludeArchived} to shouldExcludeArchived.
     * @param shouldExcludeArchived The value for shouldExcludeArchived
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
      this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ConversationsFilterIF#getConversationTypes() conversationTypes} set.
     * @param element A conversationTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConversationTypes(ConversationType element) {
      this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link ConversationsFilterIF#getConversationTypes() conversationTypes} set.
     * @param elements An array of conversationTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addConversationTypes(ConversationType... elements) {
      for (ConversationType element : elements) {
        this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ConversationsFilterIF#getConversationTypes() conversationTypes} set.
     * @param elements An iterable of conversationTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConversationTypes(Iterable<ConversationType> elements) {
      this.conversationTypes.clear();
      return addAllConversationTypes(elements);
    }

    /**
     * Adds elements to {@link ConversationsFilterIF#getConversationTypes() conversationTypes} set.
     * @param elements An iterable of conversationTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllConversationTypes(Iterable<ConversationType> elements) {
      for (ConversationType element : elements) {
        this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ConversationsFilter ConversationsFilter}.
     * @return An immutable instance of ConversationsFilter
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationsFilter build() throws InvalidImmutableStateException {
      return new ConversationsFilter(shouldExcludeArchived, createUnmodifiableEnumSet(conversationTypes));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }
}
