package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationsInfoParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationsInfoParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationsInfoParamsIF"})
@Immutable
public final class ConversationsInfoParams
    implements ConversationsInfoParamsIF {
  private final String conversationId;
  private final @Nullable Boolean includeLocale;

  private ConversationsInfoParams(String conversationId, @Nullable Boolean includeLocale) {
    this.conversationId = conversationId;
    this.includeLocale = includeLocale;
  }

  /**
   * @return The value of the {@code conversationId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getConversationId() {
    return conversationId;
  }

  /**
   * @return The value of the {@code includeLocale} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeLocale() {
    return Optional.ofNullable(includeLocale);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsInfoParamsIF#getConversationId() conversationId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param conversationId A new value for conversationId
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsInfoParams withConversationId(String conversationId) {
    if (this.conversationId.equals(conversationId)) return this;
    String newValue = Objects.requireNonNull(conversationId, "conversationId");
    return new ConversationsInfoParams(newValue, this.includeLocale);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationsInfoParamsIF#getIncludeLocale() includeLocale} attribute.
   * @param value The value for includeLocale, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationsInfoParams withIncludeLocale(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeLocale, newValue)) return this;
    return new ConversationsInfoParams(this.conversationId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationsInfoParamsIF#getIncludeLocale() includeLocale} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeLocale
   * @return A modified copy of {@code this} object
   */
  public final ConversationsInfoParams withIncludeLocale(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeLocale, value)) return this;
    return new ConversationsInfoParams(this.conversationId, value);
  }

  /**
   * This instance is equal to all instances of {@code ConversationsInfoParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationsInfoParams
        && equalTo((ConversationsInfoParams) another);
  }

  private boolean equalTo(ConversationsInfoParams another) {
    return conversationId.equals(another.conversationId)
        && Objects.equals(includeLocale, another.includeLocale);
  }

  /**
   * Computes a hash code from attributes: {@code conversationId}, {@code includeLocale}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + conversationId.hashCode();
    h = h * 17 + Objects.hashCode(includeLocale);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationsInfoParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationsInfoParams{");
    builder.append("conversationId=").append(conversationId);
    if (includeLocale != null) {
      builder.append(", ");
      builder.append("includeLocale=").append(includeLocale);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationsInfoParamsIF {
    @Nullable String conversationId;
    Optional<Boolean> includeLocale = Optional.empty();
    @JsonProperty("channel")
    public void setConversationId(String conversationId) {
      this.conversationId = conversationId;
    }
    @JsonProperty
    public void setIncludeLocale(Optional<Boolean> includeLocale) {
      this.includeLocale = includeLocale;
    }
    @Override
    public String getConversationId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeLocale() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationsInfoParams fromJson(Json json) {
    ConversationsInfoParams.Builder builder = ConversationsInfoParams.builder();
    if (json.conversationId != null) {
      builder.setConversationId(json.conversationId);
    }
    if (json.includeLocale != null) {
      builder.setIncludeLocale(json.includeLocale);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationsInfoParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationsInfoParams instance
   */
  public static ConversationsInfoParams copyOf(ConversationsInfoParamsIF instance) {
    if (instance instanceof ConversationsInfoParams) {
      return (ConversationsInfoParams) instance;
    }
    return ConversationsInfoParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationsInfoParams ConversationsInfoParams}.
   * @return A new ConversationsInfoParams builder
   */
  public static ConversationsInfoParams.Builder builder() {
    return new ConversationsInfoParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationsInfoParams ConversationsInfoParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONVERSATION_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String conversationId;
    private @Nullable Boolean includeLocale;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationsInfoParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationsInfoParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setConversationId(instance.getConversationId());
      Optional<Boolean> includeLocaleOptional = instance.getIncludeLocale();
      if (includeLocaleOptional.isPresent()) {
        setIncludeLocale(includeLocaleOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsInfoParamsIF#getConversationId() conversationId} attribute.
     * @param conversationId The value for conversationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConversationId(String conversationId) {
      this.conversationId = Objects.requireNonNull(conversationId, "conversationId");
      initBits &= ~INIT_BIT_CONVERSATION_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsInfoParamsIF#getIncludeLocale() includeLocale} to includeLocale.
     * @param includeLocale The value for includeLocale, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeLocale(@Nullable Boolean includeLocale) {
      this.includeLocale = includeLocale;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsInfoParamsIF#getIncludeLocale() includeLocale} to includeLocale.
     * @param includeLocale The value for includeLocale
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeLocale(Optional<Boolean> includeLocale) {
      this.includeLocale = includeLocale.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ConversationsInfoParams ConversationsInfoParams}.
     * @return An immutable instance of ConversationsInfoParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationsInfoParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationsInfoParams(conversationId, includeLocale);
    }

    private boolean conversationIdIsSet() {
      return (initBits & INIT_BIT_CONVERSATION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!conversationIdIsSet()) attributes.add("conversationId");
      return "Cannot build ConversationsInfoParams, some of required attributes are not set " + attributes;
    }
  }
}
