package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationsRepliesParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationsRepliesParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationsRepliesParamsIF"})
@Immutable
public final class ConversationsRepliesParams
    implements ConversationsRepliesParamsIF {
  private final String channel;
  private final String ts;

  private ConversationsRepliesParams(String channel, String ts) {
    this.channel = channel;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public String getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsRepliesParamsIF#getChannel() channel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsRepliesParams withChannel(String channel) {
    if (this.channel.equals(channel)) return this;
    String newValue = Objects.requireNonNull(channel, "channel");
    return new ConversationsRepliesParams(newValue, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsRepliesParamsIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsRepliesParams withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new ConversationsRepliesParams(this.channel, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ConversationsRepliesParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationsRepliesParams
        && equalTo((ConversationsRepliesParams) another);
  }

  private boolean equalTo(ConversationsRepliesParams another) {
    return channel.equals(another.channel)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code channel}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channel.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationsRepliesParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ConversationsRepliesParams{"
        + "channel=" + channel
        + ", ts=" + ts
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationsRepliesParamsIF {
    @Nullable String channel;
    @Nullable String ts;
    @JsonProperty
    public void setChannel(String channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationsRepliesParams fromJson(Json json) {
    ConversationsRepliesParams.Builder builder = ConversationsRepliesParams.builder();
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationsRepliesParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationsRepliesParams instance
   */
  public static ConversationsRepliesParams copyOf(ConversationsRepliesParamsIF instance) {
    if (instance instanceof ConversationsRepliesParams) {
      return (ConversationsRepliesParams) instance;
    }
    return ConversationsRepliesParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationsRepliesParams ConversationsRepliesParams}.
   * @return A new ConversationsRepliesParams builder
   */
  public static ConversationsRepliesParams.Builder builder() {
    return new ConversationsRepliesParams.Builder();
  }

  /**
   * Builds instances of type {@link ConversationsRepliesParams ConversationsRepliesParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL = 0x1L;
    private static final long INIT_BIT_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String channel;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationsRepliesParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationsRepliesParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setChannel(instance.getChannel());
      setTs(instance.getTs());
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsRepliesParamsIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(String channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsRepliesParamsIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link ConversationsRepliesParams ConversationsRepliesParams}.
     * @return An immutable instance of ConversationsRepliesParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationsRepliesParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationsRepliesParams(channel, ts);
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIsSet()) attributes.add("channel");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build ConversationsRepliesParams, some of required attributes are not set " + attributes;
    }
  }
}
