package com.hubspot.slack.client.methods.params.dialog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.SlackDialog;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link DialogOpenParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code DialogOpenParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "DialogOpenParamsIF"})
@Immutable
public final class DialogOpenParams
    implements DialogOpenParamsIF {
  private final String triggerId;
  private final SlackDialog dialog;

  private DialogOpenParams(String triggerId, SlackDialog dialog) {
    this.triggerId = triggerId;
    this.dialog = dialog;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @return The value of the {@code dialog} attribute
   */
  @JsonProperty
  @Override
  public SlackDialog getDialog() {
    return dialog;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogOpenParamsIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final DialogOpenParams withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new DialogOpenParams(newValue, this.dialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DialogOpenParamsIF#getDialog() dialog} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param dialog A new value for dialog
   * @return A modified copy of the {@code this} object
   */
  public final DialogOpenParams withDialog(SlackDialog dialog) {
    if (this.dialog == dialog) return this;
    SlackDialog newValue = Objects.requireNonNull(dialog, "dialog");
    return new DialogOpenParams(this.triggerId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code DialogOpenParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof DialogOpenParams
        && equalTo((DialogOpenParams) another);
  }

  private boolean equalTo(DialogOpenParams another) {
    return triggerId.equals(another.triggerId)
        && dialog.equals(another.dialog);
  }

  /**
   * Computes a hash code from attributes: {@code triggerId}, {@code dialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + dialog.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DialogOpenParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DialogOpenParams{"
        + "triggerId=" + triggerId
        + ", dialog=" + dialog
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DialogOpenParamsIF {
    @Nullable String triggerId;
    @Nullable SlackDialog dialog;
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setDialog(SlackDialog dialog) {
      this.dialog = dialog;
    }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackDialog getDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static DialogOpenParams fromJson(Json json) {
    DialogOpenParams.Builder builder = DialogOpenParams.builder();
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.dialog != null) {
      builder.setDialog(json.dialog);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DialogOpenParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DialogOpenParams instance
   */
  public static DialogOpenParams copyOf(DialogOpenParamsIF instance) {
    if (instance instanceof DialogOpenParams) {
      return (DialogOpenParams) instance;
    }
    return DialogOpenParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link DialogOpenParams DialogOpenParams}.
   * @return A new DialogOpenParams builder
   */
  public static DialogOpenParams.Builder builder() {
    return new DialogOpenParams.Builder();
  }

  /**
   * Builds instances of type {@link DialogOpenParams DialogOpenParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRIGGER_ID = 0x1L;
    private static final long INIT_BIT_DIALOG = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String triggerId;
    private @Nullable SlackDialog dialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DialogOpenParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DialogOpenParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTriggerId(instance.getTriggerId());
      setDialog(instance.getDialog());
      return this;
    }

    /**
     * Initializes the value for the {@link DialogOpenParamsIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link DialogOpenParamsIF#getDialog() dialog} attribute.
     * @param dialog The value for dialog 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDialog(SlackDialog dialog) {
      this.dialog = Objects.requireNonNull(dialog, "dialog");
      initBits &= ~INIT_BIT_DIALOG;
      return this;
    }

    /**
     * Builds a new {@link DialogOpenParams DialogOpenParams}.
     * @return An immutable instance of DialogOpenParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public DialogOpenParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new DialogOpenParams(triggerId, dialog);
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean dialogIsSet() {
      return (initBits & INIT_BIT_DIALOG) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!dialogIsSet()) attributes.add("dialog");
      return "Cannot build DialogOpenParams, some of required attributes are not set " + attributes;
    }
  }
}
