package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link FilesSharedPublicUrlParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code FilesSharedPublicUrlParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code FilesSharedPublicUrlParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FilesSharedPublicUrlParamsIF"})
@Immutable
public final class FilesSharedPublicUrlParams
    implements FilesSharedPublicUrlParamsIF {
  private final String fileId;

  private FilesSharedPublicUrlParams(String fileId) {
    this.fileId = Objects.requireNonNull(fileId, "fileId");
  }

  private FilesSharedPublicUrlParams(FilesSharedPublicUrlParams original, String fileId) {
    this.fileId = fileId;
  }

  /**
   * @return The value of the {@code fileId} attribute
   */
  @JsonProperty("file")
  @Override
  public String getFileId() {
    return fileId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FilesSharedPublicUrlParamsIF#getFileId() fileId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param fileId A new value for fileId
   * @return A modified copy of the {@code this} object
   */
  public final FilesSharedPublicUrlParams withFileId(String fileId) {
    if (this.fileId.equals(fileId)) return this;
    String newValue = Objects.requireNonNull(fileId, "fileId");
    return new FilesSharedPublicUrlParams(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code FilesSharedPublicUrlParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof FilesSharedPublicUrlParams
        && equalTo((FilesSharedPublicUrlParams) another);
  }

  private boolean equalTo(FilesSharedPublicUrlParams another) {
    return fileId.equals(another.fileId);
  }

  /**
   * Computes a hash code from attributes: {@code fileId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + fileId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FilesSharedPublicUrlParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FilesSharedPublicUrlParams{"
        + "fileId=" + fileId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements FilesSharedPublicUrlParamsIF {
    @Nullable String fileId;
    @JsonProperty("file")
    public void setFileId(String fileId) {
      this.fileId = fileId;
    }
    @Override
    public String getFileId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static FilesSharedPublicUrlParams fromJson(Json json) {
    FilesSharedPublicUrlParams.Builder builder = FilesSharedPublicUrlParams.builder();
    if (json.fileId != null) {
      builder.setFileId(json.fileId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code FilesSharedPublicUrlParams} instance.
   * @param fileId The value for the {@code fileId} attribute
   * @return An immutable FilesSharedPublicUrlParams instance
   */
  public static FilesSharedPublicUrlParams of(String fileId) {
    return new FilesSharedPublicUrlParams(fileId);
  }

  /**
   * Creates an immutable copy of a {@link FilesSharedPublicUrlParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FilesSharedPublicUrlParams instance
   */
  public static FilesSharedPublicUrlParams copyOf(FilesSharedPublicUrlParamsIF instance) {
    if (instance instanceof FilesSharedPublicUrlParams) {
      return (FilesSharedPublicUrlParams) instance;
    }
    return FilesSharedPublicUrlParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link FilesSharedPublicUrlParams FilesSharedPublicUrlParams}.
   * @return A new FilesSharedPublicUrlParams builder
   */
  public static FilesSharedPublicUrlParams.Builder builder() {
    return new FilesSharedPublicUrlParams.Builder();
  }

  /**
   * Builds instances of type {@link FilesSharedPublicUrlParams FilesSharedPublicUrlParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_FILE_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String fileId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FilesSharedPublicUrlParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FilesSharedPublicUrlParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setFileId(instance.getFileId());
      return this;
    }

    /**
     * Initializes the value for the {@link FilesSharedPublicUrlParamsIF#getFileId() fileId} attribute.
     * @param fileId The value for fileId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFileId(String fileId) {
      this.fileId = Objects.requireNonNull(fileId, "fileId");
      initBits &= ~INIT_BIT_FILE_ID;
      return this;
    }

    /**
     * Builds a new {@link FilesSharedPublicUrlParams FilesSharedPublicUrlParams}.
     * @return An immutable instance of FilesSharedPublicUrlParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public FilesSharedPublicUrlParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new FilesSharedPublicUrlParams(null, fileId);
    }

    private boolean fileIdIsSet() {
      return (initBits & INIT_BIT_FILE_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!fileIdIsSet()) attributes.add("fileId");
      return "Cannot build FilesSharedPublicUrlParams, some of required attributes are not set " + attributes;
    }
  }
}
