package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link FilesUploadParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code FilesUploadParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FilesUploadParamsIF"})
@Immutable
public final class FilesUploadParams
    implements FilesUploadParamsIF {
  private final List<String> channels;
  private final @Nullable String content;
  private final @Nullable String filename;
  private final @Nullable String initialComment;
  private final @Nullable String threadTs;
  private final @Nullable String title;

  private FilesUploadParams(
      List<String> channels,
      @Nullable String content,
      @Nullable String filename,
      @Nullable String initialComment,
      @Nullable String threadTs,
      @Nullable String title) {
    this.channels = channels;
    this.content = content;
    this.filename = filename;
    this.initialComment = initialComment;
    this.threadTs = threadTs;
    this.title = title;
  }

  /**
   * @return The value of the {@code channels} attribute
   */
  @JsonProperty
  @Override
  public List<String> getChannels() {
    return channels;
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getContent() {
    return Optional.ofNullable(content);
  }

  /**
   * @return The value of the {@code filename} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getFilename() {
    return Optional.ofNullable(filename);
  }

  /**
   * @return The value of the {@code initialComment} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getInitialComment() {
    return Optional.ofNullable(initialComment);
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getThreadTs() {
    return Optional.ofNullable(threadTs);
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getTitle() {
    return Optional.ofNullable(title);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FilesUploadParamsIF#getChannels() channels}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withChannels(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new FilesUploadParams(newValue, this.content, this.filename, this.initialComment, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FilesUploadParamsIF#getChannels() channels}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channels elements to set
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withChannels(Iterable<String> elements) {
    if (this.channels == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new FilesUploadParams(newValue, this.content, this.filename, this.initialComment, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FilesUploadParamsIF#getContent() content} attribute.
   * @param value The value for content, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withContent(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.content, newValue)) return this;
    return validate(new FilesUploadParams(this.channels, newValue, this.filename, this.initialComment, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FilesUploadParamsIF#getContent() content} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for content
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withContent(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.content, value)) return this;
    return validate(new FilesUploadParams(this.channels, value, this.filename, this.initialComment, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FilesUploadParamsIF#getFilename() filename} attribute.
   * @param value The value for filename, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withFilename(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.filename, newValue)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, newValue, this.initialComment, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FilesUploadParamsIF#getFilename() filename} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for filename
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withFilename(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.filename, value)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, value, this.initialComment, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FilesUploadParamsIF#getInitialComment() initialComment} attribute.
   * @param value The value for initialComment, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withInitialComment(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.initialComment, newValue)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, this.filename, newValue, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FilesUploadParamsIF#getInitialComment() initialComment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialComment
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withInitialComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.initialComment, value)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, this.filename, value, this.threadTs, this.title));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FilesUploadParamsIF#getThreadTs() threadTs} attribute.
   * @param value The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withThreadTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.threadTs, newValue)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, newValue, this.title));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FilesUploadParamsIF#getThreadTs() threadTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for threadTs
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withThreadTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.threadTs, value)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, value, this.title));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FilesUploadParamsIF#getTitle() title} attribute.
   * @param value The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withTitle(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.title, newValue)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, this.threadTs, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FilesUploadParamsIF#getTitle() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final FilesUploadParams withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, this.threadTs, value));
  }

  /**
   * This instance is equal to all instances of {@code FilesUploadParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof FilesUploadParams
        && equalTo((FilesUploadParams) another);
  }

  private boolean equalTo(FilesUploadParams another) {
    return channels.equals(another.channels)
        && Objects.equals(content, another.content)
        && Objects.equals(filename, another.filename)
        && Objects.equals(initialComment, another.initialComment)
        && Objects.equals(threadTs, another.threadTs)
        && Objects.equals(title, another.title);
  }

  /**
   * Computes a hash code from attributes: {@code channels}, {@code content}, {@code filename}, {@code initialComment}, {@code threadTs}, {@code title}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channels.hashCode();
    h = h * 17 + Objects.hashCode(content);
    h = h * 17 + Objects.hashCode(filename);
    h = h * 17 + Objects.hashCode(initialComment);
    h = h * 17 + Objects.hashCode(threadTs);
    h = h * 17 + Objects.hashCode(title);
    return h;
  }

  /**
   * Prints the immutable value {@code FilesUploadParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("FilesUploadParams{");
    builder.append("channels=").append(channels);
    if (content != null) {
      builder.append(", ");
      builder.append("content=").append(content);
    }
    if (filename != null) {
      builder.append(", ");
      builder.append("filename=").append(filename);
    }
    if (initialComment != null) {
      builder.append(", ");
      builder.append("initialComment=").append(initialComment);
    }
    if (threadTs != null) {
      builder.append(", ");
      builder.append("threadTs=").append(threadTs);
    }
    if (title != null) {
      builder.append(", ");
      builder.append("title=").append(title);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FilesUploadParamsIF {
    List<String> channels = Collections.emptyList();
    Optional<String> content = Optional.empty();
    Optional<String> filename = Optional.empty();
    Optional<String> initialComment = Optional.empty();
    Optional<String> threadTs = Optional.empty();
    Optional<String> title = Optional.empty();
    @JsonProperty
    public void setChannels(List<String> channels) {
      this.channels = channels;
    }
    @JsonProperty
    public void setContent(Optional<String> content) {
      this.content = content;
    }
    @JsonProperty
    public void setFilename(Optional<String> filename) {
      this.filename = filename;
    }
    @JsonProperty
    public void setInitialComment(Optional<String> initialComment) {
      this.initialComment = initialComment;
    }
    @JsonProperty
    public void setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs;
    }
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @Override
    public List<String> getChannels() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getContent() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getFilename() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInitialComment() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThreadTs() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getTitle() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static FilesUploadParams fromJson(Json json) {
    FilesUploadParams.Builder builder = FilesUploadParams.builder();
    if (json.channels != null) {
      builder.addAllChannels(json.channels);
    }
    if (json.content != null) {
      builder.setContent(json.content);
    }
    if (json.filename != null) {
      builder.setFilename(json.filename);
    }
    if (json.initialComment != null) {
      builder.setInitialComment(json.initialComment);
    }
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    return builder.build();
  }

  private static FilesUploadParams validate(FilesUploadParams instance) {
    instance.hasContent();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link FilesUploadParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FilesUploadParams instance
   */
  public static FilesUploadParams copyOf(FilesUploadParamsIF instance) {
    if (instance instanceof FilesUploadParams) {
      return (FilesUploadParams) instance;
    }
    return FilesUploadParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link FilesUploadParams FilesUploadParams}.
   * @return A new FilesUploadParams builder
   */
  public static FilesUploadParams.Builder builder() {
    return new FilesUploadParams.Builder();
  }

  /**
   * Builds instances of type {@link FilesUploadParams FilesUploadParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<String> channels = new ArrayList<String>();
    private @Nullable String content;
    private @Nullable String filename;
    private @Nullable String initialComment;
    private @Nullable String threadTs;
    private @Nullable String title;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FilesUploadParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FilesUploadParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      addAllChannels(instance.getChannels());
      Optional<String> contentOptional = instance.getContent();
      if (contentOptional.isPresent()) {
        setContent(contentOptional);
      }
      Optional<String> filenameOptional = instance.getFilename();
      if (filenameOptional.isPresent()) {
        setFilename(filenameOptional);
      }
      Optional<String> initialCommentOptional = instance.getInitialComment();
      if (initialCommentOptional.isPresent()) {
        setInitialComment(initialCommentOptional);
      }
      Optional<String> threadTsOptional = instance.getThreadTs();
      if (threadTsOptional.isPresent()) {
        setThreadTs(threadTsOptional);
      }
      Optional<String> titleOptional = instance.getTitle();
      if (titleOptional.isPresent()) {
        setTitle(titleOptional);
      }
      return this;
    }

    /**
     * Adds one element to {@link FilesUploadParamsIF#getChannels() channels} list.
     * @param element A channels element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannels(String element) {
      this.channels.add(Objects.requireNonNull(element, "channels element"));
      return this;
    }

    /**
     * Adds elements to {@link FilesUploadParamsIF#getChannels() channels} list.
     * @param elements An array of channels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannels(String... elements) {
      for (String element : elements) {
        this.channels.add(Objects.requireNonNull(element, "channels element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FilesUploadParamsIF#getChannels() channels} list.
     * @param elements An iterable of channels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannels(Iterable<String> elements) {
      this.channels.clear();
      return addAllChannels(elements);
    }

    /**
     * Adds elements to {@link FilesUploadParamsIF#getChannels() channels} list.
     * @param elements An iterable of channels elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChannels(Iterable<String> elements) {
      for (String element : elements) {
        this.channels.add(Objects.requireNonNull(element, "channels element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getContent() content} to content.
     * @param content The value for content, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setContent(@Nullable String content) {
      this.content = content;
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getContent() content} to content.
     * @param content The value for content
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setContent(Optional<String> content) {
      this.content = content.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getFilename() filename} to filename.
     * @param filename The value for filename, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setFilename(@Nullable String filename) {
      this.filename = filename;
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getFilename() filename} to filename.
     * @param filename The value for filename
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFilename(Optional<String> filename) {
      this.filename = filename.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getInitialComment() initialComment} to initialComment.
     * @param initialComment The value for initialComment, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialComment(@Nullable String initialComment) {
      this.initialComment = initialComment;
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getInitialComment() initialComment} to initialComment.
     * @param initialComment The value for initialComment
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialComment(Optional<String> initialComment) {
      this.initialComment = initialComment.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThreadTs(@Nullable String threadTs) {
      this.threadTs = threadTs;
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getTitle() title} to title.
     * @param title The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTitle(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link FilesUploadParamsIF#getTitle() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link FilesUploadParams FilesUploadParams}.
     * @return An immutable instance of FilesUploadParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public FilesUploadParams build() throws InvalidImmutableStateException {
      return FilesUploadParams.validate(new FilesUploadParams(createUnmodifiableList(true, channels), content, filename, initialComment, threadTs, title));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
