package com.hubspot.slack.client.methods.params.im;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ImOpenParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImOpenParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImOpenParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ImOpenParamsIF"})
@Immutable
public final class ImOpenParams implements ImOpenParamsIF {
  private final String userId;
  private final boolean includeLocale;
  private final boolean returnIm;

  private ImOpenParams(String userId) {
    this.userId = Objects.requireNonNull(userId, "userId");
    this.includeLocale = initShim.getIncludeLocale();
    this.returnIm = initShim.getReturnIm();
    this.initShim = null;
  }

  private ImOpenParams(ImOpenParams.Builder builder) {
    this.userId = builder.userId;
    if (builder.includeLocaleIsSet()) {
      initShim.setIncludeLocale(builder.includeLocale);
    }
    if (builder.returnImIsSet()) {
      initShim.setReturnIm(builder.returnIm);
    }
    this.includeLocale = initShim.getIncludeLocale();
    this.returnIm = initShim.getReturnIm();
    this.initShim = null;
  }

  private ImOpenParams(String userId, boolean includeLocale, boolean returnIm) {
    this.userId = userId;
    this.includeLocale = includeLocale;
    this.returnIm = returnIm;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private boolean includeLocale;
    private int includeLocaleStage;

    boolean getIncludeLocale() {
      if (includeLocaleStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (includeLocaleStage == STAGE_UNINITIALIZED) {
        includeLocaleStage = STAGE_INITIALIZING;
        this.includeLocale = getIncludeLocaleInitialize();
        includeLocaleStage = STAGE_INITIALIZED;
      }
      return this.includeLocale;
    }

    void setIncludeLocale(boolean includeLocale) {
      this.includeLocale = includeLocale;
      includeLocaleStage = STAGE_INITIALIZED;
    }
    private boolean returnIm;
    private int returnImStage;

    boolean getReturnIm() {
      if (returnImStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (returnImStage == STAGE_UNINITIALIZED) {
        returnImStage = STAGE_INITIALIZING;
        this.returnIm = getReturnImInitialize();
        returnImStage = STAGE_INITIALIZED;
      }
      return this.returnIm;
    }

    void setReturnIm(boolean returnIm) {
      this.returnIm = returnIm;
      returnImStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (includeLocaleStage == STAGE_INITIALIZING) attributes.add("includeLocale");
      if (returnImStage == STAGE_INITIALIZING) attributes.add("returnIm");
      return "Cannot build ImOpenParams, attribute initializers form cycle" + attributes;
    }
  }

  private boolean getIncludeLocaleInitialize() {
    return ImOpenParamsIF.super.getIncludeLocale();
  }

  private boolean getReturnImInitialize() {
    return ImOpenParamsIF.super.getReturnIm();
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code includeLocale} attribute
   */
  @JsonProperty
  @Override
  public boolean getIncludeLocale() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getIncludeLocale()
        : this.includeLocale;
  }

  /**
   * @return The value of the {@code returnIm} attribute
   */
  @JsonProperty
  @Override
  public boolean getReturnIm() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getReturnIm()
        : this.returnIm;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImOpenParamsIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final ImOpenParams withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new ImOpenParams(newValue, this.includeLocale, this.returnIm);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImOpenParamsIF#getIncludeLocale() includeLocale} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param includeLocale A new value for includeLocale
   * @return A modified copy of the {@code this} object
   */
  public final ImOpenParams withIncludeLocale(boolean includeLocale) {
    if (this.includeLocale == includeLocale) return this;
    return new ImOpenParams(this.userId, includeLocale, this.returnIm);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImOpenParamsIF#getReturnIm() returnIm} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param returnIm A new value for returnIm
   * @return A modified copy of the {@code this} object
   */
  public final ImOpenParams withReturnIm(boolean returnIm) {
    if (this.returnIm == returnIm) return this;
    return new ImOpenParams(this.userId, this.includeLocale, returnIm);
  }

  /**
   * This instance is equal to all instances of {@code ImOpenParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImOpenParams
        && equalTo((ImOpenParams) another);
  }

  private boolean equalTo(ImOpenParams another) {
    return userId.equals(another.userId)
        && includeLocale == another.includeLocale
        && returnIm == another.returnIm;
  }

  /**
   * Computes a hash code from attributes: {@code userId}, {@code includeLocale}, {@code returnIm}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + userId.hashCode();
    h = h * 17 + Boolean.hashCode(includeLocale);
    h = h * 17 + Boolean.hashCode(returnIm);
    return h;
  }

  /**
   * Prints the immutable value {@code ImOpenParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImOpenParams{"
        + "userId=" + userId
        + ", includeLocale=" + includeLocale
        + ", returnIm=" + returnIm
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ImOpenParamsIF {
    @Nullable String userId;
    boolean includeLocale;
    boolean includeLocaleIsSet;
    boolean returnIm;
    boolean returnImIsSet;
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setIncludeLocale(boolean includeLocale) {
      this.includeLocale = includeLocale;
      this.includeLocaleIsSet = true;
    }
    @JsonProperty
    public void setReturnIm(boolean returnIm) {
      this.returnIm = returnIm;
      this.returnImIsSet = true;
    }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getIncludeLocale() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getReturnIm() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImOpenParams fromJson(Json json) {
    ImOpenParams.Builder builder = ImOpenParams.builder();
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.includeLocaleIsSet) {
      builder.setIncludeLocale(json.includeLocale);
    }
    if (json.returnImIsSet) {
      builder.setReturnIm(json.returnIm);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ImOpenParams} instance.
   * @param userId The value for the {@code userId} attribute
   * @return An immutable ImOpenParams instance
   */
  public static ImOpenParams of(String userId) {
    return new ImOpenParams(userId);
  }

  /**
   * Creates an immutable copy of a {@link ImOpenParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImOpenParams instance
   */
  public static ImOpenParams copyOf(ImOpenParamsIF instance) {
    if (instance instanceof ImOpenParams) {
      return (ImOpenParams) instance;
    }
    return ImOpenParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImOpenParams ImOpenParams}.
   * @return A new ImOpenParams builder
   */
  public static ImOpenParams.Builder builder() {
    return new ImOpenParams.Builder();
  }

  /**
   * Builds instances of type {@link ImOpenParams ImOpenParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private static final long OPT_BIT_INCLUDE_LOCALE = 0x1L;
    private static final long OPT_BIT_RETURN_IM = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String userId;
    private boolean includeLocale;
    private boolean returnIm;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.im.ImOpenParamsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImOpenParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ImOpenParamsIF) {
        ImOpenParamsIF instance = (ImOpenParamsIF) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
        setIncludeLocale(instance.getIncludeLocale());
        setReturnIm(instance.getReturnIm());
      }
      if (object instanceof HasUser) {
        HasUser instance = (HasUser) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ImOpenParamsIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ImOpenParamsIF#getIncludeLocale() includeLocale} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ImOpenParamsIF#getIncludeLocale() includeLocale}.</em>
     * @param includeLocale The value for includeLocale 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeLocale(boolean includeLocale) {
      this.includeLocale = includeLocale;
      optBits |= OPT_BIT_INCLUDE_LOCALE;
      return this;
    }

    /**
     * Initializes the value for the {@link ImOpenParamsIF#getReturnIm() returnIm} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ImOpenParamsIF#getReturnIm() returnIm}.</em>
     * @param returnIm The value for returnIm 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReturnIm(boolean returnIm) {
      this.returnIm = returnIm;
      optBits |= OPT_BIT_RETURN_IM;
      return this;
    }

    /**
     * Builds a new {@link ImOpenParams ImOpenParams}.
     * @return An immutable instance of ImOpenParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ImOpenParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ImOpenParams(this);
    }

    private boolean includeLocaleIsSet() {
      return (optBits & OPT_BIT_INCLUDE_LOCALE) != 0;
    }

    private boolean returnImIsSet() {
      return (optBits & OPT_BIT_RETURN_IM) != 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!userIdIsSet()) attributes.add("userId");
      return "Cannot build ImOpenParams, some of required attributes are not set " + attributes;
    }
  }
}
