package com.hubspot.slack.client.methods.params.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.ResultSort;
import com.hubspot.slack.client.methods.ResultSortOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SearchMessagesParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SearchMessagesParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SearchMessagesParamsIF"})
@Immutable
public final class SearchMessagesParams
    implements SearchMessagesParamsIF {
  private final String query;
  private final boolean shouldHighlight;
  private final int count;
  private final int page;
  private final ResultSort sort;
  private final ResultSortOrder sortOrder;

  private SearchMessagesParams(SearchMessagesParams.Builder builder) {
    this.query = builder.query;
    if (builder.shouldHighlightIsSet()) {
      initShim.setShouldHighlight(builder.shouldHighlight);
    }
    if (builder.countIsSet()) {
      initShim.setCount(builder.count);
    }
    if (builder.pageIsSet()) {
      initShim.setPage(builder.page);
    }
    if (builder.sort != null) {
      initShim.setSort(builder.sort);
    }
    if (builder.sortOrder != null) {
      initShim.setSortOrder(builder.sortOrder);
    }
    this.shouldHighlight = initShim.shouldHighlight();
    this.count = initShim.getCount();
    this.page = initShim.getPage();
    this.sort = initShim.getSort();
    this.sortOrder = initShim.getSortOrder();
    this.initShim = null;
  }

  private SearchMessagesParams(
      String query,
      boolean shouldHighlight,
      int count,
      int page,
      ResultSort sort,
      ResultSortOrder sortOrder) {
    this.query = query;
    this.shouldHighlight = shouldHighlight;
    this.count = count;
    this.page = page;
    this.sort = sort;
    this.sortOrder = sortOrder;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private boolean shouldHighlight;
    private int shouldHighlightStage;

    boolean shouldHighlight() {
      if (shouldHighlightStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (shouldHighlightStage == STAGE_UNINITIALIZED) {
        shouldHighlightStage = STAGE_INITIALIZING;
        this.shouldHighlight = shouldHighlightInitialize();
        shouldHighlightStage = STAGE_INITIALIZED;
      }
      return this.shouldHighlight;
    }

    void setShouldHighlight(boolean shouldHighlight) {
      this.shouldHighlight = shouldHighlight;
      shouldHighlightStage = STAGE_INITIALIZED;
    }
    private int count;
    private int countStage;

    int getCount() {
      if (countStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (countStage == STAGE_UNINITIALIZED) {
        countStage = STAGE_INITIALIZING;
        this.count = getCountInitialize();
        countStage = STAGE_INITIALIZED;
      }
      return this.count;
    }

    void setCount(int count) {
      this.count = count;
      countStage = STAGE_INITIALIZED;
    }
    private int page;
    private int pageStage;

    int getPage() {
      if (pageStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (pageStage == STAGE_UNINITIALIZED) {
        pageStage = STAGE_INITIALIZING;
        this.page = getPageInitialize();
        pageStage = STAGE_INITIALIZED;
      }
      return this.page;
    }

    void setPage(int page) {
      this.page = page;
      pageStage = STAGE_INITIALIZED;
    }
    private ResultSort sort;
    private int sortStage;

    ResultSort getSort() {
      if (sortStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (sortStage == STAGE_UNINITIALIZED) {
        sortStage = STAGE_INITIALIZING;
        this.sort = Objects.requireNonNull(getSortInitialize(), "sort");
        sortStage = STAGE_INITIALIZED;
      }
      return this.sort;
    }

    void setSort(ResultSort sort) {
      this.sort = sort;
      sortStage = STAGE_INITIALIZED;
    }
    private ResultSortOrder sortOrder;
    private int sortOrderStage;

    ResultSortOrder getSortOrder() {
      if (sortOrderStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (sortOrderStage == STAGE_UNINITIALIZED) {
        sortOrderStage = STAGE_INITIALIZING;
        this.sortOrder = Objects.requireNonNull(getSortOrderInitialize(), "sortOrder");
        sortOrderStage = STAGE_INITIALIZED;
      }
      return this.sortOrder;
    }

    void setSortOrder(ResultSortOrder sortOrder) {
      this.sortOrder = sortOrder;
      sortOrderStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (shouldHighlightStage == STAGE_INITIALIZING) attributes.add("shouldHighlight");
      if (countStage == STAGE_INITIALIZING) attributes.add("count");
      if (pageStage == STAGE_INITIALIZING) attributes.add("page");
      if (sortStage == STAGE_INITIALIZING) attributes.add("sort");
      if (sortOrderStage == STAGE_INITIALIZING) attributes.add("sortOrder");
      return "Cannot build SearchMessagesParams, attribute initializers form cycle" + attributes;
    }
  }

  private boolean shouldHighlightInitialize() {
    return SearchMessagesParamsIF.super.shouldHighlight();
  }

  private int getCountInitialize() {
    return SearchMessagesParamsIF.super.getCount();
  }

  private int getPageInitialize() {
    return SearchMessagesParamsIF.super.getPage();
  }

  private ResultSort getSortInitialize() {
    return SearchMessagesParamsIF.super.getSort();
  }

  private ResultSortOrder getSortOrderInitialize() {
    return SearchMessagesParamsIF.super.getSortOrder();
  }

  /**
   * @return The value of the {@code query} attribute
   */
  @JsonProperty
  @Override
  public String getQuery() {
    return query;
  }

  /**
   * @return The value of the {@code shouldHighlight} attribute
   */
  @JsonProperty
  @Override
  public boolean shouldHighlight() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.shouldHighlight()
        : this.shouldHighlight;
  }

  /**
   * @return The value of the {@code count} attribute
   */
  @JsonProperty
  @Override
  public int getCount() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCount()
        : this.count;
  }

  /**
   * @return The value of the {@code page} attribute
   */
  @JsonProperty
  @Override
  public int getPage() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getPage()
        : this.page;
  }

  /**
   * @return The value of the {@code sort} attribute
   */
  @JsonProperty
  @Override
  public ResultSort getSort() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSort()
        : this.sort;
  }

  /**
   * @return The value of the {@code sortOrder} attribute
   */
  @JsonProperty("sort_dir")
  @Override
  public ResultSortOrder getSortOrder() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSortOrder()
        : this.sortOrder;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessagesParamsIF#getQuery() query} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param query A new value for query
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessagesParams withQuery(String query) {
    if (this.query.equals(query)) return this;
    String newValue = Objects.requireNonNull(query, "query");
    return new SearchMessagesParams(newValue, this.shouldHighlight, this.count, this.page, this.sort, this.sortOrder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessagesParamsIF#shouldHighlight() shouldHighlight} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param shouldHighlight A new value for shouldHighlight
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessagesParams withShouldHighlight(boolean shouldHighlight) {
    if (this.shouldHighlight == shouldHighlight) return this;
    return new SearchMessagesParams(this.query, shouldHighlight, this.count, this.page, this.sort, this.sortOrder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessagesParamsIF#getCount() count} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param count A new value for count
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessagesParams withCount(int count) {
    if (this.count == count) return this;
    return new SearchMessagesParams(this.query, this.shouldHighlight, count, this.page, this.sort, this.sortOrder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessagesParamsIF#getPage() page} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param page A new value for page
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessagesParams withPage(int page) {
    if (this.page == page) return this;
    return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, page, this.sort, this.sortOrder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessagesParamsIF#getSort() sort} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param sort A new value for sort
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessagesParams withSort(ResultSort sort) {
    if (this.sort == sort) return this;
    ResultSort newValue = Objects.requireNonNull(sort, "sort");
    return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, this.page, newValue, this.sortOrder);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SearchMessagesParamsIF#getSortOrder() sortOrder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param sortOrder A new value for sortOrder
   * @return A modified copy of the {@code this} object
   */
  public final SearchMessagesParams withSortOrder(ResultSortOrder sortOrder) {
    if (this.sortOrder == sortOrder) return this;
    ResultSortOrder newValue = Objects.requireNonNull(sortOrder, "sortOrder");
    return new SearchMessagesParams(this.query, this.shouldHighlight, this.count, this.page, this.sort, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SearchMessagesParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SearchMessagesParams
        && equalTo((SearchMessagesParams) another);
  }

  private boolean equalTo(SearchMessagesParams another) {
    return query.equals(another.query)
        && shouldHighlight == another.shouldHighlight
        && count == another.count
        && page == another.page
        && sort.equals(another.sort)
        && sortOrder.equals(another.sortOrder);
  }

  /**
   * Computes a hash code from attributes: {@code query}, {@code shouldHighlight}, {@code count}, {@code page}, {@code sort}, {@code sortOrder}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + query.hashCode();
    h = h * 17 + Boolean.hashCode(shouldHighlight);
    h = h * 17 + count;
    h = h * 17 + page;
    h = h * 17 + sort.hashCode();
    h = h * 17 + sortOrder.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SearchMessagesParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SearchMessagesParams{"
        + "query=" + query
        + ", shouldHighlight=" + shouldHighlight
        + ", count=" + count
        + ", page=" + page
        + ", sort=" + sort
        + ", sortOrder=" + sortOrder
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SearchMessagesParamsIF {
    @Nullable String query;
    boolean shouldHighlight;
    boolean shouldHighlightIsSet;
    int count;
    boolean countIsSet;
    int page;
    boolean pageIsSet;
    @Nullable ResultSort sort;
    @Nullable ResultSortOrder sortOrder;
    @JsonProperty
    public void setQuery(String query) {
      this.query = query;
    }
    @JsonProperty
    public void setShouldHighlight(boolean shouldHighlight) {
      this.shouldHighlight = shouldHighlight;
      this.shouldHighlightIsSet = true;
    }
    @JsonProperty
    public void setCount(int count) {
      this.count = count;
      this.countIsSet = true;
    }
    @JsonProperty
    public void setPage(int page) {
      this.page = page;
      this.pageIsSet = true;
    }
    @JsonProperty
    public void setSort(ResultSort sort) {
      this.sort = sort;
    }
    @JsonProperty("sort_dir")
    public void setSortOrder(ResultSortOrder sortOrder) {
      this.sortOrder = sortOrder;
    }
    @Override
    public String getQuery() { throw new UnsupportedOperationException(); }
    @Override
    public boolean shouldHighlight() { throw new UnsupportedOperationException(); }
    @Override
    public int getCount() { throw new UnsupportedOperationException(); }
    @Override
    public int getPage() { throw new UnsupportedOperationException(); }
    @Override
    public ResultSort getSort() { throw new UnsupportedOperationException(); }
    @Override
    public ResultSortOrder getSortOrder() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SearchMessagesParams fromJson(Json json) {
    SearchMessagesParams.Builder builder = SearchMessagesParams.builder();
    if (json.query != null) {
      builder.setQuery(json.query);
    }
    if (json.shouldHighlightIsSet) {
      builder.setShouldHighlight(json.shouldHighlight);
    }
    if (json.countIsSet) {
      builder.setCount(json.count);
    }
    if (json.pageIsSet) {
      builder.setPage(json.page);
    }
    if (json.sort != null) {
      builder.setSort(json.sort);
    }
    if (json.sortOrder != null) {
      builder.setSortOrder(json.sortOrder);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SearchMessagesParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SearchMessagesParams instance
   */
  public static SearchMessagesParams copyOf(SearchMessagesParamsIF instance) {
    if (instance instanceof SearchMessagesParams) {
      return (SearchMessagesParams) instance;
    }
    return SearchMessagesParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SearchMessagesParams SearchMessagesParams}.
   * @return A new SearchMessagesParams builder
   */
  public static SearchMessagesParams.Builder builder() {
    return new SearchMessagesParams.Builder();
  }

  /**
   * Builds instances of type {@link SearchMessagesParams SearchMessagesParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_QUERY = 0x1L;
    private static final long OPT_BIT_SHOULD_HIGHLIGHT = 0x1L;
    private static final long OPT_BIT_COUNT = 0x2L;
    private static final long OPT_BIT_PAGE = 0x4L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String query;
    private boolean shouldHighlight;
    private int count;
    private int page;
    private @Nullable ResultSort sort;
    private @Nullable ResultSortOrder sortOrder;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SearchMessagesParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SearchMessagesParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setQuery(instance.getQuery());
      setShouldHighlight(instance.shouldHighlight());
      setCount(instance.getCount());
      setPage(instance.getPage());
      setSort(instance.getSort());
      setSortOrder(instance.getSortOrder());
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessagesParamsIF#getQuery() query} attribute.
     * @param query The value for query 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setQuery(String query) {
      this.query = Objects.requireNonNull(query, "query");
      initBits &= ~INIT_BIT_QUERY;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessagesParamsIF#shouldHighlight() shouldHighlight} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SearchMessagesParamsIF#shouldHighlight() shouldHighlight}.</em>
     * @param shouldHighlight The value for shouldHighlight 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setShouldHighlight(boolean shouldHighlight) {
      this.shouldHighlight = shouldHighlight;
      optBits |= OPT_BIT_SHOULD_HIGHLIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessagesParamsIF#getCount() count} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SearchMessagesParamsIF#getCount() count}.</em>
     * @param count The value for count 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCount(int count) {
      this.count = count;
      optBits |= OPT_BIT_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessagesParamsIF#getPage() page} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SearchMessagesParamsIF#getPage() page}.</em>
     * @param page The value for page 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPage(int page) {
      this.page = page;
      optBits |= OPT_BIT_PAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessagesParamsIF#getSort() sort} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SearchMessagesParamsIF#getSort() sort}.</em>
     * @param sort The value for sort 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSort(ResultSort sort) {
      this.sort = Objects.requireNonNull(sort, "sort");
      return this;
    }

    /**
     * Initializes the value for the {@link SearchMessagesParamsIF#getSortOrder() sortOrder} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SearchMessagesParamsIF#getSortOrder() sortOrder}.</em>
     * @param sortOrder The value for sortOrder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSortOrder(ResultSortOrder sortOrder) {
      this.sortOrder = Objects.requireNonNull(sortOrder, "sortOrder");
      return this;
    }

    /**
     * Builds a new {@link SearchMessagesParams SearchMessagesParams}.
     * @return An immutable instance of SearchMessagesParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SearchMessagesParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SearchMessagesParams(this);
    }

    private boolean shouldHighlightIsSet() {
      return (optBits & OPT_BIT_SHOULD_HIGHLIGHT) != 0;
    }

    private boolean countIsSet() {
      return (optBits & OPT_BIT_COUNT) != 0;
    }

    private boolean pageIsSet() {
      return (optBits & OPT_BIT_PAGE) != 0;
    }

    private boolean queryIsSet() {
      return (initBits & INIT_BIT_QUERY) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!queryIsSet()) attributes.add("query");
      return "Cannot build SearchMessagesParams, some of required attributes are not set " + attributes;
    }
  }
}
