package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUsergroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractUsergroupDisableParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsergroupDisableParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code UsergroupDisableParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractUsergroupDisableParams"})
@Immutable
public final class UsergroupDisableParams
    extends AbstractUsergroupDisableParams {
  private final String usergroupId;
  private final @Nullable Boolean includeCount;

  private UsergroupDisableParams(String usergroupId) {
    this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
    this.includeCount = null;
  }

  private UsergroupDisableParams(String usergroupId, @Nullable Boolean includeCount) {
    this.usergroupId = usergroupId;
    this.includeCount = includeCount;
  }

  /**
   * @return The value of the {@code usergroupId} attribute
   */
  @JsonProperty("usergroup")
  @Override
  public String getUsergroupId() {
    return usergroupId;
  }

  /**
   * @return The value of the {@code includeCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeCount() {
    return Optional.ofNullable(includeCount);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractUsergroupDisableParams#getUsergroupId() usergroupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param usergroupId A new value for usergroupId
   * @return A modified copy of the {@code this} object
   */
  public final UsergroupDisableParams withUsergroupId(String usergroupId) {
    if (this.usergroupId.equals(usergroupId)) return this;
    String newValue = Objects.requireNonNull(usergroupId, "usergroupId");
    return new UsergroupDisableParams(newValue, this.includeCount);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractUsergroupDisableParams#getIncludeCount() includeCount} attribute.
   * @param value The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupDisableParams withIncludeCount(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeCount, newValue)) return this;
    return new UsergroupDisableParams(this.usergroupId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractUsergroupDisableParams#getIncludeCount() includeCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeCount
   * @return A modified copy of {@code this} object
   */
  public final UsergroupDisableParams withIncludeCount(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeCount, value)) return this;
    return new UsergroupDisableParams(this.usergroupId, value);
  }

  /**
   * This instance is equal to all instances of {@code UsergroupDisableParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsergroupDisableParams
        && equalTo((UsergroupDisableParams) another);
  }

  private boolean equalTo(UsergroupDisableParams another) {
    return usergroupId.equals(another.usergroupId)
        && Objects.equals(includeCount, another.includeCount);
  }

  /**
   * Computes a hash code from attributes: {@code usergroupId}, {@code includeCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + usergroupId.hashCode();
    h = h * 17 + Objects.hashCode(includeCount);
    return h;
  }

  /**
   * Prints the immutable value {@code UsergroupDisableParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsergroupDisableParams{");
    builder.append("usergroupId=").append(usergroupId);
    if (includeCount != null) {
      builder.append(", ");
      builder.append("includeCount=").append(includeCount);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractUsergroupDisableParams {
    @Nullable String usergroupId;
    Optional<Boolean> includeCount = Optional.empty();
    @JsonProperty("usergroup")
    public void setUsergroupId(String usergroupId) {
      this.usergroupId = usergroupId;
    }
    @JsonProperty
    public void setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount;
    }
    @Override
    public String getUsergroupId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeCount() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsergroupDisableParams fromJson(Json json) {
    UsergroupDisableParams.Builder builder = UsergroupDisableParams.builder();
    if (json.usergroupId != null) {
      builder.setUsergroupId(json.usergroupId);
    }
    if (json.includeCount != null) {
      builder.setIncludeCount(json.includeCount);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code UsergroupDisableParams} instance.
   * @param usergroupId The value for the {@code usergroupId} attribute
   * @return An immutable UsergroupDisableParams instance
   */
  public static UsergroupDisableParams of(String usergroupId) {
    return new UsergroupDisableParams(usergroupId);
  }

  /**
   * Creates an immutable copy of a {@link AbstractUsergroupDisableParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsergroupDisableParams instance
   */
  public static UsergroupDisableParams copyOf(AbstractUsergroupDisableParams instance) {
    if (instance instanceof UsergroupDisableParams) {
      return (UsergroupDisableParams) instance;
    }
    return UsergroupDisableParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsergroupDisableParams UsergroupDisableParams}.
   * @return A new UsergroupDisableParams builder
   */
  public static UsergroupDisableParams.Builder builder() {
    return new UsergroupDisableParams.Builder();
  }

  /**
   * Builds instances of type {@link UsergroupDisableParams UsergroupDisableParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USERGROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String usergroupId;
    private @Nullable Boolean includeCount;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.params.usergroups.AbstractUsergroupDisableParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUsergroupDisableParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUsergroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUsergroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractUsergroupDisableParams) {
        AbstractUsergroupDisableParams instance = (AbstractUsergroupDisableParams) object;
        if ((bits & 0x1L) == 0) {
          setUsergroupId(instance.getUsergroupId());
          bits |= 0x1L;
        }
        Optional<Boolean> includeCountOptional = instance.getIncludeCount();
        if (includeCountOptional.isPresent()) {
          setIncludeCount(includeCountOptional);
        }
      }
      if (object instanceof HasUsergroup) {
        HasUsergroup instance = (HasUsergroup) object;
        if ((bits & 0x1L) == 0) {
          setUsergroupId(instance.getUsergroupId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractUsergroupDisableParams#getUsergroupId() usergroupId} attribute.
     * @param usergroupId The value for usergroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsergroupId(String usergroupId) {
      this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
      initBits &= ~INIT_BIT_USERGROUP_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractUsergroupDisableParams#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeCount(@Nullable Boolean includeCount) {
      this.includeCount = includeCount;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractUsergroupDisableParams#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UsergroupDisableParams UsergroupDisableParams}.
     * @return An immutable instance of UsergroupDisableParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsergroupDisableParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsergroupDisableParams(usergroupId, includeCount);
    }

    private boolean usergroupIdIsSet() {
      return (initBits & INIT_BIT_USERGROUP_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!usergroupIdIsSet()) attributes.add("usergroupId");
      return "Cannot build UsergroupDisableParams, some of required attributes are not set " + attributes;
    }
  }
}
