package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsergroupListParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsergroupListParams.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsergroupListParamsIF"})
@Immutable
public final class UsergroupListParams
    implements UsergroupListParamsIF {
  private final @Nullable Boolean includeCount;
  private final @Nullable Boolean includeDisabled;
  private final @Nullable Boolean includeUsers;

  private UsergroupListParams(
      @Nullable Boolean includeCount,
      @Nullable Boolean includeDisabled,
      @Nullable Boolean includeUsers) {
    this.includeCount = includeCount;
    this.includeDisabled = includeDisabled;
    this.includeUsers = includeUsers;
  }

  /**
   * @return The value of the {@code includeCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeCount() {
    return Optional.ofNullable(includeCount);
  }

  /**
   * @return The value of the {@code includeDisabled} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeDisabled() {
    return Optional.ofNullable(includeDisabled);
  }

  /**
   * @return The value of the {@code includeUsers} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIncludeUsers() {
    return Optional.ofNullable(includeUsers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupListParamsIF#getIncludeCount() includeCount} attribute.
   * @param value The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListParams withIncludeCount(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeCount, newValue)) return this;
    return new UsergroupListParams(newValue, this.includeDisabled, this.includeUsers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupListParamsIF#getIncludeCount() includeCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeCount
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListParams withIncludeCount(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeCount, value)) return this;
    return new UsergroupListParams(value, this.includeDisabled, this.includeUsers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupListParamsIF#getIncludeDisabled() includeDisabled} attribute.
   * @param value The value for includeDisabled, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListParams withIncludeDisabled(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeDisabled, newValue)) return this;
    return new UsergroupListParams(this.includeCount, newValue, this.includeUsers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupListParamsIF#getIncludeDisabled() includeDisabled} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeDisabled
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListParams withIncludeDisabled(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeDisabled, value)) return this;
    return new UsergroupListParams(this.includeCount, value, this.includeUsers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupListParamsIF#getIncludeUsers() includeUsers} attribute.
   * @param value The value for includeUsers, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListParams withIncludeUsers(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.includeUsers, newValue)) return this;
    return new UsergroupListParams(this.includeCount, this.includeDisabled, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupListParamsIF#getIncludeUsers() includeUsers} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for includeUsers
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListParams withIncludeUsers(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.includeUsers, value)) return this;
    return new UsergroupListParams(this.includeCount, this.includeDisabled, value);
  }

  /**
   * This instance is equal to all instances of {@code UsergroupListParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsergroupListParams
        && equalTo((UsergroupListParams) another);
  }

  private boolean equalTo(UsergroupListParams another) {
    return Objects.equals(includeCount, another.includeCount)
        && Objects.equals(includeDisabled, another.includeDisabled)
        && Objects.equals(includeUsers, another.includeUsers);
  }

  /**
   * Computes a hash code from attributes: {@code includeCount}, {@code includeDisabled}, {@code includeUsers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(includeCount);
    h = h * 17 + Objects.hashCode(includeDisabled);
    h = h * 17 + Objects.hashCode(includeUsers);
    return h;
  }

  /**
   * Prints the immutable value {@code UsergroupListParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsergroupListParams{");
    if (includeCount != null) {
      builder.append("includeCount=").append(includeCount);
    }
    if (includeDisabled != null) {
      if (builder.length() > 20) builder.append(", ");
      builder.append("includeDisabled=").append(includeDisabled);
    }
    if (includeUsers != null) {
      if (builder.length() > 20) builder.append(", ");
      builder.append("includeUsers=").append(includeUsers);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsergroupListParamsIF {
    Optional<Boolean> includeCount = Optional.empty();
    Optional<Boolean> includeDisabled = Optional.empty();
    Optional<Boolean> includeUsers = Optional.empty();
    @JsonProperty
    public void setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount;
    }
    @JsonProperty
    public void setIncludeDisabled(Optional<Boolean> includeDisabled) {
      this.includeDisabled = includeDisabled;
    }
    @JsonProperty
    public void setIncludeUsers(Optional<Boolean> includeUsers) {
      this.includeUsers = includeUsers;
    }
    @Override
    public Optional<Boolean> getIncludeCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeDisabled() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIncludeUsers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsergroupListParams fromJson(Json json) {
    UsergroupListParams.Builder builder = UsergroupListParams.builder();
    if (json.includeCount != null) {
      builder.setIncludeCount(json.includeCount);
    }
    if (json.includeDisabled != null) {
      builder.setIncludeDisabled(json.includeDisabled);
    }
    if (json.includeUsers != null) {
      builder.setIncludeUsers(json.includeUsers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsergroupListParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsergroupListParams instance
   */
  public static UsergroupListParams copyOf(UsergroupListParamsIF instance) {
    if (instance instanceof UsergroupListParams) {
      return (UsergroupListParams) instance;
    }
    return UsergroupListParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsergroupListParams UsergroupListParams}.
   * @return A new UsergroupListParams builder
   */
  public static UsergroupListParams.Builder builder() {
    return new UsergroupListParams.Builder();
  }

  /**
   * Builds instances of type {@link UsergroupListParams UsergroupListParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Boolean includeCount;
    private @Nullable Boolean includeDisabled;
    private @Nullable Boolean includeUsers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsergroupListParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsergroupListParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<Boolean> includeCountOptional = instance.getIncludeCount();
      if (includeCountOptional.isPresent()) {
        setIncludeCount(includeCountOptional);
      }
      Optional<Boolean> includeDisabledOptional = instance.getIncludeDisabled();
      if (includeDisabledOptional.isPresent()) {
        setIncludeDisabled(includeDisabledOptional);
      }
      Optional<Boolean> includeUsersOptional = instance.getIncludeUsers();
      if (includeUsersOptional.isPresent()) {
        setIncludeUsers(includeUsersOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListParamsIF#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeCount(@Nullable Boolean includeCount) {
      this.includeCount = includeCount;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListParamsIF#getIncludeCount() includeCount} to includeCount.
     * @param includeCount The value for includeCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeCount(Optional<Boolean> includeCount) {
      this.includeCount = includeCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListParamsIF#getIncludeDisabled() includeDisabled} to includeDisabled.
     * @param includeDisabled The value for includeDisabled, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeDisabled(@Nullable Boolean includeDisabled) {
      this.includeDisabled = includeDisabled;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListParamsIF#getIncludeDisabled() includeDisabled} to includeDisabled.
     * @param includeDisabled The value for includeDisabled
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeDisabled(Optional<Boolean> includeDisabled) {
      this.includeDisabled = includeDisabled.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListParamsIF#getIncludeUsers() includeUsers} to includeUsers.
     * @param includeUsers The value for includeUsers, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIncludeUsers(@Nullable Boolean includeUsers) {
      this.includeUsers = includeUsers;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListParamsIF#getIncludeUsers() includeUsers} to includeUsers.
     * @param includeUsers The value for includeUsers
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIncludeUsers(Optional<Boolean> includeUsers) {
      this.includeUsers = includeUsers.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UsergroupListParams UsergroupListParams}.
     * @return An immutable instance of UsergroupListParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsergroupListParams build() throws InvalidImmutableStateException {
      return new UsergroupListParams(includeCount, includeDisabled, includeUsers);
    }
  }
}
