package com.hubspot.slack.client.methods.params.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UserEmailParamsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UserEmailParams.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code UserEmailParams.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UserEmailParamsIF"})
@Immutable
public final class UserEmailParams implements UserEmailParamsIF {
  private final String email;

  private UserEmailParams(String email) {
    this.email = Objects.requireNonNull(email, "email");
  }

  private UserEmailParams(UserEmailParams original, String email) {
    this.email = email;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @JsonProperty
  @Override
  public String getEmail() {
    return email;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UserEmailParamsIF#getEmail() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param email A new value for email
   * @return A modified copy of the {@code this} object
   */
  public final UserEmailParams withEmail(String email) {
    if (this.email.equals(email)) return this;
    String newValue = Objects.requireNonNull(email, "email");
    return new UserEmailParams(this, newValue);
  }

  /**
   * This instance is equal to all instances of {@code UserEmailParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UserEmailParams
        && equalTo((UserEmailParams) another);
  }

  private boolean equalTo(UserEmailParams another) {
    return email.equals(another.email);
  }

  /**
   * Computes a hash code from attributes: {@code email}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + email.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserEmailParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserEmailParams{"
        + "email=" + email
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UserEmailParamsIF {
    @Nullable String email;
    @JsonProperty
    public void setEmail(String email) {
      this.email = email;
    }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UserEmailParams fromJson(Json json) {
    UserEmailParams.Builder builder = UserEmailParams.builder();
    if (json.email != null) {
      builder.setEmail(json.email);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code UserEmailParams} instance.
   * @param email The value for the {@code email} attribute
   * @return An immutable UserEmailParams instance
   */
  public static UserEmailParams of(String email) {
    return new UserEmailParams(email);
  }

  /**
   * Creates an immutable copy of a {@link UserEmailParamsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserEmailParams instance
   */
  public static UserEmailParams copyOf(UserEmailParamsIF instance) {
    if (instance instanceof UserEmailParams) {
      return (UserEmailParams) instance;
    }
    return UserEmailParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UserEmailParams UserEmailParams}.
   * @return A new UserEmailParams builder
   */
  public static UserEmailParams.Builder builder() {
    return new UserEmailParams.Builder();
  }

  /**
   * Builds instances of type {@link UserEmailParams UserEmailParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EMAIL = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String email;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserEmailParamsIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserEmailParamsIF instance) {
      Objects.requireNonNull(instance, "instance");
      setEmail(instance.getEmail());
      return this;
    }

    /**
     * Initializes the value for the {@link UserEmailParamsIF#getEmail() email} attribute.
     * @param email The value for email 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEmail(String email) {
      this.email = Objects.requireNonNull(email, "email");
      initBits &= ~INIT_BIT_EMAIL;
      return this;
    }

    /**
     * Builds a new {@link UserEmailParams UserEmailParams}.
     * @return An immutable instance of UserEmailParams
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UserEmailParams build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UserEmailParams(null, email);
    }

    private boolean emailIsSet() {
      return (initBits & INIT_BIT_EMAIL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!emailIsSet()) attributes.add("email");
      return "Cannot build UserEmailParams, some of required attributes are not set " + attributes;
    }
  }
}
