package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link FieldIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Field.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FieldIF"})
@Immutable
public final class Field implements FieldIF {
  private final @Nullable String title;
  private final String value;
  private final boolean isShort;

  private Field(@Nullable String title, String value, boolean isShort) {
    this.title = title;
    this.value = value;
    this.isShort = isShort;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getTitle() {
    return Optional.ofNullable(title);
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code isShort} attribute
   */
  @JsonProperty("short")
  @Override
  public boolean isShort() {
    return isShort;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FieldIF#getTitle() title} attribute.
   * @param value The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Field withTitle(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.title, newValue)) return this;
    return new Field(newValue, this.value, this.isShort);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FieldIF#getTitle() title} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final Field withTitle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.title, value)) return this;
    return new Field(value, this.value, this.isShort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final Field withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new Field(this.title, newValue, this.isShort);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FieldIF#isShort() isShort} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isShort A new value for isShort
   * @return A modified copy of the {@code this} object
   */
  public final Field withIsShort(boolean isShort) {
    if (this.isShort == isShort) return this;
    return new Field(this.title, this.value, isShort);
  }

  /**
   * This instance is equal to all instances of {@code Field} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Field
        && equalTo((Field) another);
  }

  private boolean equalTo(Field another) {
    return Objects.equals(title, another.title)
        && value.equals(another.value)
        && isShort == another.isShort;
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code value}, {@code isShort}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(title);
    h = h * 17 + value.hashCode();
    h = h * 17 + Boolean.hashCode(isShort);
    return h;
  }

  /**
   * Prints the immutable value {@code Field} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Field{");
    if (title != null) {
      builder.append("title=").append(title);
    }
    if (builder.length() > 6) builder.append(", ");
    builder.append("value=").append(value);
    builder.append(", ");
    builder.append("isShort=").append(isShort);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FieldIF {
    Optional<String> title = Optional.empty();
    @Nullable String value;
    boolean isShort;
    boolean isShortIsSet;
    @JsonProperty
    public void setTitle(Optional<String> title) {
      this.title = title;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty("short")
    public void setIsShort(boolean isShort) {
      this.isShort = isShort;
      this.isShortIsSet = true;
    }
    @Override
    public Optional<String> getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isShort() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Field fromJson(Json json) {
    Field.Builder builder = Field.builder();
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.isShortIsSet) {
      builder.setIsShort(json.isShort);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FieldIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Field instance
   */
  public static Field copyOf(FieldIF instance) {
    if (instance instanceof Field) {
      return (Field) instance;
    }
    return Field.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Field Field}.
   * @return A new Field builder
   */
  public static Field.Builder builder() {
    return new Field.Builder();
  }

  /**
   * Builds instances of type {@link Field Field}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_IS_SHORT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String title;
    private @Nullable String value;
    private boolean isShort;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FieldIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FieldIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> titleOptional = instance.getTitle();
      if (titleOptional.isPresent()) {
        setTitle(titleOptional);
      }
      setValue(instance.getValue());
      setIsShort(instance.isShort());
      return this;
    }

    /**
     * Initializes the optional value {@link FieldIF#getTitle() title} to title.
     * @param title The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTitle(@Nullable String title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link FieldIF#getTitle() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Optional<String> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link FieldIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link FieldIF#isShort() isShort} attribute.
     * @param isShort The value for isShort 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsShort(boolean isShort) {
      this.isShort = isShort;
      initBits &= ~INIT_BIT_IS_SHORT;
      return this;
    }

    /**
     * Builds a new {@link Field Field}.
     * @return An immutable instance of Field
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Field build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Field(title, value, isShort);
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private boolean isShortIsSet() {
      return (initBits & INIT_BIT_IS_SHORT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!valueIsSet()) attributes.add("value");
      if (!isShortIsSet()) attributes.add("isShort");
      return "Cannot build Field, some of required attributes are not set " + attributes;
    }
  }
}
