package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link LiteMessageIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code LiteMessage.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "LiteMessageIF"})
@Immutable
public final class LiteMessage implements LiteMessageIF {
  private final String type;
  private final @Nullable String subtype;
  private final @Nullable String user;
  private final @Nullable String botId;
  private final @Nullable String username;
  private final String text;
  private final List<Attachment> attachments;
  private final List<SlackFile> files;
  private final String timestamp;
  private final @Nullable String threadTimestamp;
  private final @Nullable Integer replyCount;
  private final @Nullable List<String> replyUserIds;
  private final @Nullable Integer replyUsersCount;
  private final @Nullable String latestReplyTimestamp;
  private final List<ReplySkeleton> replies;

  private LiteMessage(LiteMessage.Builder builder) {
    this.type = builder.type;
    this.subtype = builder.subtype;
    this.user = builder.user;
    this.botId = builder.botId;
    this.username = builder.username;
    this.text = builder.text;
    this.attachments = createUnmodifiableList(true, builder.attachments);
    this.files = createUnmodifiableList(true, builder.files);
    this.timestamp = builder.timestamp;
    this.threadTimestamp = builder.threadTimestamp;
    this.replyCount = builder.replyCount;
    this.replyUserIds = builder.replyUserIds;
    this.replyUsersCount = builder.replyUsersCount;
    this.latestReplyTimestamp = builder.latestReplyTimestamp;
    this.replies = builder.repliesIsSet()
        ? createUnmodifiableList(true, builder.replies)
        : createUnmodifiableList(false, createSafeList(LiteMessageIF.super.getReplies(), true, false));
  }

  private LiteMessage(
      String type,
      @Nullable String subtype,
      @Nullable String user,
      @Nullable String botId,
      @Nullable String username,
      String text,
      List<Attachment> attachments,
      List<SlackFile> files,
      String timestamp,
      @Nullable String threadTimestamp,
      @Nullable Integer replyCount,
      @Nullable List<String> replyUserIds,
      @Nullable Integer replyUsersCount,
      @Nullable String latestReplyTimestamp,
      List<ReplySkeleton> replies) {
    this.type = type;
    this.subtype = subtype;
    this.user = user;
    this.botId = botId;
    this.username = username;
    this.text = text;
    this.attachments = attachments;
    this.files = files;
    this.timestamp = timestamp;
    this.threadTimestamp = threadTimestamp;
    this.replyCount = replyCount;
    this.replyUserIds = replyUserIds;
    this.replyUsersCount = replyUsersCount;
    this.latestReplyTimestamp = latestReplyTimestamp;
    this.replies = replies;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUser() {
    return Optional.ofNullable(user);
  }

  /**
   * @return The value of the {@code botId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBotId() {
    return Optional.ofNullable(botId);
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUsername() {
    return Optional.ofNullable(username);
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code attachments} attribute
   */
  @JsonProperty
  @Override
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @JsonProperty
  @Override
  public List<SlackFile> getFiles() {
    return files;
  }

  /**
   * @return The value of the {@code timestamp} attribute
   */
  @JsonProperty("ts")
  @Override
  public String getTimestamp() {
    return timestamp;
  }

  /**
   * @return The value of the {@code threadTimestamp} attribute
   */
  @JsonProperty("thread_ts")
  @Override
  public Optional<String> getThreadTimestamp() {
    return Optional.ofNullable(threadTimestamp);
  }

  /**
   * @return The value of the {@code replyCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getReplyCount() {
    return Optional.ofNullable(replyCount);
  }

  /**
   * @return The value of the {@code replyUserIds} attribute
   */
  @JsonProperty("reply_users")
  @Override
  public Optional<List<String>> getReplyUserIds() {
    return Optional.ofNullable(replyUserIds);
  }

  /**
   * @return The value of the {@code replyUsersCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getReplyUsersCount() {
    return Optional.ofNullable(replyUsersCount);
  }

  /**
   * @return The value of the {@code latestReplyTimestamp} attribute
   */
  @JsonProperty("latest_reply")
  @Override
  public Optional<String> getLatestReplyTimestamp() {
    return Optional.ofNullable(latestReplyTimestamp);
  }

  /**
   * @deprecated use {@link #getReplyUserIds()} or {@link #getLatestReplyTimestamp()}
   * These can be used to find the user ids and the last reply timestamp.
   * Used to return a list of `ReplySkeleton`
   */
  @JsonProperty
  @Deprecated
  @Override
  public List<ReplySkeleton> getReplies() {
    return replies;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiteMessageIF#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final LiteMessage withType(String type) {
    if (this.type.equals(type)) return this;
    String newValue = Objects.requireNonNull(type, "type");
    return new LiteMessage(
        newValue,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withSubtype(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return new LiteMessage(
        this.type,
        newValue,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withSubtype(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return new LiteMessage(
        this.type,
        value,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getUser() user} attribute.
   * @param value The value for user, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withUser(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.user, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        newValue,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getUser() user} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for user
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withUser(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.user, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        value,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getBotId() botId} attribute.
   * @param value The value for botId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withBotId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.botId, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        newValue,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getBotId() botId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for botId
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withBotId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.botId, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        value,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getUsername() username} attribute.
   * @param value The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withUsername(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.username, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        newValue,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getUsername() username} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for username
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withUsername(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.username, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        value,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiteMessageIF#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final LiteMessage withText(String text) {
    if (this.text.equals(text)) return this;
    String newValue = Objects.requireNonNull(text, "text");
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        newValue,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiteMessageIF#getAttachments() attachments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withAttachments(Attachment... elements) {
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        newValue,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiteMessageIF#getAttachments() attachments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attachments elements to set
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withAttachments(Iterable<? extends Attachment> elements) {
    if (this.attachments == elements) return this;
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        newValue,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiteMessageIF#getFiles() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withFiles(SlackFile... elements) {
    List<SlackFile> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        newValue,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiteMessageIF#getFiles() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withFiles(Iterable<? extends SlackFile> elements) {
    if (this.files == elements) return this;
    List<SlackFile> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        newValue,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link LiteMessageIF#getTimestamp() timestamp} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param timestamp A new value for timestamp
   * @return A modified copy of the {@code this} object
   */
  public final LiteMessage withTimestamp(String timestamp) {
    if (this.timestamp.equals(timestamp)) return this;
    String newValue = Objects.requireNonNull(timestamp, "timestamp");
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        newValue,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getThreadTimestamp() threadTimestamp} attribute.
   * @param value The value for threadTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withThreadTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.threadTimestamp, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        newValue,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getThreadTimestamp() threadTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for threadTimestamp
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withThreadTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.threadTimestamp, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        value,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getReplyCount() replyCount} attribute.
   * @param value The value for replyCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withReplyCount(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.replyCount, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        newValue,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getReplyCount() replyCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replyCount
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withReplyCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.replyCount, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        value,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getReplyUserIds() replyUserIds} attribute.
   * @param value The value for replyUserIds, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withReplyUserIds(@Nullable List<String> value) {
    @Nullable List<String> newValue = value;
    if (this.replyUserIds == newValue) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        newValue,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getReplyUserIds() replyUserIds} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replyUserIds
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withReplyUserIds(Optional<List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.replyUserIds == value) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        value,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getReplyUsersCount() replyUsersCount} attribute.
   * @param value The value for replyUsersCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withReplyUsersCount(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.replyUsersCount, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        newValue,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getReplyUsersCount() replyUsersCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replyUsersCount
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withReplyUsersCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.replyUsersCount, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        value,
        this.latestReplyTimestamp,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link LiteMessageIF#getLatestReplyTimestamp() latestReplyTimestamp} attribute.
   * @param value The value for latestReplyTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withLatestReplyTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.latestReplyTimestamp, newValue)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        newValue,
        this.replies);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link LiteMessageIF#getLatestReplyTimestamp() latestReplyTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for latestReplyTimestamp
   * @return A modified copy of {@code this} object
   */
  public final LiteMessage withLatestReplyTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.latestReplyTimestamp, value)) return this;
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        value,
        this.replies);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiteMessageIF#getReplies() replies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final LiteMessage withReplies(ReplySkeleton... elements) {
    List<ReplySkeleton> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LiteMessageIF#getReplies() replies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of replies elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final LiteMessage withReplies(Iterable<? extends ReplySkeleton> elements) {
    if (this.replies == elements) return this;
    List<ReplySkeleton> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new LiteMessage(
        this.type,
        this.subtype,
        this.user,
        this.botId,
        this.username,
        this.text,
        this.attachments,
        this.files,
        this.timestamp,
        this.threadTimestamp,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code LiteMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof LiteMessage
        && equalTo((LiteMessage) another);
  }

  private boolean equalTo(LiteMessage another) {
    return type.equals(another.type)
        && Objects.equals(subtype, another.subtype)
        && Objects.equals(user, another.user)
        && Objects.equals(botId, another.botId)
        && Objects.equals(username, another.username)
        && text.equals(another.text)
        && attachments.equals(another.attachments)
        && files.equals(another.files)
        && timestamp.equals(another.timestamp)
        && Objects.equals(threadTimestamp, another.threadTimestamp)
        && Objects.equals(replyCount, another.replyCount)
        && Objects.equals(replyUserIds, another.replyUserIds)
        && Objects.equals(replyUsersCount, another.replyUsersCount)
        && Objects.equals(latestReplyTimestamp, another.latestReplyTimestamp)
        && replies.equals(another.replies);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code subtype}, {@code user}, {@code botId}, {@code username}, {@code text}, {@code attachments}, {@code files}, {@code timestamp}, {@code threadTimestamp}, {@code replyCount}, {@code replyUserIds}, {@code replyUsersCount}, {@code latestReplyTimestamp}, {@code replies}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + Objects.hashCode(user);
    h = h * 17 + Objects.hashCode(botId);
    h = h * 17 + Objects.hashCode(username);
    h = h * 17 + text.hashCode();
    h = h * 17 + attachments.hashCode();
    h = h * 17 + files.hashCode();
    h = h * 17 + timestamp.hashCode();
    h = h * 17 + Objects.hashCode(threadTimestamp);
    h = h * 17 + Objects.hashCode(replyCount);
    h = h * 17 + Objects.hashCode(replyUserIds);
    h = h * 17 + Objects.hashCode(replyUsersCount);
    h = h * 17 + Objects.hashCode(latestReplyTimestamp);
    h = h * 17 + replies.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LiteMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("LiteMessage{");
    builder.append("type=").append(type);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    if (user != null) {
      builder.append(", ");
      builder.append("user=").append(user);
    }
    if (botId != null) {
      builder.append(", ");
      builder.append("botId=").append(botId);
    }
    if (username != null) {
      builder.append(", ");
      builder.append("username=").append(username);
    }
    builder.append(", ");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("attachments=").append(attachments);
    builder.append(", ");
    builder.append("files=").append(files);
    builder.append(", ");
    builder.append("timestamp=").append(timestamp);
    if (threadTimestamp != null) {
      builder.append(", ");
      builder.append("threadTimestamp=").append(threadTimestamp);
    }
    if (replyCount != null) {
      builder.append(", ");
      builder.append("replyCount=").append(replyCount);
    }
    if (replyUserIds != null) {
      builder.append(", ");
      builder.append("replyUserIds=").append(replyUserIds);
    }
    if (replyUsersCount != null) {
      builder.append(", ");
      builder.append("replyUsersCount=").append(replyUsersCount);
    }
    if (latestReplyTimestamp != null) {
      builder.append(", ");
      builder.append("latestReplyTimestamp=").append(latestReplyTimestamp);
    }
    builder.append(", ");
    builder.append("replies=").append(replies);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements LiteMessageIF {
    @Nullable String type;
    Optional<String> subtype = Optional.empty();
    Optional<String> user = Optional.empty();
    Optional<String> botId = Optional.empty();
    Optional<String> username = Optional.empty();
    @Nullable String text;
    List<Attachment> attachments = Collections.emptyList();
    List<SlackFile> files = Collections.emptyList();
    @Nullable String timestamp;
    Optional<String> threadTimestamp = Optional.empty();
    Optional<Integer> replyCount = Optional.empty();
    Optional<List<String>> replyUserIds = Optional.empty();
    Optional<Integer> replyUsersCount = Optional.empty();
    Optional<String> latestReplyTimestamp = Optional.empty();
    List<ReplySkeleton> replies = Collections.emptyList();
    boolean repliesIsSet;
    @JsonProperty
    public void setType(String type) {
      this.type = type;
    }
    @JsonProperty
    public void setSubtype(Optional<String> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setUser(Optional<String> user) {
      this.user = user;
    }
    @JsonProperty
    public void setBotId(Optional<String> botId) {
      this.botId = botId;
    }
    @JsonProperty
    public void setUsername(Optional<String> username) {
      this.username = username;
    }
    @JsonProperty
    public void setText(String text) {
      this.text = text;
    }
    @JsonProperty
    public void setAttachments(List<Attachment> attachments) {
      this.attachments = attachments;
    }
    @JsonProperty
    public void setFiles(List<SlackFile> files) {
      this.files = files;
    }
    @JsonProperty("ts")
    public void setTimestamp(String timestamp) {
      this.timestamp = timestamp;
    }
    @JsonProperty("thread_ts")
    public void setThreadTimestamp(Optional<String> threadTimestamp) {
      this.threadTimestamp = threadTimestamp;
    }
    @JsonProperty
    public void setReplyCount(Optional<Integer> replyCount) {
      this.replyCount = replyCount;
    }
    @JsonProperty("reply_users")
    public void setReplyUserIds(Optional<List<String>> replyUserIds) {
      this.replyUserIds = replyUserIds;
    }
    @JsonProperty
    public void setReplyUsersCount(Optional<Integer> replyUsersCount) {
      this.replyUsersCount = replyUsersCount;
    }
    @JsonProperty("latest_reply")
    public void setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
      this.latestReplyTimestamp = latestReplyTimestamp;
    }
    @JsonProperty
    public void setReplies(List<ReplySkeleton> replies) {
      this.replies = replies;
      this.repliesIsSet = true;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUser() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBotId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUsername() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attachment> getAttachments() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackFile> getFiles() { throw new UnsupportedOperationException(); }
    @Override
    public String getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThreadTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getReplyCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> getReplyUserIds() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getReplyUsersCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getLatestReplyTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public List<ReplySkeleton> getReplies() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static LiteMessage fromJson(Json json) {
    LiteMessage.Builder builder = LiteMessage.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.botId != null) {
      builder.setBotId(json.botId);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.attachments != null) {
      builder.addAllAttachments(json.attachments);
    }
    if (json.files != null) {
      builder.addAllFiles(json.files);
    }
    if (json.timestamp != null) {
      builder.setTimestamp(json.timestamp);
    }
    if (json.threadTimestamp != null) {
      builder.setThreadTimestamp(json.threadTimestamp);
    }
    if (json.replyCount != null) {
      builder.setReplyCount(json.replyCount);
    }
    if (json.replyUserIds != null) {
      builder.setReplyUserIds(json.replyUserIds);
    }
    if (json.replyUsersCount != null) {
      builder.setReplyUsersCount(json.replyUsersCount);
    }
    if (json.latestReplyTimestamp != null) {
      builder.setLatestReplyTimestamp(json.latestReplyTimestamp);
    }
    if (json.repliesIsSet) {
      builder.setReplies(json.replies);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link LiteMessageIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LiteMessage instance
   */
  public static LiteMessage copyOf(LiteMessageIF instance) {
    if (instance instanceof LiteMessage) {
      return (LiteMessage) instance;
    }
    return LiteMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link LiteMessage LiteMessage}.
   * @return A new LiteMessage builder
   */
  public static LiteMessage.Builder builder() {
    return new LiteMessage.Builder();
  }

  /**
   * Builds instances of type {@link LiteMessage LiteMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_TEXT = 0x2L;
    private static final long INIT_BIT_TIMESTAMP = 0x4L;
    private static final long OPT_BIT_REPLIES = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable String type;
    private @Nullable String subtype;
    private @Nullable String user;
    private @Nullable String botId;
    private @Nullable String username;
    private @Nullable String text;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private List<SlackFile> files = new ArrayList<SlackFile>();
    private @Nullable String timestamp;
    private @Nullable String threadTimestamp;
    private @Nullable Integer replyCount;
    private @Nullable List<String> replyUserIds;
    private @Nullable Integer replyUsersCount;
    private @Nullable String latestReplyTimestamp;
    private List<ReplySkeleton> replies = new ArrayList<ReplySkeleton>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LiteMessageIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LiteMessageIF instance) {
      Objects.requireNonNull(instance, "instance");
      setType(instance.getType());
      Optional<String> subtypeOptional = instance.getSubtype();
      if (subtypeOptional.isPresent()) {
        setSubtype(subtypeOptional);
      }
      Optional<String> userOptional = instance.getUser();
      if (userOptional.isPresent()) {
        setUser(userOptional);
      }
      Optional<String> botIdOptional = instance.getBotId();
      if (botIdOptional.isPresent()) {
        setBotId(botIdOptional);
      }
      Optional<String> usernameOptional = instance.getUsername();
      if (usernameOptional.isPresent()) {
        setUsername(usernameOptional);
      }
      setText(instance.getText());
      addAllAttachments(instance.getAttachments());
      addAllFiles(instance.getFiles());
      setTimestamp(instance.getTimestamp());
      Optional<String> threadTimestampOptional = instance.getThreadTimestamp();
      if (threadTimestampOptional.isPresent()) {
        setThreadTimestamp(threadTimestampOptional);
      }
      Optional<Integer> replyCountOptional = instance.getReplyCount();
      if (replyCountOptional.isPresent()) {
        setReplyCount(replyCountOptional);
      }
      Optional<List<String>> replyUserIdsOptional = instance.getReplyUserIds();
      if (replyUserIdsOptional.isPresent()) {
        setReplyUserIds(replyUserIdsOptional);
      }
      Optional<Integer> replyUsersCountOptional = instance.getReplyUsersCount();
      if (replyUsersCountOptional.isPresent()) {
        setReplyUsersCount(replyUsersCountOptional);
      }
      Optional<String> latestReplyTimestampOptional = instance.getLatestReplyTimestamp();
      if (latestReplyTimestampOptional.isPresent()) {
        setLatestReplyTimestamp(latestReplyTimestampOptional);
      }
      addAllReplies(instance.getReplies());
      return this;
    }

    /**
     * Initializes the value for the {@link LiteMessageIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable String subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<String> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getUser() user} to user.
     * @param user The value for user, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUser(@Nullable String user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getUser() user} to user.
     * @param user The value for user
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(Optional<String> user) {
      this.user = user.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getBotId() botId} to botId.
     * @param botId The value for botId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBotId(@Nullable String botId) {
      this.botId = botId;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getBotId() botId} to botId.
     * @param botId The value for botId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBotId(Optional<String> botId) {
      this.botId = botId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getUsername() username} to username.
     * @param username The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUsername(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link LiteMessageIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Adds one element to {@link LiteMessageIF#getAttachments() attachments} list.
     * @param element A attachments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment element) {
      this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      return this;
    }

    /**
     * Adds elements to {@link LiteMessageIF#getAttachments() attachments} list.
     * @param elements An array of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment... elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link LiteMessageIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachments(Iterable<? extends Attachment> elements) {
      this.attachments.clear();
      return addAllAttachments(elements);
    }

    /**
     * Adds elements to {@link LiteMessageIF#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link LiteMessageIF#getFiles() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFiles(SlackFile element) {
      this.files.add(Objects.requireNonNull(element, "files element"));
      return this;
    }

    /**
     * Adds elements to {@link LiteMessageIF#getFiles() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFiles(SlackFile... elements) {
      for (SlackFile element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link LiteMessageIF#getFiles() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFiles(Iterable<? extends SlackFile> elements) {
      this.files.clear();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link LiteMessageIF#getFiles() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFiles(Iterable<? extends SlackFile> elements) {
      for (SlackFile element : elements) {
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link LiteMessageIF#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimestamp(String timestamp) {
      this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
      initBits &= ~INIT_BIT_TIMESTAMP;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getThreadTimestamp() threadTimestamp} to threadTimestamp.
     * @param threadTimestamp The value for threadTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThreadTimestamp(@Nullable String threadTimestamp) {
      this.threadTimestamp = threadTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getThreadTimestamp() threadTimestamp} to threadTimestamp.
     * @param threadTimestamp The value for threadTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTimestamp(Optional<String> threadTimestamp) {
      this.threadTimestamp = threadTimestamp.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getReplyCount() replyCount} to replyCount.
     * @param replyCount The value for replyCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setReplyCount(@Nullable Integer replyCount) {
      this.replyCount = replyCount;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getReplyCount() replyCount} to replyCount.
     * @param replyCount The value for replyCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyCount(Optional<Integer> replyCount) {
      this.replyCount = replyCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getReplyUserIds() replyUserIds} to replyUserIds.
     * @param replyUserIds The value for replyUserIds, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setReplyUserIds(@Nullable List<String> replyUserIds) {
      this.replyUserIds = replyUserIds;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getReplyUserIds() replyUserIds} to replyUserIds.
     * @param replyUserIds The value for replyUserIds
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyUserIds(Optional<List<String>> replyUserIds) {
      this.replyUserIds = replyUserIds.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getReplyUsersCount() replyUsersCount} to replyUsersCount.
     * @param replyUsersCount The value for replyUsersCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setReplyUsersCount(@Nullable Integer replyUsersCount) {
      this.replyUsersCount = replyUsersCount;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getReplyUsersCount() replyUsersCount} to replyUsersCount.
     * @param replyUsersCount The value for replyUsersCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyUsersCount(Optional<Integer> replyUsersCount) {
      this.replyUsersCount = replyUsersCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getLatestReplyTimestamp() latestReplyTimestamp} to latestReplyTimestamp.
     * @param latestReplyTimestamp The value for latestReplyTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLatestReplyTimestamp(@Nullable String latestReplyTimestamp) {
      this.latestReplyTimestamp = latestReplyTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link LiteMessageIF#getLatestReplyTimestamp() latestReplyTimestamp} to latestReplyTimestamp.
     * @param latestReplyTimestamp The value for latestReplyTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
      this.latestReplyTimestamp = latestReplyTimestamp.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link LiteMessageIF#getReplies() replies} list.
     * @param element A replies element
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addReplies(ReplySkeleton element) {
      this.replies.add(Objects.requireNonNull(element, "replies element"));
      optBits |= OPT_BIT_REPLIES;
      return this;
    }

    /**
     * Adds elements to {@link LiteMessageIF#getReplies() replies} list.
     * @param elements An array of replies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addReplies(ReplySkeleton... elements) {
      for (ReplySkeleton element : elements) {
        this.replies.add(Objects.requireNonNull(element, "replies element"));
      }
      optBits |= OPT_BIT_REPLIES;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link LiteMessageIF#getReplies() replies} list.
     * @param elements An iterable of replies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder setReplies(Iterable<? extends ReplySkeleton> elements) {
      this.replies.clear();
      return addAllReplies(elements);
    }

    /**
     * Adds elements to {@link LiteMessageIF#getReplies() replies} list.
     * @param elements An iterable of replies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addAllReplies(Iterable<? extends ReplySkeleton> elements) {
      for (ReplySkeleton element : elements) {
        this.replies.add(Objects.requireNonNull(element, "replies element"));
      }
      optBits |= OPT_BIT_REPLIES;
      return this;
    }

    /**
     * Builds a new {@link LiteMessage LiteMessage}.
     * @return An immutable instance of LiteMessage
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public LiteMessage build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new LiteMessage(this);
    }

    private boolean repliesIsSet() {
      return (optBits & OPT_BIT_REPLIES) != 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean timestampIsSet() {
      return (initBits & INIT_BIT_TIMESTAMP) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      if (!textIsSet()) attributes.add("text");
      if (!timestampIsSet()) attributes.add("timestamp");
      return "Cannot build LiteMessage, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
