package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackChannelIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackChannel.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackChannelIF"})
@Immutable
public final class SlackChannel implements SlackChannelIF {
  private final String id;
  private final String name;
  private final @Nullable Boolean isArchived;
  private final @Nullable Boolean isGeneral;
  private final ChannelType channelType;

  private SlackChannel(
      String id,
      String name,
      @Nullable Boolean isArchived,
      @Nullable Boolean isGeneral) {
    this.id = id;
    this.name = name;
    this.isArchived = isArchived;
    this.isGeneral = isGeneral;
    this.channelType = Objects.requireNonNull(SlackChannelIF.super.getChannelType(), "channelType");
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code isArchived} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIsArchived() {
    return Optional.ofNullable(isArchived);
  }

  /**
   * @return The value of the {@code isGeneral} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getIsGeneral() {
    return Optional.ofNullable(isGeneral);
  }

  /**
   * @return The computed-at-construction value of the {@code channelType} attribute
   */
  @JsonProperty
  @JsonIgnore
  @Override
  public ChannelType getChannelType() {
    return channelType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannel withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackChannel(newValue, this.name, this.isArchived, this.isGeneral);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannel withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new SlackChannel(this.id, newValue, this.isArchived, this.isGeneral);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackChannelIF#getIsArchived() isArchived} attribute.
   * @param value The value for isArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackChannel withIsArchived(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isArchived, newValue)) return this;
    return new SlackChannel(this.id, this.name, newValue, this.isGeneral);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackChannelIF#getIsArchived() isArchived} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isArchived
   * @return A modified copy of {@code this} object
   */
  public final SlackChannel withIsArchived(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isArchived, value)) return this;
    return new SlackChannel(this.id, this.name, value, this.isGeneral);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackChannelIF#getIsGeneral() isGeneral} attribute.
   * @param value The value for isGeneral, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackChannel withIsGeneral(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.isGeneral, newValue)) return this;
    return new SlackChannel(this.id, this.name, this.isArchived, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackChannelIF#getIsGeneral() isGeneral} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for isGeneral
   * @return A modified copy of {@code this} object
   */
  public final SlackChannel withIsGeneral(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.isGeneral, value)) return this;
    return new SlackChannel(this.id, this.name, this.isArchived, value);
  }

  /**
   * This instance is equal to all instances of {@code SlackChannel} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackChannel
        && equalTo((SlackChannel) another);
  }

  private boolean equalTo(SlackChannel another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && Objects.equals(isArchived, another.isArchived)
        && Objects.equals(isGeneral, another.isGeneral)
        && channelType.equals(another.channelType);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code isArchived}, {@code isGeneral}, {@code channelType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + Objects.hashCode(isArchived);
    h = h * 17 + Objects.hashCode(isGeneral);
    h = h * 17 + channelType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackChannel} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackChannel{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("name=").append(name);
    if (isArchived != null) {
      builder.append(", ");
      builder.append("isArchived=").append(isArchived);
    }
    if (isGeneral != null) {
      builder.append(", ");
      builder.append("isGeneral=").append(isGeneral);
    }
    builder.append(", ");
    builder.append("channelType=").append(channelType);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackChannelIF {
    @Nullable String id;
    @Nullable String name;
    Optional<Boolean> isArchived = Optional.empty();
    Optional<Boolean> isGeneral = Optional.empty();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setIsArchived(Optional<Boolean> isArchived) {
      this.isArchived = isArchived;
    }
    @JsonProperty
    public void setIsGeneral(Optional<Boolean> isGeneral) {
      this.isGeneral = isGeneral;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIsArchived() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getIsGeneral() { throw new UnsupportedOperationException(); }
    @Override
    public ChannelType getChannelType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackChannel fromJson(Json json) {
    SlackChannel.Builder builder = SlackChannel.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.isArchived != null) {
      builder.setIsArchived(json.isArchived);
    }
    if (json.isGeneral != null) {
      builder.setIsGeneral(json.isGeneral);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackChannelIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackChannel instance
   */
  public static SlackChannel copyOf(SlackChannelIF instance) {
    if (instance instanceof SlackChannel) {
      return (SlackChannel) instance;
    }
    return SlackChannel.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackChannel SlackChannel}.
   * @return A new SlackChannel builder
   */
  public static SlackChannel.Builder builder() {
    return new SlackChannel.Builder();
  }

  /**
   * Builds instances of type {@link SlackChannel SlackChannel}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String name;
    private @Nullable Boolean isArchived;
    private @Nullable Boolean isGeneral;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackChannelIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackChannelIF instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      setName(instance.getName());
      Optional<Boolean> isArchivedOptional = instance.getIsArchived();
      if (isArchivedOptional.isPresent()) {
        setIsArchived(isArchivedOptional);
      }
      Optional<Boolean> isGeneralOptional = instance.getIsGeneral();
      if (isGeneralOptional.isPresent()) {
        setIsGeneral(isGeneralOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackChannelIF#getIsArchived() isArchived} to isArchived.
     * @param isArchived The value for isArchived, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIsArchived(@Nullable Boolean isArchived) {
      this.isArchived = isArchived;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackChannelIF#getIsArchived() isArchived} to isArchived.
     * @param isArchived The value for isArchived
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsArchived(Optional<Boolean> isArchived) {
      this.isArchived = isArchived.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackChannelIF#getIsGeneral() isGeneral} to isGeneral.
     * @param isGeneral The value for isGeneral, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setIsGeneral(@Nullable Boolean isGeneral) {
      this.isGeneral = isGeneral;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackChannelIF#getIsGeneral() isGeneral} to isGeneral.
     * @param isGeneral The value for isGeneral
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsGeneral(Optional<Boolean> isGeneral) {
      this.isGeneral = isGeneral.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackChannel SlackChannel}.
     * @return An immutable instance of SlackChannel
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackChannel build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackChannel(id, name, isArchived, isGeneral);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      if (!nameIsSet()) attributes.add("name");
      return "Cannot build SlackChannel, some of required attributes are not set " + attributes;
    }
  }
}
