package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ActionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Action.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ActionIF"})
@Immutable
public final class Action implements ActionIF {
  private final @Nullable String name;
  private final ActionType type;
  private final @Nullable String text;
  private final @Nullable String value;
  private final @Nullable Confirm confirm;
  private final @Nullable String url;
  private final @Nullable String rawStyle;
  private final Optional<ButtonStyle> buttonStyle;
  private final List<Option> options;
  private final List<Option> selectedOptions;
  private final @Nullable SlackDataSource dataSource;
  private final @Nullable Integer minQueryLength;

  private Action(
      @Nullable String name,
      ActionType type,
      @Nullable String text,
      @Nullable String value,
      @Nullable Confirm confirm,
      @Nullable String url,
      @Nullable String rawStyle,
      List<Option> options,
      List<Option> selectedOptions,
      @Nullable SlackDataSource dataSource,
      @Nullable Integer minQueryLength) {
    this.name = name;
    this.type = type;
    this.text = text;
    this.value = value;
    this.confirm = confirm;
    this.url = url;
    this.rawStyle = rawStyle;
    this.options = options;
    this.selectedOptions = selectedOptions;
    this.dataSource = dataSource;
    this.minQueryLength = minQueryLength;
    this.buttonStyle = Objects.requireNonNull(ActionIF.super.getButtonStyle(), "buttonStyle");
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getName() {
    return Optional.ofNullable(name);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public ActionType getType() {
    return type;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getValue() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code confirm} attribute
   */
  @JsonProperty
  @Override
  public Optional<Confirm> getConfirm() {
    return Optional.ofNullable(confirm);
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUrl() {
    return Optional.ofNullable(url);
  }

  /**
   * @return The value of the {@code rawStyle} attribute
   */
  @JsonProperty("style")
  @Override
  public Optional<String> getRawStyle() {
    return Optional.ofNullable(rawStyle);
  }

  /**
   * @return The computed-at-construction value of the {@code buttonStyle} attribute
   */
  @JsonProperty
  @Override
  public Optional<ButtonStyle> getButtonStyle() {
    return buttonStyle;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @Override
  public List<Option> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code selectedOptions} attribute
   */
  @JsonProperty
  @Override
  public List<Option> getSelectedOptions() {
    return selectedOptions;
  }

  /**
   * @return The value of the {@code dataSource} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackDataSource> getDataSource() {
    return Optional.ofNullable(dataSource);
  }

  /**
   * @return The value of the {@code minQueryLength} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getMinQueryLength() {
    return Optional.ofNullable(minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getName() name} attribute.
   * @param value The value for name, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withName(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.name, newValue)) return this;
    return new Action(
        newValue,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getName() name} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for name
   * @return A modified copy of {@code this} object
   */
  public final Action withName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.name, value)) return this;
    return new Action(
        value,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ActionIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final Action withType(ActionType type) {
    if (this.type == type) return this;
    ActionType newValue = Objects.requireNonNull(type, "type");
    return new Action(
        this.name,
        newValue,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return new Action(
        this.name,
        this.type,
        newValue,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final Action withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return new Action(
        this.name,
        this.type,
        value,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getValue() value} attribute.
   * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.value, newValue)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        newValue,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getValue() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final Action withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getConfirm() confirm} attribute.
   * @param value The value for confirm, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withConfirm(@Nullable Confirm value) {
    @Nullable Confirm newValue = value;
    if (this.confirm == newValue) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        newValue,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getConfirm() confirm} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirm
   * @return A modified copy of {@code this} object
   */
  public final Action withConfirm(Optional<Confirm> optional) {
    @Nullable Confirm value = optional.orElse(null);
    if (this.confirm == value) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        value,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getUrl() url} attribute.
   * @param value The value for url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.url, newValue)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        newValue,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getUrl() url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for url
   * @return A modified copy of {@code this} object
   */
  public final Action withUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.url, value)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        value,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getRawStyle() rawStyle} attribute.
   * @param value The value for rawStyle, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withRawStyle(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.rawStyle, newValue)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        newValue,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getRawStyle() rawStyle} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for rawStyle
   * @return A modified copy of {@code this} object
   */
  public final Action withRawStyle(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.rawStyle, value)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        value,
        this.options,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionIF#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Action withOptions(Option... elements) {
    List<Option> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        newValue,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionIF#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final Action withOptions(Iterable<? extends Option> elements) {
    if (this.options == elements) return this;
    List<Option> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        newValue,
        this.selectedOptions,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionIF#getSelectedOptions() selectedOptions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Action withSelectedOptions(Option... elements) {
    List<Option> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        newValue,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionIF#getSelectedOptions() selectedOptions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of selectedOptions elements to set
   * @return A modified copy of {@code this} object
   */
  public final Action withSelectedOptions(Iterable<? extends Option> elements) {
    if (this.selectedOptions == elements) return this;
    List<Option> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        newValue,
        this.dataSource,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getDataSource() dataSource} attribute.
   * @param value The value for dataSource, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withDataSource(@Nullable SlackDataSource value) {
    @Nullable SlackDataSource newValue = value;
    if (Objects.equals(this.dataSource, newValue)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        newValue,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getDataSource() dataSource} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dataSource
   * @return A modified copy of {@code this} object
   */
  public final Action withDataSource(Optional<SlackDataSource> optional) {
    @Nullable SlackDataSource value = optional.orElse(null);
    if (Objects.equals(this.dataSource, value)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        value,
        this.minQueryLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionIF#getMinQueryLength() minQueryLength} attribute.
   * @param value The value for minQueryLength, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Action withMinQueryLength(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.minQueryLength, newValue)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionIF#getMinQueryLength() minQueryLength} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minQueryLength
   * @return A modified copy of {@code this} object
   */
  public final Action withMinQueryLength(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.minQueryLength, value)) return this;
    return new Action(
        this.name,
        this.type,
        this.text,
        this.value,
        this.confirm,
        this.url,
        this.rawStyle,
        this.options,
        this.selectedOptions,
        this.dataSource,
        value);
  }

  /**
   * This instance is equal to all instances of {@code Action} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Action
        && equalTo((Action) another);
  }

  private boolean equalTo(Action another) {
    return Objects.equals(name, another.name)
        && type.equals(another.type)
        && Objects.equals(text, another.text)
        && Objects.equals(value, another.value)
        && Objects.equals(confirm, another.confirm)
        && Objects.equals(url, another.url)
        && Objects.equals(rawStyle, another.rawStyle)
        && buttonStyle.equals(another.buttonStyle)
        && options.equals(another.options)
        && selectedOptions.equals(another.selectedOptions)
        && Objects.equals(dataSource, another.dataSource)
        && Objects.equals(minQueryLength, another.minQueryLength);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code type}, {@code text}, {@code value}, {@code confirm}, {@code url}, {@code rawStyle}, {@code buttonStyle}, {@code options}, {@code selectedOptions}, {@code dataSource}, {@code minQueryLength}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(name);
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + Objects.hashCode(value);
    h = h * 17 + Objects.hashCode(confirm);
    h = h * 17 + Objects.hashCode(url);
    h = h * 17 + Objects.hashCode(rawStyle);
    h = h * 17 + buttonStyle.hashCode();
    h = h * 17 + options.hashCode();
    h = h * 17 + selectedOptions.hashCode();
    h = h * 17 + Objects.hashCode(dataSource);
    h = h * 17 + Objects.hashCode(minQueryLength);
    return h;
  }

  /**
   * Prints the immutable value {@code Action} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Action{");
    if (name != null) {
      builder.append("name=").append(name);
    }
    if (builder.length() > 7) builder.append(", ");
    builder.append("type=").append(type);
    if (text != null) {
      builder.append(", ");
      builder.append("text=").append(text);
    }
    if (value != null) {
      builder.append(", ");
      builder.append("value=").append(value);
    }
    if (confirm != null) {
      builder.append(", ");
      builder.append("confirm=").append(confirm);
    }
    if (url != null) {
      builder.append(", ");
      builder.append("url=").append(url);
    }
    if (rawStyle != null) {
      builder.append(", ");
      builder.append("rawStyle=").append(rawStyle);
    }
    builder.append(", ");
    builder.append("buttonStyle=").append(buttonStyle);
    builder.append(", ");
    builder.append("options=").append(options);
    builder.append(", ");
    builder.append("selectedOptions=").append(selectedOptions);
    if (dataSource != null) {
      builder.append(", ");
      builder.append("dataSource=").append(dataSource);
    }
    if (minQueryLength != null) {
      builder.append(", ");
      builder.append("minQueryLength=").append(minQueryLength);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ActionIF {
    Optional<String> name = Optional.empty();
    @Nullable ActionType type;
    Optional<String> text = Optional.empty();
    Optional<String> value = Optional.empty();
    Optional<Confirm> confirm = Optional.empty();
    Optional<String> url = Optional.empty();
    Optional<String> rawStyle = Optional.empty();
    List<Option> options = Collections.emptyList();
    List<Option> selectedOptions = Collections.emptyList();
    Optional<SlackDataSource> dataSource = Optional.empty();
    Optional<Integer> minQueryLength = Optional.empty();
    @JsonProperty
    public void setName(Optional<String> name) {
      this.name = name;
    }
    @JsonProperty
    public void setType(ActionType type) {
      this.type = type;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty
    public void setConfirm(Optional<Confirm> confirm) {
      this.confirm = confirm;
    }
    @JsonProperty
    public void setUrl(Optional<String> url) {
      this.url = url;
    }
    @JsonProperty("style")
    public void setRawStyle(Optional<String> rawStyle) {
      this.rawStyle = rawStyle;
    }
    @JsonProperty
    public void setOptions(List<Option> options) {
      this.options = options;
    }
    @JsonProperty
    public void setSelectedOptions(List<Option> selectedOptions) {
      this.selectedOptions = selectedOptions;
    }
    @JsonProperty
    public void setDataSource(Optional<SlackDataSource> dataSource) {
      this.dataSource = dataSource;
    }
    @JsonProperty
    public void setMinQueryLength(Optional<Integer> minQueryLength) {
      this.minQueryLength = minQueryLength;
    }
    @Override
    public Optional<String> getName() { throw new UnsupportedOperationException(); }
    @Override
    public ActionType getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Confirm> getConfirm() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRawStyle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ButtonStyle> getButtonStyle() { throw new UnsupportedOperationException(); }
    @Override
    public List<Option> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public List<Option> getSelectedOptions() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackDataSource> getDataSource() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getMinQueryLength() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Action fromJson(Json json) {
    Action.Builder builder = Action.builder();
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.confirm != null) {
      builder.setConfirm(json.confirm);
    }
    if (json.url != null) {
      builder.setUrl(json.url);
    }
    if (json.rawStyle != null) {
      builder.setRawStyle(json.rawStyle);
    }
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    if (json.selectedOptions != null) {
      builder.addAllSelectedOptions(json.selectedOptions);
    }
    if (json.dataSource != null) {
      builder.setDataSource(json.dataSource);
    }
    if (json.minQueryLength != null) {
      builder.setMinQueryLength(json.minQueryLength);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ActionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Action instance
   */
  public static Action copyOf(ActionIF instance) {
    if (instance instanceof Action) {
      return (Action) instance;
    }
    return Action.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Action Action}.
   * @return A new Action builder
   */
  public static Action.Builder builder() {
    return new Action.Builder();
  }

  /**
   * Builds instances of type {@link Action Action}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String name;
    private @Nullable ActionType type;
    private @Nullable String text;
    private @Nullable String value;
    private @Nullable Confirm confirm;
    private @Nullable String url;
    private @Nullable String rawStyle;
    private List<Option> options = new ArrayList<Option>();
    private List<Option> selectedOptions = new ArrayList<Option>();
    private @Nullable SlackDataSource dataSource;
    private @Nullable Integer minQueryLength;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ActionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ActionIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> nameOptional = instance.getName();
      if (nameOptional.isPresent()) {
        setName(nameOptional);
      }
      setType(instance.getType());
      Optional<String> textOptional = instance.getText();
      if (textOptional.isPresent()) {
        setText(textOptional);
      }
      Optional<String> valueOptional = instance.getValue();
      if (valueOptional.isPresent()) {
        setValue(valueOptional);
      }
      Optional<Confirm> confirmOptional = instance.getConfirm();
      if (confirmOptional.isPresent()) {
        setConfirm(confirmOptional);
      }
      Optional<String> urlOptional = instance.getUrl();
      if (urlOptional.isPresent()) {
        setUrl(urlOptional);
      }
      Optional<String> rawStyleOptional = instance.getRawStyle();
      if (rawStyleOptional.isPresent()) {
        setRawStyle(rawStyleOptional);
      }
      addAllOptions(instance.getOptions());
      addAllSelectedOptions(instance.getSelectedOptions());
      Optional<SlackDataSource> dataSourceOptional = instance.getDataSource();
      if (dataSourceOptional.isPresent()) {
        setDataSource(dataSourceOptional);
      }
      Optional<Integer> minQueryLengthOptional = instance.getMinQueryLength();
      if (minQueryLengthOptional.isPresent()) {
        setMinQueryLength(minQueryLengthOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getName() name} to name.
     * @param name The value for name, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setName(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getName() name} to name.
     * @param name The value for name
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(Optional<String> name) {
      this.name = name.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ActionIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(ActionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getValue() value} to value.
     * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getConfirm() confirm} to confirm.
     * @param confirm The value for confirm, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirm(@Nullable Confirm confirm) {
      this.confirm = confirm;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getConfirm() confirm} to confirm.
     * @param confirm The value for confirm
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirm(Optional<Confirm> confirm) {
      this.confirm = confirm.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getUrl() url} to url.
     * @param url The value for url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUrl(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getUrl() url} to url.
     * @param url The value for url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrl(Optional<String> url) {
      this.url = url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getRawStyle() rawStyle} to rawStyle.
     * @param rawStyle The value for rawStyle, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRawStyle(@Nullable String rawStyle) {
      this.rawStyle = rawStyle;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getRawStyle() rawStyle} to rawStyle.
     * @param rawStyle The value for rawStyle
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRawStyle(Optional<String> rawStyle) {
      this.rawStyle = rawStyle.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ActionIF#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionIF#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option... elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ActionIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends Option> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link ActionIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends Option> elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ActionIF#getSelectedOptions() selectedOptions} list.
     * @param element A selectedOptions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSelectedOptions(Option element) {
      this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionIF#getSelectedOptions() selectedOptions} list.
     * @param elements An array of selectedOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSelectedOptions(Option... elements) {
      for (Option element : elements) {
        this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ActionIF#getSelectedOptions() selectedOptions} list.
     * @param elements An iterable of selectedOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedOptions(Iterable<? extends Option> elements) {
      this.selectedOptions.clear();
      return addAllSelectedOptions(elements);
    }

    /**
     * Adds elements to {@link ActionIF#getSelectedOptions() selectedOptions} list.
     * @param elements An iterable of selectedOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSelectedOptions(Iterable<? extends Option> elements) {
      for (Option element : elements) {
        this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getDataSource() dataSource} to dataSource.
     * @param dataSource The value for dataSource, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setDataSource(@Nullable SlackDataSource dataSource) {
      this.dataSource = dataSource;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getDataSource() dataSource} to dataSource.
     * @param dataSource The value for dataSource
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDataSource(Optional<SlackDataSource> dataSource) {
      this.dataSource = dataSource.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getMinQueryLength() minQueryLength} to minQueryLength.
     * @param minQueryLength The value for minQueryLength, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
      this.minQueryLength = minQueryLength;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionIF#getMinQueryLength() minQueryLength} to minQueryLength.
     * @param minQueryLength The value for minQueryLength
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
      this.minQueryLength = minQueryLength.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Action Action}.
     * @return An immutable instance of Action
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Action build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Action(
          name,
          type,
          text,
          value,
          confirm,
          url,
          rawStyle,
          createUnmodifiableList(true, options),
          createUnmodifiableList(true, selectedOptions),
          dataSource,
          minQueryLength);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build Action, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
