package com.hubspot.slack.client.models.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link IncomingWebhookIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code IncomingWebhook.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "IncomingWebhookIF"})
@Immutable
public final class IncomingWebhook implements IncomingWebhookIF {
  private final String url;
  private final String channel;
  private final String configurationUrl;

  private IncomingWebhook(String url, String channel, String configurationUrl) {
    this.url = url;
    this.channel = channel;
    this.configurationUrl = configurationUrl;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public String getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code configurationUrl} attribute
   */
  @JsonProperty
  @Override
  public String getConfigurationUrl() {
    return configurationUrl;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncomingWebhookIF#getUrl() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param url A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final IncomingWebhook withUrl(String url) {
    if (this.url.equals(url)) return this;
    String newValue = Objects.requireNonNull(url, "url");
    return new IncomingWebhook(newValue, this.channel, this.configurationUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncomingWebhookIF#getChannel() channel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final IncomingWebhook withChannel(String channel) {
    if (this.channel.equals(channel)) return this;
    String newValue = Objects.requireNonNull(channel, "channel");
    return new IncomingWebhook(this.url, newValue, this.configurationUrl);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link IncomingWebhookIF#getConfigurationUrl() configurationUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param configurationUrl A new value for configurationUrl
   * @return A modified copy of the {@code this} object
   */
  public final IncomingWebhook withConfigurationUrl(String configurationUrl) {
    if (this.configurationUrl.equals(configurationUrl)) return this;
    String newValue = Objects.requireNonNull(configurationUrl, "configurationUrl");
    return new IncomingWebhook(this.url, this.channel, newValue);
  }

  /**
   * This instance is equal to all instances of {@code IncomingWebhook} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof IncomingWebhook
        && equalTo((IncomingWebhook) another);
  }

  private boolean equalTo(IncomingWebhook another) {
    return url.equals(another.url)
        && channel.equals(another.channel)
        && configurationUrl.equals(another.configurationUrl);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code channel}, {@code configurationUrl}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + url.hashCode();
    h = h * 17 + channel.hashCode();
    h = h * 17 + configurationUrl.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code IncomingWebhook} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "IncomingWebhook{"
        + "url=" + url
        + ", channel=" + channel
        + ", configurationUrl=" + configurationUrl
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements IncomingWebhookIF {
    @Nullable String url;
    @Nullable String channel;
    @Nullable String configurationUrl;
    @JsonProperty
    public void setUrl(String url) {
      this.url = url;
    }
    @JsonProperty
    public void setChannel(String channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setConfigurationUrl(String configurationUrl) {
      this.configurationUrl = configurationUrl;
    }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public String getConfigurationUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static IncomingWebhook fromJson(Json json) {
    IncomingWebhook.Builder builder = IncomingWebhook.builder();
    if (json.url != null) {
      builder.setUrl(json.url);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.configurationUrl != null) {
      builder.setConfigurationUrl(json.configurationUrl);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link IncomingWebhookIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable IncomingWebhook instance
   */
  public static IncomingWebhook copyOf(IncomingWebhookIF instance) {
    if (instance instanceof IncomingWebhook) {
      return (IncomingWebhook) instance;
    }
    return IncomingWebhook.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link IncomingWebhook IncomingWebhook}.
   * @return A new IncomingWebhook builder
   */
  public static IncomingWebhook.Builder builder() {
    return new IncomingWebhook.Builder();
  }

  /**
   * Builds instances of type {@link IncomingWebhook IncomingWebhook}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private static final long INIT_BIT_CHANNEL = 0x2L;
    private static final long INIT_BIT_CONFIGURATION_URL = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String url;
    private @Nullable String channel;
    private @Nullable String configurationUrl;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code IncomingWebhookIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IncomingWebhookIF instance) {
      Objects.requireNonNull(instance, "instance");
      setUrl(instance.getUrl());
      setChannel(instance.getChannel());
      setConfigurationUrl(instance.getConfigurationUrl());
      return this;
    }

    /**
     * Initializes the value for the {@link IncomingWebhookIF#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrl(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link IncomingWebhookIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(String channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link IncomingWebhookIF#getConfigurationUrl() configurationUrl} attribute.
     * @param configurationUrl The value for configurationUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfigurationUrl(String configurationUrl) {
      this.configurationUrl = Objects.requireNonNull(configurationUrl, "configurationUrl");
      initBits &= ~INIT_BIT_CONFIGURATION_URL;
      return this;
    }

    /**
     * Builds a new {@link IncomingWebhook IncomingWebhook}.
     * @return An immutable instance of IncomingWebhook
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public IncomingWebhook build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new IncomingWebhook(url, channel, configurationUrl);
    }

    private boolean urlIsSet() {
      return (initBits & INIT_BIT_URL) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean configurationUrlIsSet() {
      return (initBits & INIT_BIT_CONFIGURATION_URL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!urlIsSet()) attributes.add("url");
      if (!channelIsSet()) attributes.add("channel");
      if (!configurationUrlIsSet()) attributes.add("configurationUrl");
      return "Cannot build IncomingWebhook, some of required attributes are not set " + attributes;
    }
  }
}
