package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ActionsIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Actions.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Actions.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ActionsIF"})
@Immutable
public final class Actions implements ActionsIF {
  private final String type;
  private final List<BlockElement> elements;
  private final @Nullable String blockId;

  private Actions(Iterable<? extends BlockElement> elements) {
    this.elements = createUnmodifiableList(false, createSafeList(elements, true, false));
    this.blockId = null;
    this.type = Objects.requireNonNull(ActionsIF.super.getType(), "type");
  }

  private Actions(
      List<BlockElement> elements,
      @Nullable String blockId) {
    this.elements = elements;
    this.blockId = blockId;
    this.type = Objects.requireNonNull(ActionsIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @JsonProperty
  @Override
  public List<BlockElement> getElements() {
    return elements;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionsIF#getElements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Actions withElements(BlockElement... elements) {
    List<BlockElement> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Actions(newValue, this.blockId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ActionsIF#getElements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final Actions withElements(Iterable<? extends BlockElement> elements) {
    if (this.elements == elements) return this;
    List<BlockElement> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Actions(newValue, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ActionsIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Actions withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return new Actions(this.elements, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ActionsIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final Actions withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return new Actions(this.elements, value);
  }

  /**
   * This instance is equal to all instances of {@code Actions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Actions
        && equalTo((Actions) another);
  }

  private boolean equalTo(Actions another) {
    return type.equals(another.type)
        && elements.equals(another.elements)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code elements}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + elements.hashCode();
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code Actions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Actions{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("elements=").append(elements);
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ActionsIF {
    List<BlockElement> elements = Collections.emptyList();
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    public void setElements(List<BlockElement> elements) {
      this.elements = elements;
    }
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<BlockElement> getElements() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Actions fromJson(Json json) {
    Actions.Builder builder = Actions.builder();
    if (json.elements != null) {
      builder.addAllElements(json.elements);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Actions} instance.
   * @param elements The value for the {@code elements} attribute
   * @return An immutable Actions instance
   */
  public static Actions of(List<BlockElement> elements) {
    return of((Iterable<? extends BlockElement>) elements);
  }

  /**
   * Construct a new immutable {@code Actions} instance.
   * @param elements The value for the {@code elements} attribute
   * @return An immutable Actions instance
   */
  public static Actions of(Iterable<? extends BlockElement> elements) {
    return new Actions(elements);
  }

  /**
   * Creates an immutable copy of a {@link ActionsIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Actions instance
   */
  public static Actions copyOf(ActionsIF instance) {
    if (instance instanceof Actions) {
      return (Actions) instance;
    }
    return Actions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Actions Actions}.
   * @return A new Actions builder
   */
  public static Actions.Builder builder() {
    return new Actions.Builder();
  }

  /**
   * Builds instances of type {@link Actions Actions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<BlockElement> elements = new ArrayList<BlockElement>();
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.ActionsIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ActionsIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
      if (object instanceof ActionsIF) {
        ActionsIF instance = (ActionsIF) object;
        addAllElements(instance.getElements());
      }
    }

    /**
     * Adds one element to {@link ActionsIF#getElements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElements(BlockElement element) {
      this.elements.add(Objects.requireNonNull(element, "elements element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionsIF#getElements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElements(BlockElement... elements) {
      for (BlockElement element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ActionsIF#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setElements(Iterable<? extends BlockElement> elements) {
      this.elements.clear();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link ActionsIF#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllElements(Iterable<? extends BlockElement> elements) {
      for (BlockElement element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ActionsIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link ActionsIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Actions Actions}.
     * @return An immutable instance of Actions
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Actions build() throws InvalidImmutableStateException {
      return new Actions(createUnmodifiableList(true, elements), blockId);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
