package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.json.ImageBlockOrTextDeserializer;
import com.hubspot.slack.client.models.blocks.objects.ImageBlockOrText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ContextIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Context.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Context.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ContextIF"})
@Immutable
public final class Context implements ContextIF {
  private final String type;
  private final List<ImageBlockOrText> elements;
  private final @Nullable String blockId;

  private Context(Iterable<? extends ImageBlockOrText> elements) {
    this.elements = createUnmodifiableList(false, createSafeList(elements, true, false));
    this.blockId = null;
    this.type = Objects.requireNonNull(ContextIF.super.getType(), "type");
  }

  private Context(
      List<ImageBlockOrText> elements,
      @Nullable String blockId) {
    this.elements = elements;
    this.blockId = blockId;
    this.type = Objects.requireNonNull(ContextIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @JsonProperty
  @JsonDeserialize(contentUsing = ImageBlockOrTextDeserializer.class)
  @Override
  public List<ImageBlockOrText> getElements() {
    return elements;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContextIF#getElements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Context withElements(ImageBlockOrText... elements) {
    List<ImageBlockOrText> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Context(newValue, this.blockId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ContextIF#getElements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final Context withElements(Iterable<? extends ImageBlockOrText> elements) {
    if (this.elements == elements) return this;
    List<ImageBlockOrText> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Context(newValue, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ContextIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Context withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return new Context(this.elements, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ContextIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final Context withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return new Context(this.elements, value);
  }

  /**
   * This instance is equal to all instances of {@code Context} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Context
        && equalTo((Context) another);
  }

  private boolean equalTo(Context another) {
    return type.equals(another.type)
        && elements.equals(another.elements)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code elements}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + elements.hashCode();
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code Context} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Context{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("elements=").append(elements);
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ContextIF {
    List<ImageBlockOrText> elements = Collections.emptyList();
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    @JsonDeserialize(contentUsing = ImageBlockOrTextDeserializer.class)
    public void setElements(List<ImageBlockOrText> elements) {
      this.elements = elements;
    }
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<ImageBlockOrText> getElements() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Context fromJson(Json json) {
    Context.Builder builder = Context.builder();
    if (json.elements != null) {
      builder.addAllElements(json.elements);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Context} instance.
   * @param elements The value for the {@code elements} attribute
   * @return An immutable Context instance
   */
  public static Context of(List<ImageBlockOrText> elements) {
    return of((Iterable<? extends ImageBlockOrText>) elements);
  }

  /**
   * Construct a new immutable {@code Context} instance.
   * @param elements The value for the {@code elements} attribute
   * @return An immutable Context instance
   */
  public static Context of(Iterable<? extends ImageBlockOrText> elements) {
    return new Context(elements);
  }

  /**
   * Creates an immutable copy of a {@link ContextIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Context instance
   */
  public static Context copyOf(ContextIF instance) {
    if (instance instanceof Context) {
      return (Context) instance;
    }
    return Context.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Context Context}.
   * @return A new Context builder
   */
  public static Context.Builder builder() {
    return new Context.Builder();
  }

  /**
   * Builds instances of type {@link Context Context}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<ImageBlockOrText> elements = new ArrayList<ImageBlockOrText>();
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.ContextIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContextIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
      if (object instanceof ContextIF) {
        ContextIF instance = (ContextIF) object;
        addAllElements(instance.getElements());
      }
    }

    /**
     * Adds one element to {@link ContextIF#getElements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElements(ImageBlockOrText element) {
      this.elements.add(Objects.requireNonNull(element, "elements element"));
      return this;
    }

    /**
     * Adds elements to {@link ContextIF#getElements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElements(ImageBlockOrText... elements) {
      for (ImageBlockOrText element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ContextIF#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setElements(Iterable<? extends ImageBlockOrText> elements) {
      this.elements.clear();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link ContextIF#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllElements(Iterable<? extends ImageBlockOrText> elements) {
      for (ImageBlockOrText element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ContextIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link ContextIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Context Context}.
     * @return An immutable instance of Context
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Context build() throws InvalidImmutableStateException {
      return new Context(createUnmodifiableList(true, elements), blockId);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
