package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link DividerIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Divider.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "DividerIF"})
@Immutable
public final class Divider implements DividerIF {
  private final String type;
  private final @Nullable String blockId;

  private Divider(@Nullable String blockId) {
    this.blockId = blockId;
    this.type = Objects.requireNonNull(DividerIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link DividerIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Divider withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return new Divider(newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link DividerIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final Divider withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return new Divider(value);
  }

  /**
   * This instance is equal to all instances of {@code Divider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Divider
        && equalTo((Divider) another);
  }

  private boolean equalTo(Divider another) {
    return type.equals(another.type)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code Divider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Divider{");
    builder.append("type=").append(type);
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements DividerIF {
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Divider fromJson(Json json) {
    Divider.Builder builder = Divider.builder();
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link DividerIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Divider instance
   */
  public static Divider copyOf(DividerIF instance) {
    if (instance instanceof Divider) {
      return (Divider) instance;
    }
    return Divider.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Divider Divider}.
   * @return A new Divider builder
   */
  public static Divider.Builder builder() {
    return new Divider.Builder();
  }

  /**
   * Builds instances of type {@link Divider Divider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.DividerIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DividerIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
    }

    /**
     * Initializes the optional value {@link DividerIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link DividerIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Divider Divider}.
     * @return An immutable instance of Divider
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Divider build() throws InvalidImmutableStateException {
      return new Divider(blockId);
    }
  }
}
