package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link FileIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code File.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code File.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "FileIF"})
@Immutable
public final class File implements FileIF {
  private final String type;
  private final String externalId;
  private final String source;
  private final @Nullable String blockId;

  private File(String externalId, String source) {
    this.externalId = Objects.requireNonNull(externalId, "externalId");
    this.source = Objects.requireNonNull(source, "source");
    this.blockId = null;
    this.type = Objects.requireNonNull(FileIF.super.getType(), "type");
  }

  private File(
      String externalId,
      String source,
      @Nullable String blockId) {
    this.externalId = externalId;
    this.source = source;
    this.blockId = blockId;
    this.type = Objects.requireNonNull(FileIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty
  @Override
  public String getExternalId() {
    return externalId;
  }

  /**
   * @return The value of the {@code source} attribute
   */
  @JsonProperty
  @Override
  public String getSource() {
    return source;
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileIF#getExternalId() externalId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param externalId A new value for externalId
   * @return A modified copy of the {@code this} object
   */
  public final File withExternalId(String externalId) {
    if (this.externalId.equals(externalId)) return this;
    String newValue = Objects.requireNonNull(externalId, "externalId");
    return new File(newValue, this.source, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FileIF#getSource() source} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param source A new value for source
   * @return A modified copy of the {@code this} object
   */
  public final File withSource(String source) {
    if (this.source.equals(source)) return this;
    String newValue = Objects.requireNonNull(source, "source");
    return new File(this.externalId, newValue, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link FileIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final File withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return new File(this.externalId, this.source, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link FileIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final File withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return new File(this.externalId, this.source, value);
  }

  /**
   * This instance is equal to all instances of {@code File} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof File
        && equalTo((File) another);
  }

  private boolean equalTo(File another) {
    return type.equals(another.type)
        && externalId.equals(another.externalId)
        && source.equals(another.source)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code externalId}, {@code source}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + externalId.hashCode();
    h = h * 17 + source.hashCode();
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code File} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("File{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("externalId=").append(externalId);
    builder.append(", ");
    builder.append("source=").append(source);
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FileIF {
    @Nullable String externalId;
    @Nullable String source;
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    public void setExternalId(String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty
    public void setSource(String source) {
      this.source = source;
    }
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSource() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static File fromJson(Json json) {
    File.Builder builder = File.builder();
    if (json.externalId != null) {
      builder.setExternalId(json.externalId);
    }
    if (json.source != null) {
      builder.setSource(json.source);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code File} instance.
   * @param externalId The value for the {@code externalId} attribute
   * @param source The value for the {@code source} attribute
   * @return An immutable File instance
   */
  public static File of(String externalId, String source) {
    return new File(externalId, source);
  }

  /**
   * Creates an immutable copy of a {@link FileIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable File instance
   */
  public static File copyOf(FileIF instance) {
    if (instance instanceof File) {
      return (File) instance;
    }
    return File.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link File File}.
   * @return A new File builder
   */
  public static File.Builder builder() {
    return new File.Builder();
  }

  /**
   * Builds instances of type {@link File File}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_ID = 0x1L;
    private static final long INIT_BIT_SOURCE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String externalId;
    private @Nullable String source;
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.FileIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FileIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
      if (object instanceof FileIF) {
        FileIF instance = (FileIF) object;
        setExternalId(instance.getExternalId());
        setSource(instance.getSource());
      }
    }

    /**
     * Initializes the value for the {@link FileIF#getExternalId() externalId} attribute.
     * @param externalId The value for externalId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternalId(String externalId) {
      this.externalId = Objects.requireNonNull(externalId, "externalId");
      initBits &= ~INIT_BIT_EXTERNAL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link FileIF#getSource() source} attribute.
     * @param source The value for source 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSource(String source) {
      this.source = Objects.requireNonNull(source, "source");
      initBits &= ~INIT_BIT_SOURCE;
      return this;
    }

    /**
     * Initializes the optional value {@link FileIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link FileIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link File File}.
     * @return An immutable instance of File
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public File build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new File(externalId, source, blockId);
    }

    private boolean externalIdIsSet() {
      return (initBits & INIT_BIT_EXTERNAL_ID) == 0;
    }

    private boolean sourceIsSet() {
      return (initBits & INIT_BIT_SOURCE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!externalIdIsSet()) attributes.add("externalId");
      if (!sourceIsSet()) attributes.add("source");
      return "Cannot build File, some of required attributes are not set " + attributes;
    }
  }
}
