package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ImageIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Image.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Image.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ImageIF"})
@Immutable
public final class Image implements ImageIF {
  private final String type;
  private final String imageUrl;
  private final String altText;
  private final @Nullable Text title;
  private final @Nullable String blockId;

  private Image(String imageUrl, String altText) {
    this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
    this.altText = Objects.requireNonNull(altText, "altText");
    this.title = null;
    this.blockId = null;
    this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
  }

  private Image(
      String imageUrl,
      String altText,
      @Nullable Text title,
      @Nullable String blockId) {
    this.imageUrl = imageUrl;
    this.altText = altText;
    this.title = title;
    this.blockId = blockId;
    this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code imageUrl} attribute
   */
  @JsonProperty
  @Override
  public String getImageUrl() {
    return imageUrl;
  }

  /**
   * @return The value of the {@code altText} attribute
   */
  @JsonProperty
  @Override
  public String getAltText() {
    return altText;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public Optional<Text> getTitle() {
    return Optional.ofNullable(title);
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageIF#getImageUrl() imageUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param imageUrl A new value for imageUrl
   * @return A modified copy of the {@code this} object
   */
  public final Image withImageUrl(String imageUrl) {
    if (this.imageUrl.equals(imageUrl)) return this;
    String newValue = Objects.requireNonNull(imageUrl, "imageUrl");
    return new Image(newValue, this.altText, this.title, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageIF#getAltText() altText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param altText A new value for altText
   * @return A modified copy of the {@code this} object
   */
  public final Image withAltText(String altText) {
    if (this.altText.equals(altText)) return this;
    String newValue = Objects.requireNonNull(altText, "altText");
    return new Image(this.imageUrl, newValue, this.title, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ImageIF#getTitle() title} attribute.
   * @param value The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Image withTitle(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.title == newValue) return this;
    return new Image(this.imageUrl, this.altText, newValue, this.blockId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ImageIF#getTitle() title} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for title
   * @return A modified copy of {@code this} object
   */
  public final Image withTitle(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.title == value) return this;
    return new Image(this.imageUrl, this.altText, value, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ImageIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Image withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return new Image(this.imageUrl, this.altText, this.title, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ImageIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final Image withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return new Image(this.imageUrl, this.altText, this.title, value);
  }

  /**
   * This instance is equal to all instances of {@code Image} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Image
        && equalTo((Image) another);
  }

  private boolean equalTo(Image another) {
    return type.equals(another.type)
        && imageUrl.equals(another.imageUrl)
        && altText.equals(another.altText)
        && Objects.equals(title, another.title)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code imageUrl}, {@code altText}, {@code title}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + imageUrl.hashCode();
    h = h * 17 + altText.hashCode();
    h = h * 17 + Objects.hashCode(title);
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code Image} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Image{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("imageUrl=").append(imageUrl);
    builder.append(", ");
    builder.append("altText=").append(altText);
    if (title != null) {
      builder.append(", ");
      builder.append("title=").append(title);
    }
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ImageIF {
    @Nullable String imageUrl;
    @Nullable String altText;
    Optional<Text> title = Optional.empty();
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    public void setImageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
    }
    @JsonProperty
    public void setAltText(String altText) {
      this.altText = altText;
    }
    @JsonProperty
    public void setTitle(Optional<Text> title) {
      this.title = title;
    }
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getImageUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getAltText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Image fromJson(Json json) {
    Image.Builder builder = Image.builder();
    if (json.imageUrl != null) {
      builder.setImageUrl(json.imageUrl);
    }
    if (json.altText != null) {
      builder.setAltText(json.altText);
    }
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Image} instance.
   * @param imageUrl The value for the {@code imageUrl} attribute
   * @param altText The value for the {@code altText} attribute
   * @return An immutable Image instance
   */
  public static Image of(String imageUrl, String altText) {
    return new Image(imageUrl, altText);
  }

  /**
   * Creates an immutable copy of a {@link ImageIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Image instance
   */
  public static Image copyOf(ImageIF instance) {
    if (instance instanceof Image) {
      return (Image) instance;
    }
    return Image.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Image Image}.
   * @return A new Image builder
   */
  public static Image.Builder builder() {
    return new Image.Builder();
  }

  /**
   * Builds instances of type {@link Image Image}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IMAGE_URL = 0x1L;
    private static final long INIT_BIT_ALT_TEXT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String imageUrl;
    private @Nullable String altText;
    private @Nullable Text title;
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.ImageIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImageIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ImageIF) {
        ImageIF instance = (ImageIF) object;
        setAltText(instance.getAltText());
        Optional<Text> titleOptional = instance.getTitle();
        if (titleOptional.isPresent()) {
          setTitle(titleOptional);
        }
        setImageUrl(instance.getImageUrl());
      }
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link ImageIF#getImageUrl() imageUrl} attribute.
     * @param imageUrl The value for imageUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImageUrl(String imageUrl) {
      this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
      initBits &= ~INIT_BIT_IMAGE_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageIF#getAltText() altText} attribute.
     * @param altText The value for altText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAltText(String altText) {
      this.altText = Objects.requireNonNull(altText, "altText");
      initBits &= ~INIT_BIT_ALT_TEXT;
      return this;
    }

    /**
     * Initializes the optional value {@link ImageIF#getTitle() title} to title.
     * @param title The value for title, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setTitle(@Nullable Text title) {
      this.title = title;
      return this;
    }

    /**
     * Initializes the optional value {@link ImageIF#getTitle() title} to title.
     * @param title The value for title
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(Optional<Text> title) {
      this.title = title.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ImageIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link ImageIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Image Image}.
     * @return An immutable instance of Image
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Image build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Image(imageUrl, altText, title, blockId);
    }

    private boolean imageUrlIsSet() {
      return (initBits & INIT_BIT_IMAGE_URL) == 0;
    }

    private boolean altTextIsSet() {
      return (initBits & INIT_BIT_ALT_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!imageUrlIsSet()) attributes.add("imageUrl");
      if (!altTextIsSet()) attributes.add("altText");
      return "Cannot build Image, some of required attributes are not set " + attributes;
    }
  }
}
