package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SectionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Section.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Section.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SectionIF"})
@Immutable
public final class Section implements SectionIF {
  private final String type;
  private final Text text;
  private final List<Text> fields;
  private final @Nullable BlockElement accessory;
  private final @Nullable String blockId;

  private Section(Text text) {
    this.text = Objects.requireNonNull(text, "text");
    this.fields = Collections.emptyList();
    this.accessory = null;
    this.blockId = null;
    this.type = Objects.requireNonNull(SectionIF.super.getType(), "type");
  }

  private Section(
      Text text,
      List<Text> fields,
      @Nullable BlockElement accessory,
      @Nullable String blockId) {
    this.text = text;
    this.fields = fields;
    this.accessory = accessory;
    this.blockId = blockId;
    this.type = Objects.requireNonNull(SectionIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Text getText() {
    return text;
  }

  /**
   * @return The value of the {@code fields} attribute
   */
  @JsonProperty
  @Override
  public List<Text> getFields() {
    return fields;
  }

  /**
   * @return The value of the {@code accessory} attribute
   */
  @JsonProperty
  @Override
  public Optional<BlockElement> getAccessory() {
    return Optional.ofNullable(accessory);
  }

  /**
   * @return The value of the {@code blockId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getBlockId() {
    return Optional.ofNullable(blockId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SectionIF#getText() text} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final Section withText(Text text) {
    if (this.text == text) return this;
    Text newValue = Objects.requireNonNull(text, "text");
    return new Section(newValue, this.fields, this.accessory, this.blockId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SectionIF#getFields() fields}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final Section withFields(Text... elements) {
    List<Text> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new Section(this.text, newValue, this.accessory, this.blockId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SectionIF#getFields() fields}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fields elements to set
   * @return A modified copy of {@code this} object
   */
  public final Section withFields(Iterable<? extends Text> elements) {
    if (this.fields == elements) return this;
    List<Text> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new Section(this.text, newValue, this.accessory, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SectionIF#getAccessory() accessory} attribute.
   * @param value The value for accessory, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Section withAccessory(@Nullable BlockElement value) {
    @Nullable BlockElement newValue = value;
    if (this.accessory == newValue) return this;
    return new Section(this.text, this.fields, newValue, this.blockId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SectionIF#getAccessory() accessory} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for accessory
   * @return A modified copy of {@code this} object
   */
  public final Section withAccessory(Optional<BlockElement> optional) {
    @Nullable BlockElement value = optional.orElse(null);
    if (this.accessory == value) return this;
    return new Section(this.text, this.fields, value, this.blockId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SectionIF#getBlockId() blockId} attribute.
   * @param value The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Section withBlockId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.blockId, newValue)) return this;
    return new Section(this.text, this.fields, this.accessory, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SectionIF#getBlockId() blockId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for blockId
   * @return A modified copy of {@code this} object
   */
  public final Section withBlockId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.blockId, value)) return this;
    return new Section(this.text, this.fields, this.accessory, value);
  }

  /**
   * This instance is equal to all instances of {@code Section} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Section
        && equalTo((Section) another);
  }

  private boolean equalTo(Section another) {
    return type.equals(another.type)
        && text.equals(another.text)
        && fields.equals(another.fields)
        && Objects.equals(accessory, another.accessory)
        && Objects.equals(blockId, another.blockId);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code text}, {@code fields}, {@code accessory}, {@code blockId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + fields.hashCode();
    h = h * 17 + Objects.hashCode(accessory);
    h = h * 17 + Objects.hashCode(blockId);
    return h;
  }

  /**
   * Prints the immutable value {@code Section} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Section{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("fields=").append(fields);
    if (accessory != null) {
      builder.append(", ");
      builder.append("accessory=").append(accessory);
    }
    if (blockId != null) {
      builder.append(", ");
      builder.append("blockId=").append(blockId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SectionIF {
    @Nullable Text text;
    List<Text> fields = Collections.emptyList();
    Optional<BlockElement> accessory = Optional.empty();
    Optional<String> blockId = Optional.empty();
    @JsonProperty
    public void setText(Text text) {
      this.text = text;
    }
    @JsonProperty
    public void setFields(List<Text> fields) {
      this.fields = fields;
    }
    @JsonProperty
    public void setAccessory(Optional<BlockElement> accessory) {
      this.accessory = accessory;
    }
    @JsonProperty
    public void setBlockId(Optional<String> blockId) {
      this.blockId = blockId;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getText() { throw new UnsupportedOperationException(); }
    @Override
    public List<Text> getFields() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<BlockElement> getAccessory() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getBlockId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Section fromJson(Json json) {
    Section.Builder builder = Section.builder();
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.fields != null) {
      builder.addAllFields(json.fields);
    }
    if (json.accessory != null) {
      builder.setAccessory(json.accessory);
    }
    if (json.blockId != null) {
      builder.setBlockId(json.blockId);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Section} instance.
   * @param text The value for the {@code text} attribute
   * @return An immutable Section instance
   */
  public static Section of(Text text) {
    return new Section(text);
  }

  /**
   * Creates an immutable copy of a {@link SectionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Section instance
   */
  public static Section copyOf(SectionIF instance) {
    if (instance instanceof Section) {
      return (Section) instance;
    }
    return Section.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Section Section}.
   * @return A new Section builder
   */
  public static Section.Builder builder() {
    return new Section.Builder();
  }

  /**
   * Builds instances of type {@link Section Section}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEXT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Text text;
    private List<Text> fields = new ArrayList<Text>();
    private @Nullable BlockElement accessory;
    private @Nullable String blockId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.Block} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Block instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.blocks.SectionIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SectionIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Block) {
        Block instance = (Block) object;
        Optional<String> blockIdOptional = instance.getBlockId();
        if (blockIdOptional.isPresent()) {
          setBlockId(blockIdOptional);
        }
      }
      if (object instanceof SectionIF) {
        SectionIF instance = (SectionIF) object;
        addAllFields(instance.getFields());
        Optional<BlockElement> accessoryOptional = instance.getAccessory();
        if (accessoryOptional.isPresent()) {
          setAccessory(accessoryOptional);
        }
        setText(instance.getText());
      }
    }

    /**
     * Initializes the value for the {@link SectionIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Text text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Adds one element to {@link SectionIF#getFields() fields} list.
     * @param element A fields element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Text element) {
      this.fields.add(Objects.requireNonNull(element, "fields element"));
      return this;
    }

    /**
     * Adds elements to {@link SectionIF#getFields() fields} list.
     * @param elements An array of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFields(Text... elements) {
      for (Text element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SectionIF#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFields(Iterable<? extends Text> elements) {
      this.fields.clear();
      return addAllFields(elements);
    }

    /**
     * Adds elements to {@link SectionIF#getFields() fields} list.
     * @param elements An iterable of fields elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllFields(Iterable<? extends Text> elements) {
      for (Text element : elements) {
        this.fields.add(Objects.requireNonNull(element, "fields element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link SectionIF#getAccessory() accessory} to accessory.
     * @param accessory The value for accessory, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setAccessory(@Nullable BlockElement accessory) {
      this.accessory = accessory;
      return this;
    }

    /**
     * Initializes the optional value {@link SectionIF#getAccessory() accessory} to accessory.
     * @param accessory The value for accessory
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAccessory(Optional<BlockElement> accessory) {
      this.accessory = accessory.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SectionIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setBlockId(@Nullable String blockId) {
      this.blockId = blockId;
      return this;
    }

    /**
     * Initializes the optional value {@link SectionIF#getBlockId() blockId} to blockId.
     * @param blockId The value for blockId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBlockId(Optional<String> blockId) {
      this.blockId = blockId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Section Section}.
     * @return An immutable instance of Section
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Section build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Section(text, createUnmodifiableList(true, fields), accessory, blockId);
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!textIsSet()) attributes.add("text");
      return "Cannot build Section, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
