package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChannelSelectMenuIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChannelSelectMenu.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ChannelSelectMenu.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChannelSelectMenuIF"})
@Immutable
public final class ChannelSelectMenu
    implements ChannelSelectMenuIF {
  private final String type;
  private final Text placeholder;
  private final String actionId;
  private final @Nullable String initialChannelId;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private ChannelSelectMenu(Text placeholder, String actionId) {
    this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.initialChannelId = null;
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(ChannelSelectMenuIF.super.getType(), "type");
  }

  private ChannelSelectMenu(
      Text placeholder,
      String actionId,
      @Nullable String initialChannelId,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.placeholder = placeholder;
    this.actionId = actionId;
    this.initialChannelId = initialChannelId;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(ChannelSelectMenuIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Text getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code initialChannelId} attribute
   */
  @JsonProperty("initial_channel")
  @Override
  public Optional<String> getInitialChannelId() {
    return Optional.ofNullable(initialChannelId);
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChannelSelectMenuIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param placeholder A new value for placeholder
   * @return A modified copy of the {@code this} object
   */
  public final ChannelSelectMenu withPlaceholder(Text placeholder) {
    if (this.placeholder == placeholder) return this;
    Text newValue = Objects.requireNonNull(placeholder, "placeholder");
    return new ChannelSelectMenu(newValue, this.actionId, this.initialChannelId, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChannelSelectMenuIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final ChannelSelectMenu withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new ChannelSelectMenu(this.placeholder, newValue, this.initialChannelId, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChannelSelectMenuIF#getInitialChannelId() initialChannelId} attribute.
   * @param value The value for initialChannelId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelSelectMenu withInitialChannelId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.initialChannelId, newValue)) return this;
    return new ChannelSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChannelSelectMenuIF#getInitialChannelId() initialChannelId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialChannelId
   * @return A modified copy of {@code this} object
   */
  public final ChannelSelectMenu withInitialChannelId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.initialChannelId, value)) return this;
    return new ChannelSelectMenu(this.placeholder, this.actionId, value, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChannelSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChannelSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new ChannelSelectMenu(this.placeholder, this.actionId, this.initialChannelId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChannelSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final ChannelSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new ChannelSelectMenu(this.placeholder, this.actionId, this.initialChannelId, value);
  }

  /**
   * This instance is equal to all instances of {@code ChannelSelectMenu} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChannelSelectMenu
        && equalTo((ChannelSelectMenu) another);
  }

  private boolean equalTo(ChannelSelectMenu another) {
    return type.equals(another.type)
        && placeholder.equals(another.placeholder)
        && actionId.equals(another.actionId)
        && Objects.equals(initialChannelId, another.initialChannelId)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code placeholder}, {@code actionId}, {@code initialChannelId}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + placeholder.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + Objects.hashCode(initialChannelId);
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code ChannelSelectMenu} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChannelSelectMenu{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("placeholder=").append(placeholder);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    if (initialChannelId != null) {
      builder.append(", ");
      builder.append("initialChannelId=").append(initialChannelId);
    }
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChannelSelectMenuIF {
    @Nullable Text placeholder;
    @Nullable String actionId;
    Optional<String> initialChannelId = Optional.empty();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setPlaceholder(Text placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty("initial_channel")
    public void setInitialChannelId(Optional<String> initialChannelId) {
      this.initialChannelId = initialChannelId;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInitialChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChannelSelectMenu fromJson(Json json) {
    ChannelSelectMenu.Builder builder = ChannelSelectMenu.builder();
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.initialChannelId != null) {
      builder.setInitialChannelId(json.initialChannelId);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code ChannelSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @return An immutable ChannelSelectMenu instance
   */
  public static ChannelSelectMenu of(Text placeholder, String actionId) {
    return new ChannelSelectMenu(placeholder, actionId);
  }

  /**
   * Creates an immutable copy of a {@link ChannelSelectMenuIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChannelSelectMenu instance
   */
  public static ChannelSelectMenu copyOf(ChannelSelectMenuIF instance) {
    if (instance instanceof ChannelSelectMenu) {
      return (ChannelSelectMenu) instance;
    }
    return ChannelSelectMenu.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChannelSelectMenu ChannelSelectMenu}.
   * @return A new ChannelSelectMenu builder
   */
  public static ChannelSelectMenu.Builder builder() {
    return new ChannelSelectMenu.Builder();
  }

  /**
   * Builds instances of type {@link ChannelSelectMenu ChannelSelectMenu}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PLACEHOLDER = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text placeholder;
    private @Nullable String actionId;
    private @Nullable String initialChannelId;
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChannelSelectMenuIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChannelSelectMenuIF instance) {
      Objects.requireNonNull(instance, "instance");
      setPlaceholder(instance.getPlaceholder());
      setActionId(instance.getActionId());
      Optional<String> initialChannelIdOptional = instance.getInitialChannelId();
      if (initialChannelIdOptional.isPresent()) {
        setInitialChannelId(initialChannelIdOptional);
      }
      Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
      if (confirmationDialogOptional.isPresent()) {
        setConfirmationDialog(confirmationDialogOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ChannelSelectMenuIF#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Text placeholder) {
      this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
      initBits &= ~INIT_BIT_PLACEHOLDER;
      return this;
    }

    /**
     * Initializes the value for the {@link ChannelSelectMenuIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelSelectMenuIF#getInitialChannelId() initialChannelId} to initialChannelId.
     * @param initialChannelId The value for initialChannelId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialChannelId(@Nullable String initialChannelId) {
      this.initialChannelId = initialChannelId;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelSelectMenuIF#getInitialChannelId() initialChannelId} to initialChannelId.
     * @param initialChannelId The value for initialChannelId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialChannelId(Optional<String> initialChannelId) {
      this.initialChannelId = initialChannelId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link ChannelSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChannelSelectMenu ChannelSelectMenu}.
     * @return An immutable instance of ChannelSelectMenu
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChannelSelectMenu build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChannelSelectMenu(placeholder, actionId, initialChannelId, confirmationDialog);
    }

    private boolean placeholderIsSet() {
      return (initBits & INIT_BIT_PLACEHOLDER) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!placeholderIsSet()) attributes.add("placeholder");
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build ChannelSelectMenu, some of required attributes are not set " + attributes;
    }
  }
}
