package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ImageIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Image.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Image.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ImageIF"})
@Immutable
public final class Image implements ImageIF {
  private final String type;
  private final String imageUrl;
  private final String altText;

  private Image(String imageUrl, String altText) {
    this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
    this.altText = Objects.requireNonNull(altText, "altText");
    this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
  }

  private Image(Image original, String imageUrl, String altText) {
    this.imageUrl = imageUrl;
    this.altText = altText;
    this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code imageUrl} attribute
   */
  @JsonProperty
  @Override
  public String getImageUrl() {
    return imageUrl;
  }

  /**
   * @return The value of the {@code altText} attribute
   */
  @JsonProperty
  @Override
  public String getAltText() {
    return altText;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageIF#getImageUrl() imageUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param imageUrl A new value for imageUrl
   * @return A modified copy of the {@code this} object
   */
  public final Image withImageUrl(String imageUrl) {
    if (this.imageUrl.equals(imageUrl)) return this;
    String newValue = Objects.requireNonNull(imageUrl, "imageUrl");
    return new Image(this, newValue, this.altText);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImageIF#getAltText() altText} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param altText A new value for altText
   * @return A modified copy of the {@code this} object
   */
  public final Image withAltText(String altText) {
    if (this.altText.equals(altText)) return this;
    String newValue = Objects.requireNonNull(altText, "altText");
    return new Image(this, this.imageUrl, newValue);
  }

  /**
   * This instance is equal to all instances of {@code Image} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Image
        && equalTo((Image) another);
  }

  private boolean equalTo(Image another) {
    return type.equals(another.type)
        && imageUrl.equals(another.imageUrl)
        && altText.equals(another.altText);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code imageUrl}, {@code altText}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + imageUrl.hashCode();
    h = h * 17 + altText.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Image} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Image{"
        + "type=" + type
        + ", imageUrl=" + imageUrl
        + ", altText=" + altText
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ImageIF {
    @Nullable String imageUrl;
    @Nullable String altText;
    @JsonProperty
    public void setImageUrl(String imageUrl) {
      this.imageUrl = imageUrl;
    }
    @JsonProperty
    public void setAltText(String altText) {
      this.altText = altText;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getImageUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getAltText() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Image fromJson(Json json) {
    Image.Builder builder = Image.builder();
    if (json.imageUrl != null) {
      builder.setImageUrl(json.imageUrl);
    }
    if (json.altText != null) {
      builder.setAltText(json.altText);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Image} instance.
   * @param imageUrl The value for the {@code imageUrl} attribute
   * @param altText The value for the {@code altText} attribute
   * @return An immutable Image instance
   */
  public static Image of(String imageUrl, String altText) {
    return new Image(imageUrl, altText);
  }

  /**
   * Creates an immutable copy of a {@link ImageIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Image instance
   */
  public static Image copyOf(ImageIF instance) {
    if (instance instanceof Image) {
      return (Image) instance;
    }
    return Image.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Image Image}.
   * @return A new Image builder
   */
  public static Image.Builder builder() {
    return new Image.Builder();
  }

  /**
   * Builds instances of type {@link Image Image}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IMAGE_URL = 0x1L;
    private static final long INIT_BIT_ALT_TEXT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String imageUrl;
    private @Nullable String altText;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ImageIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImageIF instance) {
      Objects.requireNonNull(instance, "instance");
      setImageUrl(instance.getImageUrl());
      setAltText(instance.getAltText());
      return this;
    }

    /**
     * Initializes the value for the {@link ImageIF#getImageUrl() imageUrl} attribute.
     * @param imageUrl The value for imageUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImageUrl(String imageUrl) {
      this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
      initBits &= ~INIT_BIT_IMAGE_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link ImageIF#getAltText() altText} attribute.
     * @param altText The value for altText 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAltText(String altText) {
      this.altText = Objects.requireNonNull(altText, "altText");
      initBits &= ~INIT_BIT_ALT_TEXT;
      return this;
    }

    /**
     * Builds a new {@link Image Image}.
     * @return An immutable instance of Image
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Image build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Image(null, imageUrl, altText);
    }

    private boolean imageUrlIsSet() {
      return (initBits & INIT_BIT_IMAGE_URL) == 0;
    }

    private boolean altTextIsSet() {
      return (initBits & INIT_BIT_ALT_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!imageUrlIsSet()) attributes.add("imageUrl");
      if (!altTextIsSet()) attributes.add("altText");
      return "Cannot build Image, some of required attributes are not set " + attributes;
    }
  }
}
