package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PlainTextInputIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PlainTextInput.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code PlainTextInput.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PlainTextInputIF"})
@Immutable
public final class PlainTextInput implements PlainTextInputIF {
  private final String type;
  private final String actionId;
  private final @Nullable Text placeholder;
  private final @Nullable String initialValue;
  private final @Nullable Boolean multiline;
  private final @Nullable Integer minLength;
  private final @Nullable Integer maxLength;

  private PlainTextInput(String actionId) {
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.placeholder = null;
    this.initialValue = null;
    this.multiline = null;
    this.minLength = null;
    this.maxLength = null;
    this.type = Objects.requireNonNull(PlainTextInputIF.super.getType(), "type");
  }

  private PlainTextInput(
      String actionId,
      @Nullable Text placeholder,
      @Nullable String initialValue,
      @Nullable Boolean multiline,
      @Nullable Integer minLength,
      @Nullable Integer maxLength) {
    this.actionId = actionId;
    this.placeholder = placeholder;
    this.initialValue = initialValue;
    this.multiline = multiline;
    this.minLength = minLength;
    this.maxLength = maxLength;
    this.type = Objects.requireNonNull(PlainTextInputIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Optional<Text> getPlaceholder() {
    return Optional.ofNullable(placeholder);
  }

  /**
   * @return The value of the {@code initialValue} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getInitialValue() {
    return Optional.ofNullable(initialValue);
  }

  /**
   * @return The value of the {@code multiline} attribute
   */
  @JsonProperty("multiline")
  @Override
  public Optional<Boolean> isMultiline() {
    return Optional.ofNullable(multiline);
  }

  /**
   * @return The value of the {@code minLength} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getMinLength() {
    return Optional.ofNullable(minLength);
  }

  /**
   * @return The value of the {@code maxLength} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getMaxLength() {
    return Optional.ofNullable(maxLength);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PlainTextInputIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final PlainTextInput withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new PlainTextInput(newValue, this.placeholder, this.initialValue, this.multiline, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlainTextInputIF#getPlaceholder() placeholder} attribute.
   * @param value The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withPlaceholder(@Nullable Text value) {
    @Nullable Text newValue = value;
    if (this.placeholder == newValue) return this;
    return new PlainTextInput(this.actionId, newValue, this.initialValue, this.multiline, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlainTextInputIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for placeholder
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withPlaceholder(Optional<Text> optional) {
    @Nullable Text value = optional.orElse(null);
    if (this.placeholder == value) return this;
    return new PlainTextInput(this.actionId, value, this.initialValue, this.multiline, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlainTextInputIF#getInitialValue() initialValue} attribute.
   * @param value The value for initialValue, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withInitialValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.initialValue, newValue)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, newValue, this.multiline, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlainTextInputIF#getInitialValue() initialValue} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialValue
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withInitialValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.initialValue, value)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, value, this.multiline, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlainTextInputIF#isMultiline() multiline} attribute.
   * @param value The value for multiline, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withMultiline(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.multiline, newValue)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, this.initialValue, newValue, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlainTextInputIF#isMultiline() multiline} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for multiline
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withMultiline(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.multiline, value)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, this.initialValue, value, this.minLength, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlainTextInputIF#getMinLength() minLength} attribute.
   * @param value The value for minLength, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withMinLength(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.minLength, newValue)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, newValue, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlainTextInputIF#getMinLength() minLength} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minLength
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withMinLength(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.minLength, value)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, value, this.maxLength);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PlainTextInputIF#getMaxLength() maxLength} attribute.
   * @param value The value for maxLength, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withMaxLength(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.maxLength, newValue)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, this.minLength, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PlainTextInputIF#getMaxLength() maxLength} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for maxLength
   * @return A modified copy of {@code this} object
   */
  public final PlainTextInput withMaxLength(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.maxLength, value)) return this;
    return new PlainTextInput(this.actionId, this.placeholder, this.initialValue, this.multiline, this.minLength, value);
  }

  /**
   * This instance is equal to all instances of {@code PlainTextInput} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PlainTextInput
        && equalTo((PlainTextInput) another);
  }

  private boolean equalTo(PlainTextInput another) {
    return type.equals(another.type)
        && actionId.equals(another.actionId)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(initialValue, another.initialValue)
        && Objects.equals(multiline, another.multiline)
        && Objects.equals(minLength, another.minLength)
        && Objects.equals(maxLength, another.maxLength);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code actionId}, {@code placeholder}, {@code initialValue}, {@code multiline}, {@code minLength}, {@code maxLength}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + Objects.hashCode(placeholder);
    h = h * 17 + Objects.hashCode(initialValue);
    h = h * 17 + Objects.hashCode(multiline);
    h = h * 17 + Objects.hashCode(minLength);
    h = h * 17 + Objects.hashCode(maxLength);
    return h;
  }

  /**
   * Prints the immutable value {@code PlainTextInput} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PlainTextInput{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    if (placeholder != null) {
      builder.append(", ");
      builder.append("placeholder=").append(placeholder);
    }
    if (initialValue != null) {
      builder.append(", ");
      builder.append("initialValue=").append(initialValue);
    }
    if (multiline != null) {
      builder.append(", ");
      builder.append("multiline=").append(multiline);
    }
    if (minLength != null) {
      builder.append(", ");
      builder.append("minLength=").append(minLength);
    }
    if (maxLength != null) {
      builder.append(", ");
      builder.append("maxLength=").append(maxLength);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PlainTextInputIF {
    @Nullable String actionId;
    Optional<Text> placeholder = Optional.empty();
    Optional<String> initialValue = Optional.empty();
    Optional<Boolean> multiline = Optional.empty();
    Optional<Integer> minLength = Optional.empty();
    Optional<Integer> maxLength = Optional.empty();
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setPlaceholder(Optional<Text> placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    public void setInitialValue(Optional<String> initialValue) {
      this.initialValue = initialValue;
    }
    @JsonProperty("multiline")
    public void setMultiline(Optional<Boolean> multiline) {
      this.multiline = multiline;
    }
    @JsonProperty
    public void setMinLength(Optional<Integer> minLength) {
      this.minLength = minLength;
    }
    @JsonProperty
    public void setMaxLength(Optional<Integer> maxLength) {
      this.maxLength = maxLength;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Text> getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getInitialValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isMultiline() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getMinLength() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getMaxLength() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static PlainTextInput fromJson(Json json) {
    PlainTextInput.Builder builder = PlainTextInput.builder();
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.initialValue != null) {
      builder.setInitialValue(json.initialValue);
    }
    if (json.multiline != null) {
      builder.setMultiline(json.multiline);
    }
    if (json.minLength != null) {
      builder.setMinLength(json.minLength);
    }
    if (json.maxLength != null) {
      builder.setMaxLength(json.maxLength);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code PlainTextInput} instance.
   * @param actionId The value for the {@code actionId} attribute
   * @return An immutable PlainTextInput instance
   */
  public static PlainTextInput of(String actionId) {
    return new PlainTextInput(actionId);
  }

  /**
   * Creates an immutable copy of a {@link PlainTextInputIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PlainTextInput instance
   */
  public static PlainTextInput copyOf(PlainTextInputIF instance) {
    if (instance instanceof PlainTextInput) {
      return (PlainTextInput) instance;
    }
    return PlainTextInput.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link PlainTextInput PlainTextInput}.
   * @return A new PlainTextInput builder
   */
  public static PlainTextInput.Builder builder() {
    return new PlainTextInput.Builder();
  }

  /**
   * Builds instances of type {@link PlainTextInput PlainTextInput}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACTION_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String actionId;
    private @Nullable Text placeholder;
    private @Nullable String initialValue;
    private @Nullable Boolean multiline;
    private @Nullable Integer minLength;
    private @Nullable Integer maxLength;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PlainTextInputIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PlainTextInputIF instance) {
      Objects.requireNonNull(instance, "instance");
      setActionId(instance.getActionId());
      Optional<Text> placeholderOptional = instance.getPlaceholder();
      if (placeholderOptional.isPresent()) {
        setPlaceholder(placeholderOptional);
      }
      Optional<String> initialValueOptional = instance.getInitialValue();
      if (initialValueOptional.isPresent()) {
        setInitialValue(initialValueOptional);
      }
      Optional<Boolean> multilineOptional = instance.isMultiline();
      if (multilineOptional.isPresent()) {
        setMultiline(multilineOptional);
      }
      Optional<Integer> minLengthOptional = instance.getMinLength();
      if (minLengthOptional.isPresent()) {
        setMinLength(minLengthOptional);
      }
      Optional<Integer> maxLengthOptional = instance.getMaxLength();
      if (maxLengthOptional.isPresent()) {
        setMaxLength(maxLengthOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PlainTextInputIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPlaceholder(@Nullable Text placeholder) {
      this.placeholder = placeholder;
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Optional<Text> placeholder) {
      this.placeholder = placeholder.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getInitialValue() initialValue} to initialValue.
     * @param initialValue The value for initialValue, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialValue(@Nullable String initialValue) {
      this.initialValue = initialValue;
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getInitialValue() initialValue} to initialValue.
     * @param initialValue The value for initialValue
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialValue(Optional<String> initialValue) {
      this.initialValue = initialValue.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#isMultiline() multiline} to multiline.
     * @param multiline The value for multiline, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMultiline(@Nullable Boolean multiline) {
      this.multiline = multiline;
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#isMultiline() multiline} to multiline.
     * @param multiline The value for multiline
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMultiline(Optional<Boolean> multiline) {
      this.multiline = multiline.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getMinLength() minLength} to minLength.
     * @param minLength The value for minLength, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMinLength(@Nullable Integer minLength) {
      this.minLength = minLength;
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getMinLength() minLength} to minLength.
     * @param minLength The value for minLength
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMinLength(Optional<Integer> minLength) {
      this.minLength = minLength.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getMaxLength() maxLength} to maxLength.
     * @param maxLength The value for maxLength, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMaxLength(@Nullable Integer maxLength) {
      this.maxLength = maxLength;
      return this;
    }

    /**
     * Initializes the optional value {@link PlainTextInputIF#getMaxLength() maxLength} to maxLength.
     * @param maxLength The value for maxLength
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMaxLength(Optional<Integer> maxLength) {
      this.maxLength = maxLength.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link PlainTextInput PlainTextInput}.
     * @return An immutable instance of PlainTextInput
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public PlainTextInput build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new PlainTextInput(actionId, placeholder, initialValue, multiline, minLength, maxLength);
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build PlainTextInput, some of required attributes are not set " + attributes;
    }
  }
}
