package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link RadioButtonGroupIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code RadioButtonGroup.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code RadioButtonGroup.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "RadioButtonGroupIF"})
@Immutable
public final class RadioButtonGroup
    implements RadioButtonGroupIF {
  private final String type;
  private final String actionId;
  private final List<Option> options;
  private final @Nullable Option initialOption;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private RadioButtonGroup(
      String actionId,
      Iterable<? extends Option> options) {
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.options = createUnmodifiableList(false, createSafeList(options, true, false));
    this.initialOption = null;
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(RadioButtonGroupIF.super.getType(), "type");
  }

  private RadioButtonGroup(
      String actionId,
      List<Option> options,
      @Nullable Option initialOption,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.actionId = actionId;
    this.options = options;
    this.initialOption = initialOption;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(RadioButtonGroupIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @Override
  public List<Option> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code initialOption} attribute
   */
  @JsonProperty
  @Override
  public Optional<Option> getInitialOption() {
    return Optional.ofNullable(initialOption);
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RadioButtonGroupIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final RadioButtonGroup withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new RadioButtonGroup(newValue, this.options, this.initialOption, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RadioButtonGroupIF#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final RadioButtonGroup withOptions(Option... elements) {
    List<Option> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new RadioButtonGroup(this.actionId, newValue, this.initialOption, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link RadioButtonGroupIF#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final RadioButtonGroup withOptions(Iterable<? extends Option> elements) {
    if (this.options == elements) return this;
    List<Option> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new RadioButtonGroup(this.actionId, newValue, this.initialOption, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RadioButtonGroupIF#getInitialOption() initialOption} attribute.
   * @param value The value for initialOption, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final RadioButtonGroup withInitialOption(@Nullable Option value) {
    @Nullable Option newValue = value;
    if (this.initialOption == newValue) return this;
    return new RadioButtonGroup(this.actionId, this.options, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RadioButtonGroupIF#getInitialOption() initialOption} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialOption
   * @return A modified copy of {@code this} object
   */
  public final RadioButtonGroup withInitialOption(Optional<Option> optional) {
    @Nullable Option value = optional.orElse(null);
    if (this.initialOption == value) return this;
    return new RadioButtonGroup(this.actionId, this.options, value, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RadioButtonGroupIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final RadioButtonGroup withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new RadioButtonGroup(this.actionId, this.options, this.initialOption, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RadioButtonGroupIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final RadioButtonGroup withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new RadioButtonGroup(this.actionId, this.options, this.initialOption, value);
  }

  /**
   * This instance is equal to all instances of {@code RadioButtonGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof RadioButtonGroup
        && equalTo((RadioButtonGroup) another);
  }

  private boolean equalTo(RadioButtonGroup another) {
    return type.equals(another.type)
        && actionId.equals(another.actionId)
        && options.equals(another.options)
        && Objects.equals(initialOption, another.initialOption)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code actionId}, {@code options}, {@code initialOption}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + options.hashCode();
    h = h * 17 + Objects.hashCode(initialOption);
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code RadioButtonGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("RadioButtonGroup{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    builder.append(", ");
    builder.append("options=").append(options);
    if (initialOption != null) {
      builder.append(", ");
      builder.append("initialOption=").append(initialOption);
    }
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements RadioButtonGroupIF {
    @Nullable String actionId;
    List<Option> options = Collections.emptyList();
    Optional<Option> initialOption = Optional.empty();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setOptions(List<Option> options) {
      this.options = options;
    }
    @JsonProperty
    public void setInitialOption(Optional<Option> initialOption) {
      this.initialOption = initialOption;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Option> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Option> getInitialOption() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static RadioButtonGroup fromJson(Json json) {
    RadioButtonGroup.Builder builder = RadioButtonGroup.builder();
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    if (json.initialOption != null) {
      builder.setInitialOption(json.initialOption);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code RadioButtonGroup} instance.
   * @param actionId The value for the {@code actionId} attribute
   * @param options The value for the {@code options} attribute
   * @return An immutable RadioButtonGroup instance
   */
  public static RadioButtonGroup of(String actionId, List<Option> options) {
    return of(actionId, (Iterable<? extends Option>) options);
  }

  /**
   * Construct a new immutable {@code RadioButtonGroup} instance.
   * @param actionId The value for the {@code actionId} attribute
   * @param options The value for the {@code options} attribute
   * @return An immutable RadioButtonGroup instance
   */
  public static RadioButtonGroup of(String actionId, Iterable<? extends Option> options) {
    return new RadioButtonGroup(actionId, options);
  }

  /**
   * Creates an immutable copy of a {@link RadioButtonGroupIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RadioButtonGroup instance
   */
  public static RadioButtonGroup copyOf(RadioButtonGroupIF instance) {
    if (instance instanceof RadioButtonGroup) {
      return (RadioButtonGroup) instance;
    }
    return RadioButtonGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link RadioButtonGroup RadioButtonGroup}.
   * @return A new RadioButtonGroup builder
   */
  public static RadioButtonGroup.Builder builder() {
    return new RadioButtonGroup.Builder();
  }

  /**
   * Builds instances of type {@link RadioButtonGroup RadioButtonGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ACTION_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String actionId;
    private List<Option> options = new ArrayList<Option>();
    private @Nullable Option initialOption;
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RadioButtonGroupIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RadioButtonGroupIF instance) {
      Objects.requireNonNull(instance, "instance");
      setActionId(instance.getActionId());
      addAllOptions(instance.getOptions());
      Optional<Option> initialOptionOptional = instance.getInitialOption();
      if (initialOptionOptional.isPresent()) {
        setInitialOption(initialOptionOptional);
      }
      Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
      if (confirmationDialogOptional.isPresent()) {
        setConfirmationDialog(confirmationDialogOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link RadioButtonGroupIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Adds one element to {@link RadioButtonGroupIF#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link RadioButtonGroupIF#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option... elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link RadioButtonGroupIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends Option> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link RadioButtonGroupIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends Option> elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link RadioButtonGroupIF#getInitialOption() initialOption} to initialOption.
     * @param initialOption The value for initialOption, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialOption(@Nullable Option initialOption) {
      this.initialOption = initialOption;
      return this;
    }

    /**
     * Initializes the optional value {@link RadioButtonGroupIF#getInitialOption() initialOption} to initialOption.
     * @param initialOption The value for initialOption
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialOption(Optional<Option> initialOption) {
      this.initialOption = initialOption.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link RadioButtonGroupIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link RadioButtonGroupIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link RadioButtonGroup RadioButtonGroup}.
     * @return An immutable instance of RadioButtonGroup
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public RadioButtonGroup build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new RadioButtonGroup(actionId, createUnmodifiableList(true, options), initialOption, confirmationDialog);
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build RadioButtonGroup, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
