package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.OptionGroup;
import com.hubspot.slack.client.models.blocks.objects.OptionOrOptionGroup;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StaticSelectMenuIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code StaticSelectMenu.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code StaticSelectMenu.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StaticSelectMenuIF"})
@Immutable
public final class StaticSelectMenu
    implements StaticSelectMenuIF {
  private final String type;
  private final Text placeholder;
  private final String actionId;
  private final List<Option> options;
  private final List<OptionGroup> optionGroups;
  private final @Nullable OptionOrOptionGroup initialOption;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private StaticSelectMenu(
      Text placeholder,
      String actionId,
      Iterable<? extends Option> options) {
    this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.options = createUnmodifiableList(false, createSafeList(options, true, false));
    this.optionGroups = Collections.emptyList();
    this.initialOption = null;
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(StaticSelectMenuIF.super.getType(), "type");
  }

  private StaticSelectMenu(
      Text placeholder,
      String actionId,
      List<Option> options,
      List<OptionGroup> optionGroups,
      @Nullable OptionOrOptionGroup initialOption,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.placeholder = placeholder;
    this.actionId = actionId;
    this.options = options;
    this.optionGroups = optionGroups;
    this.initialOption = initialOption;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(StaticSelectMenuIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Text getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @Override
  public List<Option> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code optionGroups} attribute
   */
  @JsonProperty
  @Override
  public List<OptionGroup> getOptionGroups() {
    return optionGroups;
  }

  /**
   * @return The value of the {@code initialOption} attribute
   */
  @JsonProperty
  @Override
  public Optional<OptionOrOptionGroup> getInitialOption() {
    return Optional.ofNullable(initialOption);
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticSelectMenuIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param placeholder A new value for placeholder
   * @return A modified copy of the {@code this} object
   */
  public final StaticSelectMenu withPlaceholder(Text placeholder) {
    if (this.placeholder == placeholder) return this;
    Text newValue = Objects.requireNonNull(placeholder, "placeholder");
    return new StaticSelectMenu(
        newValue,
        this.actionId,
        this.options,
        this.optionGroups,
        this.initialOption,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link StaticSelectMenuIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final StaticSelectMenu withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new StaticSelectMenu(
        this.placeholder,
        newValue,
        this.options,
        this.optionGroups,
        this.initialOption,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticSelectMenuIF#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withOptions(Option... elements) {
    List<Option> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new StaticSelectMenu(
        this.placeholder,
        this.actionId,
        newValue,
        this.optionGroups,
        this.initialOption,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticSelectMenuIF#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withOptions(Iterable<? extends Option> elements) {
    if (this.options == elements) return this;
    List<Option> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new StaticSelectMenu(
        this.placeholder,
        this.actionId,
        newValue,
        this.optionGroups,
        this.initialOption,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticSelectMenuIF#getOptionGroups() optionGroups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withOptionGroups(OptionGroup... elements) {
    List<OptionGroup> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new StaticSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        newValue,
        this.initialOption,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link StaticSelectMenuIF#getOptionGroups() optionGroups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of optionGroups elements to set
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withOptionGroups(Iterable<? extends OptionGroup> elements) {
    if (this.optionGroups == elements) return this;
    List<OptionGroup> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new StaticSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        newValue,
        this.initialOption,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link StaticSelectMenuIF#getInitialOption() initialOption} attribute.
   * @param value The value for initialOption, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withInitialOption(@Nullable OptionOrOptionGroup value) {
    @Nullable OptionOrOptionGroup newValue = value;
    if (this.initialOption == newValue) return this;
    return new StaticSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        this.optionGroups,
        newValue,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link StaticSelectMenuIF#getInitialOption() initialOption} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for initialOption
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withInitialOption(Optional<OptionOrOptionGroup> optional) {
    @Nullable OptionOrOptionGroup value = optional.orElse(null);
    if (this.initialOption == value) return this;
    return new StaticSelectMenu(
        this.placeholder,
        this.actionId,
        this.options,
        this.optionGroups,
        value,
        this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link StaticSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new StaticSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, this.initialOption, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link StaticSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final StaticSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new StaticSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, this.initialOption, value);
  }

  /**
   * This instance is equal to all instances of {@code StaticSelectMenu} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof StaticSelectMenu
        && equalTo((StaticSelectMenu) another);
  }

  private boolean equalTo(StaticSelectMenu another) {
    return type.equals(another.type)
        && placeholder.equals(another.placeholder)
        && actionId.equals(another.actionId)
        && options.equals(another.options)
        && optionGroups.equals(another.optionGroups)
        && Objects.equals(initialOption, another.initialOption)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code placeholder}, {@code actionId}, {@code options}, {@code optionGroups}, {@code initialOption}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + placeholder.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + options.hashCode();
    h = h * 17 + optionGroups.hashCode();
    h = h * 17 + Objects.hashCode(initialOption);
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code StaticSelectMenu} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("StaticSelectMenu{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("placeholder=").append(placeholder);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    builder.append(", ");
    builder.append("options=").append(options);
    builder.append(", ");
    builder.append("optionGroups=").append(optionGroups);
    if (initialOption != null) {
      builder.append(", ");
      builder.append("initialOption=").append(initialOption);
    }
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements StaticSelectMenuIF {
    @Nullable Text placeholder;
    @Nullable String actionId;
    List<Option> options = Collections.emptyList();
    List<OptionGroup> optionGroups = Collections.emptyList();
    Optional<OptionOrOptionGroup> initialOption = Optional.empty();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setPlaceholder(Text placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty
    public void setOptions(List<Option> options) {
      this.options = options;
    }
    @JsonProperty
    public void setOptionGroups(List<OptionGroup> optionGroups) {
      this.optionGroups = optionGroups;
    }
    @JsonProperty
    public void setInitialOption(Optional<OptionOrOptionGroup> initialOption) {
      this.initialOption = initialOption;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public List<Option> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public List<OptionGroup> getOptionGroups() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<OptionOrOptionGroup> getInitialOption() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static StaticSelectMenu fromJson(Json json) {
    StaticSelectMenu.Builder builder = StaticSelectMenu.builder();
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    if (json.optionGroups != null) {
      builder.addAllOptionGroups(json.optionGroups);
    }
    if (json.initialOption != null) {
      builder.setInitialOption(json.initialOption);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code StaticSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @param options The value for the {@code options} attribute
   * @return An immutable StaticSelectMenu instance
   */
  public static StaticSelectMenu of(Text placeholder, String actionId, List<Option> options) {
    return of(placeholder, actionId, (Iterable<? extends Option>) options);
  }

  /**
   * Construct a new immutable {@code StaticSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @param options The value for the {@code options} attribute
   * @return An immutable StaticSelectMenu instance
   */
  public static StaticSelectMenu of(Text placeholder, String actionId, Iterable<? extends Option> options) {
    return new StaticSelectMenu(placeholder, actionId, options);
  }

  /**
   * Creates an immutable copy of a {@link StaticSelectMenuIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable StaticSelectMenu instance
   */
  public static StaticSelectMenu copyOf(StaticSelectMenuIF instance) {
    if (instance instanceof StaticSelectMenu) {
      return (StaticSelectMenu) instance;
    }
    return StaticSelectMenu.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link StaticSelectMenu StaticSelectMenu}.
   * @return A new StaticSelectMenu builder
   */
  public static StaticSelectMenu.Builder builder() {
    return new StaticSelectMenu.Builder();
  }

  /**
   * Builds instances of type {@link StaticSelectMenu StaticSelectMenu}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PLACEHOLDER = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text placeholder;
    private @Nullable String actionId;
    private List<Option> options = new ArrayList<Option>();
    private List<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
    private @Nullable OptionOrOptionGroup initialOption;
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code StaticSelectMenuIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(StaticSelectMenuIF instance) {
      Objects.requireNonNull(instance, "instance");
      setPlaceholder(instance.getPlaceholder());
      setActionId(instance.getActionId());
      addAllOptions(instance.getOptions());
      addAllOptionGroups(instance.getOptionGroups());
      Optional<OptionOrOptionGroup> initialOptionOptional = instance.getInitialOption();
      if (initialOptionOptional.isPresent()) {
        setInitialOption(initialOptionOptional);
      }
      Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
      if (confirmationDialogOptional.isPresent()) {
        setConfirmationDialog(confirmationDialogOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link StaticSelectMenuIF#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Text placeholder) {
      this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
      initBits &= ~INIT_BIT_PLACEHOLDER;
      return this;
    }

    /**
     * Initializes the value for the {@link StaticSelectMenuIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Adds one element to {@link StaticSelectMenuIF#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link StaticSelectMenuIF#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(Option... elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link StaticSelectMenuIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends Option> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link StaticSelectMenuIF#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends Option> elements) {
      for (Option element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link StaticSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param element A optionGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(OptionGroup element) {
      this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link StaticSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param elements An array of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(OptionGroup... elements) {
      for (OptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link StaticSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptionGroups(Iterable<? extends OptionGroup> elements) {
      this.optionGroups.clear();
      return addAllOptionGroups(elements);
    }

    /**
     * Adds elements to {@link StaticSelectMenuIF#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptionGroups(Iterable<? extends OptionGroup> elements) {
      for (OptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link StaticSelectMenuIF#getInitialOption() initialOption} to initialOption.
     * @param initialOption The value for initialOption, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setInitialOption(@Nullable OptionOrOptionGroup initialOption) {
      this.initialOption = initialOption;
      return this;
    }

    /**
     * Initializes the optional value {@link StaticSelectMenuIF#getInitialOption() initialOption} to initialOption.
     * @param initialOption The value for initialOption
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialOption(Optional<OptionOrOptionGroup> initialOption) {
      this.initialOption = initialOption.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link StaticSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link StaticSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link StaticSelectMenu StaticSelectMenu}.
     * @return An immutable instance of StaticSelectMenu
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public StaticSelectMenu build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new StaticSelectMenu(
          placeholder,
          actionId,
          createUnmodifiableList(true, options),
          createUnmodifiableList(true, optionGroups),
          initialOption,
          confirmationDialog);
    }

    private boolean placeholderIsSet() {
      return (initBits & INIT_BIT_PLACEHOLDER) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!placeholderIsSet()) attributes.add("placeholder");
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build StaticSelectMenu, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
