package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsersMultiSelectMenuIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsersMultiSelectMenu.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code UsersMultiSelectMenu.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsersMultiSelectMenuIF"})
@Immutable
public final class UsersMultiSelectMenu
    implements UsersMultiSelectMenuIF {
  private final String type;
  private final Text placeholder;
  private final String actionId;
  private final List<String> initialUserIds;
  private final @Nullable ConfirmationDialog confirmationDialog;

  private UsersMultiSelectMenu(Text placeholder, String actionId) {
    this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
    this.actionId = Objects.requireNonNull(actionId, "actionId");
    this.initialUserIds = Collections.emptyList();
    this.confirmationDialog = null;
    this.type = Objects.requireNonNull(UsersMultiSelectMenuIF.super.getType(), "type");
  }

  private UsersMultiSelectMenu(
      Text placeholder,
      String actionId,
      List<String> initialUserIds,
      @Nullable ConfirmationDialog confirmationDialog) {
    this.placeholder = placeholder;
    this.actionId = actionId;
    this.initialUserIds = initialUserIds;
    this.confirmationDialog = confirmationDialog;
    this.type = Objects.requireNonNull(UsersMultiSelectMenuIF.super.getType(), "type");
  }

  /**
   * @return The computed-at-construction value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Text getPlaceholder() {
    return placeholder;
  }

  /**
   * @return The value of the {@code actionId} attribute
   */
  @JsonProperty
  @Override
  public String getActionId() {
    return actionId;
  }

  /**
   * @return The value of the {@code initialUserIds} attribute
   */
  @JsonProperty("initial_users")
  @Override
  public List<String> getInitialUserIds() {
    return initialUserIds;
  }

  /**
   * @return The value of the {@code confirmationDialog} attribute
   */
  @JsonProperty("confirm")
  @Override
  public Optional<ConfirmationDialog> getConfirmationDialog() {
    return Optional.ofNullable(confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersMultiSelectMenuIF#getPlaceholder() placeholder} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param placeholder A new value for placeholder
   * @return A modified copy of the {@code this} object
   */
  public final UsersMultiSelectMenu withPlaceholder(Text placeholder) {
    if (this.placeholder == placeholder) return this;
    Text newValue = Objects.requireNonNull(placeholder, "placeholder");
    return new UsersMultiSelectMenu(newValue, this.actionId, this.initialUserIds, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsersMultiSelectMenuIF#getActionId() actionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionId A new value for actionId
   * @return A modified copy of the {@code this} object
   */
  public final UsersMultiSelectMenu withActionId(String actionId) {
    if (this.actionId.equals(actionId)) return this;
    String newValue = Objects.requireNonNull(actionId, "actionId");
    return new UsersMultiSelectMenu(this.placeholder, newValue, this.initialUserIds, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsersMultiSelectMenuIF#getInitialUserIds() initialUserIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsersMultiSelectMenu withInitialUserIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new UsersMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsersMultiSelectMenuIF#getInitialUserIds() initialUserIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of initialUserIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsersMultiSelectMenu withInitialUserIds(Iterable<String> elements) {
    if (this.initialUserIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new UsersMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsersMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * @param value The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsersMultiSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
    @Nullable ConfirmationDialog newValue = value;
    if (this.confirmationDialog == newValue) return this;
    return new UsersMultiSelectMenu(this.placeholder, this.actionId, this.initialUserIds, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsersMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for confirmationDialog
   * @return A modified copy of {@code this} object
   */
  public final UsersMultiSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
    @Nullable ConfirmationDialog value = optional.orElse(null);
    if (this.confirmationDialog == value) return this;
    return new UsersMultiSelectMenu(this.placeholder, this.actionId, this.initialUserIds, value);
  }

  /**
   * This instance is equal to all instances of {@code UsersMultiSelectMenu} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsersMultiSelectMenu
        && equalTo((UsersMultiSelectMenu) another);
  }

  private boolean equalTo(UsersMultiSelectMenu another) {
    return type.equals(another.type)
        && placeholder.equals(another.placeholder)
        && actionId.equals(another.actionId)
        && initialUserIds.equals(another.initialUserIds)
        && Objects.equals(confirmationDialog, another.confirmationDialog);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code placeholder}, {@code actionId}, {@code initialUserIds}, {@code confirmationDialog}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + placeholder.hashCode();
    h = h * 17 + actionId.hashCode();
    h = h * 17 + initialUserIds.hashCode();
    h = h * 17 + Objects.hashCode(confirmationDialog);
    return h;
  }

  /**
   * Prints the immutable value {@code UsersMultiSelectMenu} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsersMultiSelectMenu{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("placeholder=").append(placeholder);
    builder.append(", ");
    builder.append("actionId=").append(actionId);
    builder.append(", ");
    builder.append("initialUserIds=").append(initialUserIds);
    if (confirmationDialog != null) {
      builder.append(", ");
      builder.append("confirmationDialog=").append(confirmationDialog);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsersMultiSelectMenuIF {
    @Nullable Text placeholder;
    @Nullable String actionId;
    List<String> initialUserIds = Collections.emptyList();
    Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
    @JsonProperty
    public void setPlaceholder(Text placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty
    public void setActionId(String actionId) {
      this.actionId = actionId;
    }
    @JsonProperty("initial_users")
    public void setInitialUserIds(List<String> initialUserIds) {
      this.initialUserIds = initialUserIds;
    }
    @JsonProperty("confirm")
    public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Text getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionId() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getInitialUserIds() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ConfirmationDialog> getConfirmationDialog() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsersMultiSelectMenu fromJson(Json json) {
    UsersMultiSelectMenu.Builder builder = UsersMultiSelectMenu.builder();
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.actionId != null) {
      builder.setActionId(json.actionId);
    }
    if (json.initialUserIds != null) {
      builder.addAllInitialUserIds(json.initialUserIds);
    }
    if (json.confirmationDialog != null) {
      builder.setConfirmationDialog(json.confirmationDialog);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code UsersMultiSelectMenu} instance.
   * @param placeholder The value for the {@code placeholder} attribute
   * @param actionId The value for the {@code actionId} attribute
   * @return An immutable UsersMultiSelectMenu instance
   */
  public static UsersMultiSelectMenu of(Text placeholder, String actionId) {
    return new UsersMultiSelectMenu(placeholder, actionId);
  }

  /**
   * Creates an immutable copy of a {@link UsersMultiSelectMenuIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsersMultiSelectMenu instance
   */
  public static UsersMultiSelectMenu copyOf(UsersMultiSelectMenuIF instance) {
    if (instance instanceof UsersMultiSelectMenu) {
      return (UsersMultiSelectMenu) instance;
    }
    return UsersMultiSelectMenu.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsersMultiSelectMenu UsersMultiSelectMenu}.
   * @return A new UsersMultiSelectMenu builder
   */
  public static UsersMultiSelectMenu.Builder builder() {
    return new UsersMultiSelectMenu.Builder();
  }

  /**
   * Builds instances of type {@link UsersMultiSelectMenu UsersMultiSelectMenu}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PLACEHOLDER = 0x1L;
    private static final long INIT_BIT_ACTION_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text placeholder;
    private @Nullable String actionId;
    private List<String> initialUserIds = new ArrayList<String>();
    private @Nullable ConfirmationDialog confirmationDialog;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsersMultiSelectMenuIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsersMultiSelectMenuIF instance) {
      Objects.requireNonNull(instance, "instance");
      setPlaceholder(instance.getPlaceholder());
      setActionId(instance.getActionId());
      addAllInitialUserIds(instance.getInitialUserIds());
      Optional<ConfirmationDialog> confirmationDialogOptional = instance.getConfirmationDialog();
      if (confirmationDialogOptional.isPresent()) {
        setConfirmationDialog(confirmationDialogOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UsersMultiSelectMenuIF#getPlaceholder() placeholder} attribute.
     * @param placeholder The value for placeholder 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Text placeholder) {
      this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
      initBits &= ~INIT_BIT_PLACEHOLDER;
      return this;
    }

    /**
     * Initializes the value for the {@link UsersMultiSelectMenuIF#getActionId() actionId} attribute.
     * @param actionId The value for actionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionId(String actionId) {
      this.actionId = Objects.requireNonNull(actionId, "actionId");
      initBits &= ~INIT_BIT_ACTION_ID;
      return this;
    }

    /**
     * Adds one element to {@link UsersMultiSelectMenuIF#getInitialUserIds() initialUserIds} list.
     * @param element A initialUserIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInitialUserIds(String element) {
      this.initialUserIds.add(Objects.requireNonNull(element, "initialUserIds element"));
      return this;
    }

    /**
     * Adds elements to {@link UsersMultiSelectMenuIF#getInitialUserIds() initialUserIds} list.
     * @param elements An array of initialUserIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addInitialUserIds(String... elements) {
      for (String element : elements) {
        this.initialUserIds.add(Objects.requireNonNull(element, "initialUserIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link UsersMultiSelectMenuIF#getInitialUserIds() initialUserIds} list.
     * @param elements An iterable of initialUserIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setInitialUserIds(Iterable<String> elements) {
      this.initialUserIds.clear();
      return addAllInitialUserIds(elements);
    }

    /**
     * Adds elements to {@link UsersMultiSelectMenuIF#getInitialUserIds() initialUserIds} list.
     * @param elements An iterable of initialUserIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllInitialUserIds(Iterable<String> elements) {
      for (String element : elements) {
        this.initialUserIds.add(Objects.requireNonNull(element, "initialUserIds element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link UsersMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
      this.confirmationDialog = confirmationDialog;
      return this;
    }

    /**
     * Initializes the optional value {@link UsersMultiSelectMenuIF#getConfirmationDialog() confirmationDialog} to confirmationDialog.
     * @param confirmationDialog The value for confirmationDialog
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
      this.confirmationDialog = confirmationDialog.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UsersMultiSelectMenu UsersMultiSelectMenu}.
     * @return An immutable instance of UsersMultiSelectMenu
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsersMultiSelectMenu build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsersMultiSelectMenu(placeholder, actionId, createUnmodifiableList(true, initialUserIds), confirmationDialog);
    }

    private boolean placeholderIsSet() {
      return (initBits & INIT_BIT_PLACEHOLDER) == 0;
    }

    private boolean actionIdIsSet() {
      return (initBits & INIT_BIT_ACTION_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!placeholderIsSet()) attributes.add("placeholder");
      if (!actionIdIsSet()) attributes.add("actionId");
      return "Cannot build UsersMultiSelectMenu, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
